/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.hash;

import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.hash.SupportedAlgorithm;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Hasher {
    private static final Logger logger = LoggerFactory.getLogger(Hasher.class);
    private static final int _64_KB = 65536;
    private static final int CHUNK_SIZE = 65536;

    private Hasher() {
    }

    public static String hash(Path path, MessageDigest messageDigest) throws IOException {
        Hasher.updateMessageDigests(path, Arrays.asList(messageDigest));
        return Hasher.formatMessageDigest(messageDigest);
    }

    public static void hash(Path path, Map<Manifest, MessageDigest> manifestToMessageDigestMap) throws IOException {
        Hasher.updateMessageDigests(path, manifestToMessageDigestMap.values());
        Hasher.addMessageDigestHashToManifest(path, manifestToMessageDigestMap);
    }

    static void updateMessageDigests(Path path, Collection<MessageDigest> messageDigests) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(path, StandardOpenOption.READ));){
            byte[] buffer = new byte[65536];
            int read = ((InputStream)is).read(buffer);
            while (read != -1) {
                for (MessageDigest messageDigest : messageDigests) {
                    messageDigest.update(buffer, 0, read);
                }
                read = ((InputStream)is).read(buffer);
            }
        }
    }

    private static void addMessageDigestHashToManifest(Path path, Map<Manifest, MessageDigest> manifestToMessageDigestMap) {
        for (Map.Entry<Manifest, MessageDigest> entry : manifestToMessageDigestMap.entrySet()) {
            String hash = Hasher.formatMessageDigest(entry.getValue());
            logger.debug("Adding [{}] to manifest with hash [{}]", (Object)path, (Object)hash);
            entry.getKey().getFileToChecksumMap().put(path, hash);
        }
    }

    private static String formatMessageDigest(MessageDigest messageDigest) {
        try (Formatter formatter = new Formatter();){
            for (byte b : messageDigest.digest()) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }

    public static Map<Manifest, MessageDigest> createManifestToMessageDigestMap(Collection<SupportedAlgorithm> algorithms) throws NoSuchAlgorithmException {
        HashMap<Manifest, MessageDigest> map = new HashMap<Manifest, MessageDigest>();
        for (SupportedAlgorithm algorithm : algorithms) {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm.getMessageDigestName());
            Manifest manifest = new Manifest(algorithm);
            map.put(manifest, messageDigest);
        }
        return map;
    }
}

