/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.creator;

import gov.loc.repository.bagit.annotation.Incubating;
import gov.loc.repository.bagit.creator.CreatePayloadManifestsVistor;
import gov.loc.repository.bagit.creator.CreateTagManifestsVistor;
import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.domain.Version;
import gov.loc.repository.bagit.hash.Hasher;
import gov.loc.repository.bagit.hash.SupportedAlgorithm;
import gov.loc.repository.bagit.writer.BagitFileWriter;
import gov.loc.repository.bagit.writer.ManifestWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BagCreator {
    private static final Logger logger = LoggerFactory.getLogger(BagCreator.class);

    private BagCreator() {
    }

    public static Bag bagInPlace(Path root, Collection<SupportedAlgorithm> algorithms, boolean includeHidden) throws NoSuchAlgorithmException, IOException {
        Bag bag = new Bag(new Version(0, 97));
        bag.setRootDir(root);
        logger.info("Creating a bag with version: [{}] in directory: [{}]", (Object)bag.getVersion(), (Object)root);
        Path dataDir = root.resolve("data");
        Files.createDirectory(dataDir, new FileAttribute[0]);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(root);){
            for (Path path : directoryStream) {
                if ((path.equals(dataDir) || Files.isHidden(path)) && !includeHidden) continue;
                Files.move(path, dataDir.resolve(path.getFileName()), new CopyOption[0]);
            }
        }
        logger.info("Creating payload manifest(s)");
        Map<Manifest, MessageDigest> payloadFilesMap = Hasher.createManifestToMessageDigestMap(algorithms);
        CreatePayloadManifestsVistor payloadVisitor = new CreatePayloadManifestsVistor(payloadFilesMap, includeHidden);
        Files.walkFileTree(dataDir, payloadVisitor);
        bag.getPayLoadManifests().addAll(payloadFilesMap.keySet());
        BagitFileWriter.writeBagitFile(bag.getVersion(), bag.getFileEncoding(), root);
        ManifestWriter.writePayloadManifests(bag.getPayLoadManifests(), root, root, bag.getFileEncoding());
        logger.info("Creating tag manifest(s)");
        Map<Manifest, MessageDigest> tagFilesMap = Hasher.createManifestToMessageDigestMap(algorithms);
        CreateTagManifestsVistor tagVistor = new CreateTagManifestsVistor(tagFilesMap, includeHidden);
        Files.walkFileTree(root, tagVistor);
        bag.getTagManifests().addAll(tagFilesMap.keySet());
        ManifestWriter.writeTagManifests(bag.getTagManifests(), root, root, bag.getFileEncoding());
        return bag;
    }

    @Incubating
    public static Bag createDotBagit(Path root, Collection<SupportedAlgorithm> algorithms, boolean includeHidden) throws NoSuchAlgorithmException, IOException {
        Bag bag = new Bag(new Version(2, 0));
        bag.setRootDir(root);
        logger.info("Creating a bag with version: [{}] in directory: [{}]", (Object)bag.getVersion(), (Object)root);
        Path dotbagitDir = root.resolve(".bagit");
        Files.createDirectories(dotbagitDir, new FileAttribute[0]);
        logger.info("Creating payload manifest");
        Map<Manifest, MessageDigest> map = Hasher.createManifestToMessageDigestMap(algorithms);
        CreatePayloadManifestsVistor visitor = new CreatePayloadManifestsVistor(map, includeHidden);
        Files.walkFileTree(root, visitor);
        bag.getPayLoadManifests().addAll(map.keySet());
        BagitFileWriter.writeBagitFile(bag.getVersion(), bag.getFileEncoding(), dotbagitDir);
        ManifestWriter.writePayloadManifests(bag.getPayLoadManifests(), dotbagitDir, root, bag.getFileEncoding());
        logger.info("Creating tag manifest(s)");
        Map<Manifest, MessageDigest> tagFilesMap = Hasher.createManifestToMessageDigestMap(algorithms);
        CreateTagManifestsVistor tagVistor = new CreateTagManifestsVistor(tagFilesMap, includeHidden);
        Files.walkFileTree(dotbagitDir, tagVistor);
        bag.getTagManifests().addAll(tagFilesMap.keySet());
        ManifestWriter.writeTagManifests(bag.getTagManifests(), dotbagitDir, root, bag.getFileEncoding());
        return bag;
    }
}

