/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.conformance.profile;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import gov.loc.repository.bagit.conformance.profile.BagInfoRequirement;
import gov.loc.repository.bagit.conformance.profile.BagitProfile;
import gov.loc.repository.bagit.conformance.profile.Serialization;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BagitProfileDeserializer
extends StdDeserializer<BagitProfile> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(BagitProfileDeserializer.class);

    public BagitProfileDeserializer() {
        this(null);
    }

    public BagitProfileDeserializer(Class<?> vc) {
        super(vc);
    }

    public BagitProfile deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        BagitProfile profile = new BagitProfile();
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        BagitProfileDeserializer.parseBagitProfileInfo(node, profile);
        profile.setBagInfoRequirements(BagitProfileDeserializer.parseBagInfo(node));
        profile.getManifestTypesRequired().addAll(BagitProfileDeserializer.parseManifestTypesRequired(node));
        profile.setFetchFileAllowed(node.get("Allow-Fetch.txt").asBoolean());
        logger.debug("Are fetch files allowed? {}", (Object)profile.isFetchFileAllowed());
        profile.setSerialization(Serialization.valueOf(node.get("Serialization").asText()));
        logger.debug("Serialization allowed [{}]", (Object)profile.getSerialization());
        profile.getAcceptableMIMESerializationTypes().addAll(BagitProfileDeserializer.parseAcceptableSerializationFormats(node));
        profile.getTagManifestTypesRequired().addAll(BagitProfileDeserializer.parseRequiredTagmanifestTypes(node));
        profile.getTagFilesRequired().addAll(BagitProfileDeserializer.parseRequiredTagFiles(node));
        profile.getAcceptableBagitVersions().addAll(BagitProfileDeserializer.parseAcceptableVersions(node));
        return profile;
    }

    private static void parseBagitProfileInfo(JsonNode node, BagitProfile profile) {
        JsonNode bagitProfileInfoNode = node.get("BagIt-Profile-Info");
        logger.debug("Parsing the BagIt-Profile-Info section");
        String profileIdentifier = bagitProfileInfoNode.get("BagIt-Profile-Identifier").asText();
        logger.debug("Identifier is [{}]", (Object)profileIdentifier);
        profile.setBagitProfileIdentifier(profileIdentifier);
        String sourceOrg = bagitProfileInfoNode.get("Source-Organization").asText();
        logger.debug("Source-Organization is [{}]", (Object)sourceOrg);
        profile.setSourceOrganization(sourceOrg);
        String contactName = bagitProfileInfoNode.get("Contact-Name").asText();
        logger.debug("Contact-Name is [{}]", (Object)contactName);
        profile.setContactName(contactName);
        String contactEmail = bagitProfileInfoNode.get("Contact-Email").asText();
        logger.debug("Contact-Email is [{}]", (Object)contactEmail);
        profile.setContactEmail(contactEmail);
        String extDescript = bagitProfileInfoNode.get("External-Description").asText();
        logger.debug("External-Description is [{}]", (Object)extDescript);
        profile.setExternalDescription(extDescript);
        String version = bagitProfileInfoNode.get("Version").asText();
        logger.debug("Version is [{}]", (Object)version);
        profile.setVersion(version);
    }

    private static Map<String, BagInfoRequirement> parseBagInfo(JsonNode rootNode) {
        JsonNode bagInfoNode = rootNode.get("Bag-Info");
        logger.debug("Parsing the Bag-Info section");
        HashMap<String, BagInfoRequirement> bagInfo = new HashMap<String, BagInfoRequirement>();
        Iterator nodes = bagInfoNode.fields();
        while (nodes.hasNext()) {
            Map.Entry node = (Map.Entry)nodes.next();
            BagInfoRequirement entry = new BagInfoRequirement();
            entry.setRequired(((JsonNode)node.getValue()).get("required").asBoolean());
            JsonNode valuesNode = ((JsonNode)node.getValue()).get("values");
            if (valuesNode != null) {
                for (JsonNode value : valuesNode) {
                    entry.getAcceptableValues().add(value.asText());
                }
            }
            logger.debug("{}: {}", node.getKey(), (Object)entry);
            bagInfo.put((String)node.getKey(), entry);
        }
        return bagInfo;
    }

    private static List<String> parseManifestTypesRequired(JsonNode node) {
        JsonNode manifests = node.get("Manifests-Required");
        ArrayList<String> manifestTypes = new ArrayList<String>();
        for (JsonNode manifestName : manifests) {
            manifestTypes.add(manifestName.asText());
        }
        logger.debug("Required manifest types {}", manifestTypes);
        return manifestTypes;
    }

    private static List<String> parseAcceptableSerializationFormats(JsonNode node) {
        JsonNode serialiationFormats = node.get("Accept-Serialization");
        ArrayList<String> serialTypes = new ArrayList<String>();
        for (JsonNode serialiationFormat : serialiationFormats) {
            serialTypes.add(serialiationFormat.asText());
        }
        logger.debug("Acceptable serialization MIME types are {}", serialTypes);
        return serialTypes;
    }

    private static List<String> parseRequiredTagmanifestTypes(JsonNode node) {
        JsonNode tagManifestsRequiredNodes = node.get("Tag-Manifests-Required");
        ArrayList<String> requiredTagmanifestTypes = new ArrayList<String>();
        for (JsonNode tagManifestsRequiredNode : tagManifestsRequiredNodes) {
            requiredTagmanifestTypes.add(tagManifestsRequiredNode.asText());
        }
        logger.debug("Required Tagmanifest types are {}", requiredTagmanifestTypes);
        return requiredTagmanifestTypes;
    }

    private static List<String> parseRequiredTagFiles(JsonNode node) {
        JsonNode tagFilesRequiredNodes = node.get("Tag-Files-Required");
        ArrayList<String> requiredTagFiles = new ArrayList<String>();
        for (JsonNode tagFilesRequiredNode : tagFilesRequiredNodes) {
            requiredTagFiles.add(tagFilesRequiredNode.asText());
        }
        logger.debug("Tag files required are {}", requiredTagFiles);
        return requiredTagFiles;
    }

    private static List<String> parseAcceptableVersions(JsonNode node) {
        JsonNode acceptableVersionsNodes = node.get("Accept-BagIt-Version");
        ArrayList<String> acceptableVersions = new ArrayList<String>();
        for (JsonNode acceptableVersionsNode : acceptableVersionsNodes) {
            acceptableVersions.add(acceptableVersionsNode.asText());
        }
        logger.debug("Acceptable bagit versions are {}", acceptableVersions);
        return acceptableVersions;
    }
}

