/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.conformance;

import gov.loc.repository.bagit.conformance.BagitWarning;
import gov.loc.repository.bagit.domain.Version;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface VersionChecker {
    public static final Logger logger = LoggerFactory.getLogger(VersionChecker.class);
    public static final Version LATEST_BAGIT_VERSION = new Version(0, 97);

    public static void checkVersion(Version version, Set<BagitWarning> warnings, Collection<BagitWarning> warningsToIgnore) {
        if (!warningsToIgnore.contains((Object)BagitWarning.OLD_BAGIT_VERSION) && version.isOlder(LATEST_BAGIT_VERSION)) {
            logger.warn("Found version [{}] of the bagit specification but the latest version is [{}].", (Object)version, (Object)LATEST_BAGIT_VERSION);
            warnings.add(BagitWarning.OLD_BAGIT_VERSION);
        }
    }
}

