/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.conformance;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import gov.loc.repository.bagit.conformance.profile.BagInfoRequirement;
import gov.loc.repository.bagit.conformance.profile.BagitProfile;
import gov.loc.repository.bagit.conformance.profile.BagitProfileDeserializer;
import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.FetchItem;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.domain.Metadata;
import gov.loc.repository.bagit.exceptions.conformance.BagitVersionIsNotAcceptableException;
import gov.loc.repository.bagit.exceptions.conformance.FetchFileNotAllowedException;
import gov.loc.repository.bagit.exceptions.conformance.MetatdataValueIsNotAcceptableException;
import gov.loc.repository.bagit.exceptions.conformance.RequiredManifestNotPresentException;
import gov.loc.repository.bagit.exceptions.conformance.RequiredMetadataFieldNotPresentException;
import gov.loc.repository.bagit.exceptions.conformance.RequiredTagFileNotPresentException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BagProfileChecker {
    private static final Logger logger = LoggerFactory.getLogger(BagProfileChecker.class);

    private BagProfileChecker() {
    }

    public static void bagConformsToProfile(InputStream jsonProfile, Bag bag) throws JsonParseException, JsonMappingException, IOException, FetchFileNotAllowedException, RequiredMetadataFieldNotPresentException, MetatdataValueIsNotAcceptableException, RequiredManifestNotPresentException, BagitVersionIsNotAcceptableException, RequiredTagFileNotPresentException {
        BagitProfile profile = BagProfileChecker.parseBagitProfile(jsonProfile);
        BagProfileChecker.checkFetch(bag.getRootDir(), profile.isFetchFileAllowed(), bag.getItemsToFetch());
        BagProfileChecker.checkMetadata(bag.getMetadata(), profile.getBagInfoRequirements());
        BagProfileChecker.requiredManifestsExist(bag.getPayLoadManifests(), profile.getManifestTypesRequired(), true);
        BagProfileChecker.requiredManifestsExist(bag.getTagManifests(), profile.getTagManifestTypesRequired(), false);
        if (!profile.getAcceptableBagitVersions().contains(bag.getVersion().toString())) {
            throw new BagitVersionIsNotAcceptableException("Version [" + bag.getVersion().toString() + "] is not in the acceptable list of " + profile.getAcceptableBagitVersions());
        }
        BagProfileChecker.requiredTagFilesExist(bag.getRootDir(), profile.getTagFilesRequired());
    }

    private static BagitProfile parseBagitProfile(InputStream jsonProfile) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(BagitProfile.class, (JsonDeserializer)new BagitProfileDeserializer());
        mapper.registerModule((Module)module);
        return (BagitProfile)mapper.readValue(jsonProfile, BagitProfile.class);
    }

    private static void checkFetch(Path rootDir, boolean allowFetchFile, List<FetchItem> itemsToFetch) throws FetchFileNotAllowedException {
        logger.debug("Checking if the fetch file is allowed for bag [{}]", (Object)rootDir);
        if (!allowFetchFile && !itemsToFetch.isEmpty()) {
            throw new FetchFileNotAllowedException("Fetch File was found in bag [" + rootDir + "]");
        }
    }

    private static void checkMetadata(Metadata bagMetadata, Map<String, BagInfoRequirement> bagInfoEntryRequirements) throws RequiredMetadataFieldNotPresentException, MetatdataValueIsNotAcceptableException {
        for (Map.Entry<String, BagInfoRequirement> bagInfoEntryRequirement : bagInfoEntryRequirements.entrySet()) {
            boolean metadataContainsKey = bagMetadata.contains(bagInfoEntryRequirement.getKey());
            logger.debug("Checking if [{}] is required in the bag metadata", (Object)bagInfoEntryRequirement.getKey());
            if (bagInfoEntryRequirement.getValue().isRequired() && !metadataContainsKey) {
                throw new RequiredMetadataFieldNotPresentException("Profile specifies metadata field [" + bagInfoEntryRequirement.getKey() + "] is required but was not found!");
            }
            if (bagInfoEntryRequirement.getValue().getAcceptableValues().isEmpty()) continue;
            logger.debug("Checking if all the values listed for [{}] are acceptable", (Object)bagInfoEntryRequirement.getKey());
            for (String metadataValue : bagMetadata.get(bagInfoEntryRequirement.getKey())) {
                if (bagInfoEntryRequirement.getValue().getAcceptableValues().contains(metadataValue)) continue;
                throw new MetatdataValueIsNotAcceptableException("Profile specifies that acceptable values for [" + bagInfoEntryRequirement.getKey() + "] are " + bagInfoEntryRequirement.getValue().getAcceptableValues() + " but found [" + metadataValue + "]");
            }
        }
    }

    private static void requiredManifestsExist(Set<Manifest> manifests, List<String> requiredManifestTypes, boolean isPayloadManifest) throws RequiredManifestNotPresentException {
        HashSet<String> manifestTypesPresent = new HashSet<String>();
        logger.debug("Checking if all the required manifests are present");
        for (Manifest manifest : manifests) {
            manifestTypesPresent.add(manifest.getAlgorithm().getBagitName());
        }
        for (String requiredManifestType : requiredManifestTypes) {
            if (manifestTypesPresent.contains(requiredManifestType)) continue;
            StringBuilder sb = new StringBuilder(25);
            sb.append("Required ");
            if (isPayloadManifest) {
                sb.append("tag");
            }
            sb.append("manifest type [").append(requiredManifestType).append("] was not present");
            throw new RequiredManifestNotPresentException(sb.toString());
        }
    }

    private static void requiredTagFilesExist(Path rootDir, List<String> requiredTagFilePaths) throws RequiredTagFileNotPresentException {
        logger.debug("Checking if all the required tag files exist");
        for (String requiredTagFilePath : requiredTagFilePaths) {
            Path requiredTagFile = rootDir.resolve(requiredTagFilePath);
            if (Files.exists(requiredTagFile, new LinkOption[0])) continue;
            throw new RequiredTagFileNotPresentException("Required tag file [" + requiredTagFilePath + "] was not found");
        }
    }
}

