/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.writer;

import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.FetchItem;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.verify.Verifier;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BagWriter {
    private static final Logger logger = LoggerFactory.getLogger(Verifier.class);

    public static void write(Bag bag, File outputDir) throws IOException {
        BagWriter.writeBagitFile(bag.getVersion(), bag.getFileEncoding(), outputDir);
        BagWriter.writePayloadManifests(bag.getPayLoadManifests(), outputDir, bag.getFileEncoding());
        BagWriter.writePayloadFiles(bag.getPayLoadManifests(), outputDir);
        if (bag.getTagManifests().size() > 0) {
            BagWriter.writeTagManifests(bag.getTagManifests(), outputDir, bag.getFileEncoding());
        }
        if (bag.getMetadata().size() > 0) {
            BagWriter.writeBagitInfoFile(bag.getMetadata(), outputDir, bag.getFileEncoding());
        }
        if (bag.getItemsToFetch().size() > 0) {
            BagWriter.writeFetchFile(bag.getItemsToFetch(), outputDir, bag.getFileEncoding());
        }
    }

    public static void writeBagitFile(String version, String encoding, File outputDir) throws IOException {
        logger.debug("Writing bagit.txt file to [{}]", (Object)outputDir);
        Path bagitPath = Paths.get(outputDir.getPath(), "bagit.txt");
        String firstLine = "BagIt-Version : " + version + System.lineSeparator();
        logger.debug("Writing line [{}] to [{}]", (Object)firstLine, (Object)bagitPath);
        Files.write(bagitPath, firstLine.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        String secondLine = "Tag-File-Character-Encoding : " + encoding + System.lineSeparator();
        logger.debug("Writing line [{}] to [{}]", (Object)secondLine, (Object)bagitPath);
        Files.write(bagitPath, secondLine.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.APPEND);
    }

    public static void writePayloadFiles(Set<Manifest> payloadManifests, File outputDir) throws IOException {
        for (Manifest payloadManifest : payloadManifests) {
            for (File payloadFile : payloadManifest.getFileToChecksumMap().keySet()) {
                Path writeToPath = Paths.get(outputDir.getPath(), BagWriter.getPathRelativeToDataDir(payloadFile));
                logger.debug("Writing payload file [{}] to [{}]", (Object)payloadFile, (Object)writeToPath);
                Path parent = writeToPath.getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.copy(Paths.get(payloadFile.toURI()), writeToPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    public static void writePayloadManifests(Set<Manifest> manifests, File outputDir, String charsetName) throws IOException {
        BagWriter.writeManifests(manifests, outputDir, "manifest-", charsetName);
    }

    public static void writeTagManifests(Set<Manifest> tagManifests, File outputDir, String charsetName) throws IOException {
        BagWriter.writeManifests(tagManifests, outputDir, "tagmanifest-", charsetName);
    }

    protected static void writeManifests(Set<Manifest> tagManifests, File outputDir, String filenameBase, String charsetName) throws IOException {
        for (Manifest manifest : tagManifests) {
            Path manifestPath = Paths.get(outputDir.getPath(), filenameBase + manifest.getAlgorithm() + ".txt");
            logger.debug("Writing manifest to [{}]", (Object)manifestPath);
            for (Map.Entry<File, String> entry : manifest.getFileToChecksumMap().entrySet()) {
                String line = entry.getValue() + " " + BagWriter.getPathRelativeToDataDir(entry.getKey()) + System.lineSeparator();
                logger.debug("Writing [{}] to [{}]", (Object)line, (Object)manifestPath);
                Files.write(manifestPath, line.getBytes(Charset.forName(charsetName)), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
            }
        }
    }

    public static void writeBagitInfoFile(LinkedHashMap<String, String> metadata, File outputDir, String charsetName) throws IOException {
        logger.debug("Writing bag-info.txt to [{}]", (Object)outputDir);
        Path outputPath = Paths.get(outputDir.getPath(), "bag-info.txt");
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            String line = entry.getKey() + " : " + entry.getValue() + System.lineSeparator();
            logger.debug("Writing [{}] to [{}]", (Object)line, (Object)outputPath);
            Files.write(outputPath, line.getBytes(Charset.forName(charsetName)), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
    }

    public static void writeFetchFile(List<FetchItem> itemsToFetch, File outputDir, String charsetName) throws IOException {
        logger.debug("Writing fetch.txt to [{}]", (Object)outputDir);
        Path outputPath = Paths.get(outputDir.getPath(), "fetch.txt");
        for (FetchItem item : itemsToFetch) {
            String line = item.toString();
            logger.debug("Writing [{}] to [{}]", (Object)line, (Object)outputPath);
            Files.write(outputPath, line.getBytes(Charset.forName(charsetName)), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
    }

    protected static String getPathRelativeToDataDir(File file) {
        String path = file.getPath();
        int index = path.indexOf("data");
        if (index == -1) {
            return file.getName();
        }
        return path.substring(index, path.length());
    }
}

