/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify;

import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.domain.SupportedAlgorithms;
import gov.loc.repository.bagit.exceptions.FileNotInPayloadDirectoryException;
import gov.loc.repository.bagit.exceptions.MissingBagitFileException;
import gov.loc.repository.bagit.exceptions.MissingPayloadDirectoryException;
import gov.loc.repository.bagit.exceptions.MissingPayloadManifestException;
import gov.loc.repository.bagit.reader.BagReader;
import gov.loc.repository.bagit.tasks.CheckIfFileExistsTask;
import gov.loc.repository.bagit.tasks.CheckManifestHashsTask;
import gov.loc.repository.bagit.verify.PayloadFileExistsInManifestVistor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Verifier {
    private static final Logger logger = LoggerFactory.getLogger(Verifier.class);
    private static final String PAYLOAD_DIR_NAME = "data";

    public static void isValid(Bag bag, boolean ignoreHiddenFiles) throws Exception {
        logger.info("Checking if the bag with root directory [{}] is valid.", (Object)bag.getRootDir());
        Verifier.isComplete(bag, ignoreHiddenFiles);
        logger.debug("Checking payload manifest(s) checksums");
        for (Manifest payloadManifest : bag.getPayLoadManifests()) {
            Verifier.checkHashes(payloadManifest);
        }
        logger.debug("Checking tag manifest(s) checksums");
        for (Manifest tagManifest : bag.getTagManifests()) {
            Verifier.checkHashes(tagManifest);
        }
    }

    protected static void checkHashes(Manifest manifest) throws Exception {
        SupportedAlgorithms algorithm = SupportedAlgorithms.valueOf(manifest.getAlgorithm().toUpperCase());
        logger.debug("Checking manifest using algorithm {}", (Object)algorithm.getMessageDigestName());
        ExecutorService executor = Executors.newCachedThreadPool();
        CountDownLatch latch = new CountDownLatch(manifest.getFileToChecksumMap().size());
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Map.Entry<File, String> entry : manifest.getFileToChecksumMap().entrySet()) {
            executor.execute(new CheckManifestHashsTask(entry, algorithm.getMessageDigestName(), latch, exceptions));
        }
        latch.await();
        if (exceptions.size() > 0) {
            throw (Exception)exceptions.get(0);
        }
    }

    public static void isComplete(Bag bag, boolean ignoreHiddenFiles) throws IOException, MissingPayloadManifestException, MissingBagitFileException, MissingPayloadDirectoryException, FileNotInPayloadDirectoryException, InterruptedException {
        logger.info("Checking if the bag with root directory [{}] is complete.", (Object)bag.getRootDir());
        Verifier.checkBagitFileExists(bag.getRootDir());
        Verifier.checkPayloadDirectoryExists(bag.getRootDir());
        Verifier.checkIfAtLeastOnePayloadManifestsExist(bag.getRootDir());
        Set<File> allFilesListedInManifests = Verifier.getAllFilesListedInManifests(bag);
        Verifier.checkAllFilesListedInManifestExist(allFilesListedInManifests);
        Verifier.checkAllFilesInPayloadDirAreListedInAManifest(allFilesListedInManifests, bag.getRootDir(), ignoreHiddenFiles);
    }

    protected static void checkBagitFileExists(File rootDir) throws MissingBagitFileException {
        File bagitFile = new File(rootDir, "bagit.txt");
        if (!bagitFile.exists()) {
            throw new MissingBagitFileException("File [" + bagitFile + "] should exist but it doesn't");
        }
    }

    protected static void checkPayloadDirectoryExists(File rootDir) throws MissingPayloadDirectoryException {
        File dataDir = new File(rootDir, PAYLOAD_DIR_NAME);
        if (!dataDir.exists()) {
            throw new MissingPayloadDirectoryException("File [" + dataDir + "] should exist but it doesn't");
        }
    }

    protected static void checkIfAtLeastOnePayloadManifestsExist(File rootDir) throws MissingPayloadManifestException {
        boolean hasAtLeastOneManifest = false;
        String[] filenames = rootDir.list();
        if (filenames != null) {
            for (String filename : filenames) {
                if (!filename.matches("manifest\\-.*\\.txt")) continue;
                logger.debug("Found payload manifest file [{}]", (Object)filename);
                hasAtLeastOneManifest = true;
            }
        }
        if (!hasAtLeastOneManifest) {
            throw new MissingPayloadManifestException("Bag does not contain any payload manifest files");
        }
    }

    protected static Set<File> getAllFilesListedInManifests(Bag bag) throws IOException {
        HashSet<File> filesListedInManifests = new HashSet<File>();
        File[] files = bag.getRootDir().listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().matches("(tag)?manifest\\-.*\\.txt")) continue;
                logger.debug("Getting files and checksums listed in [{}]", (Object)file);
                Manifest manifest = BagReader.readManifest(file);
                filesListedInManifests.addAll(manifest.getFileToChecksumMap().keySet());
            }
        }
        return filesListedInManifests;
    }

    protected static void checkAllFilesListedInManifestExist(Set<File> files) throws FileNotInPayloadDirectoryException, InterruptedException {
        ExecutorService executor = Executors.newCachedThreadPool();
        CountDownLatch latch = new CountDownLatch(files.size());
        StringBuilder messageBuilder = new StringBuilder();
        logger.debug("Checking if all files listed in the manifest(s) exist");
        for (File file : files) {
            executor.execute(new CheckIfFileExistsTask(file, messageBuilder, latch));
        }
        latch.await();
        String missingFilesMessage = messageBuilder.toString();
        if (!missingFilesMessage.isEmpty()) {
            throw new FileNotInPayloadDirectoryException(missingFilesMessage);
        }
    }

    protected static void checkAllFilesInPayloadDirAreListedInAManifest(Set<File> filesListedInManifests, File rootDir, boolean ignoreHiddenFiles) throws IOException {
        File payloadDir = new File(rootDir, PAYLOAD_DIR_NAME);
        logger.debug("Checking if all payload files (files in /data dir) are listed in at least one manifest");
        if (payloadDir.exists()) {
            Path start = Paths.get(payloadDir.toURI());
            Files.walkFileTree(start, new PayloadFileExistsInManifestVistor(filesListedInManifests, ignoreHiddenFiles));
        }
    }

    static {
        logger.debug("Adding bouncy castle crypo provider to enable SHA3 support");
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

