/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.tasks;

import gov.loc.repository.bagit.exceptions.CorruptChecksumException;
import gov.loc.repository.bagit.hash.Hasher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckManifestHashsTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CheckManifestHashsTask.class);
    private final Map.Entry<File, String> entry;
    private final CountDownLatch latch;
    private final List<Exception> exceptions;
    private final String algorithm;

    public CheckManifestHashsTask(Map.Entry<File, String> entry, String algorithm, CountDownLatch latch, List<Exception> exceptions) {
        this.entry = entry;
        this.algorithm = algorithm;
        this.latch = latch;
        this.exceptions = exceptions;
    }

    @Override
    public void run() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm);
            CheckManifestHashsTask.checkManifestEntry(this.entry, messageDigest, this.algorithm);
        }
        catch (Exception e) {
            this.exceptions.add(e);
        }
        this.latch.countDown();
    }

    protected static void checkManifestEntry(Map.Entry<File, String> entry, MessageDigest messageDigest, String algorithm) throws IOException, CorruptChecksumException {
        if (entry.getKey().exists()) {
            logger.debug("Checking file [{}] to see if checksum matches [{}]", (Object)entry.getKey(), (Object)entry.getValue());
            InputStream inputStream = Files.newInputStream(Paths.get(entry.getKey().toURI()), StandardOpenOption.READ);
            String hash = Hasher.hash(inputStream, messageDigest);
            if (!hash.equals(entry.getValue())) {
                throw new CorruptChecksumException("File [" + entry.getKey() + "] is suppose to have a " + algorithm + " hash of [" + entry.getValue() + "] but was computed [" + hash + "]");
            }
        }
    }
}

