/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.hash;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Formatter;

public class Hasher {
    public static String hash(InputStream inputStream, MessageDigest messageDigest) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(inputStream);){
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = ((InputStream)is).read(buffer)) != -1) {
                messageDigest.update(buffer, 0, read);
            }
        }
        return Hasher.formatMessageDigest(messageDigest);
    }

    protected static String formatMessageDigest(MessageDigest messageDigest) {
        try (Formatter formatter = new Formatter();){
            for (byte b : messageDigest.digest()) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }
}

