/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.domain;

import gov.loc.repository.bagit.domain.FetchItem;
import gov.loc.repository.bagit.domain.Manifest;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Bag {
    private String version;
    private String fileEncoding = StandardCharsets.UTF_8.name();
    private Set<Manifest> payLoadManifests = new HashSet<Manifest>();
    private Set<Manifest> tagManifests = new HashSet<Manifest>();
    private List<FetchItem> itemsToFetch = new ArrayList<FetchItem>();
    private LinkedHashMap<String, String> metadata = new LinkedHashMap();
    private File rootDir;

    public Bag() {
        this.version = "0.97";
    }

    public Bag(String version) {
        this.version = version;
    }

    public Bag(Bag bag) {
        this.version = bag.getVersion();
        this.fileEncoding = bag.fileEncoding;
        this.itemsToFetch = bag.getItemsToFetch();
        this.metadata = bag.getMetadata();
        this.payLoadManifests = bag.getPayLoadManifests();
        this.tagManifests = bag.getTagManifests();
        this.rootDir = bag.getRootDir();
    }

    public String getVersion() {
        return this.version;
    }

    public Set<Manifest> getPayLoadManifests() {
        return this.payLoadManifests;
    }

    public void setPayLoadManifests(Set<Manifest> payLoadManifests) {
        this.payLoadManifests = payLoadManifests;
    }

    public Set<Manifest> getTagManifests() {
        return this.tagManifests;
    }

    public void setTagManifests(Set<Manifest> tagManifests) {
        this.tagManifests = tagManifests;
    }

    public List<FetchItem> getItemsToFetch() {
        return this.itemsToFetch;
    }

    public void setItemsToFetch(List<FetchItem> itemsToFetch) {
        this.itemsToFetch = itemsToFetch;
    }

    public LinkedHashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(LinkedHashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String fileEncoding) {
        this.fileEncoding = fileEncoding;
    }

    public String toString() {
        return "Bag [version=" + this.version + ", fileEncoding=" + this.fileEncoding + ", payLoadManifests=" + this.payLoadManifests + ", tagManifests=" + this.tagManifests + ", itemsToFetch=" + this.itemsToFetch + ", metadata=" + this.metadata + "]";
    }

    public int hashCode() {
        return Objects.hash(this.version) + Objects.hash(this.fileEncoding) + Objects.hash(this.payLoadManifests) + Objects.hash(this.tagManifests) + Objects.hash(this.itemsToFetch) + Objects.hash(this.metadata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bag)) {
            return false;
        }
        Bag other = (Bag)obj;
        return Objects.equals(this.version, other.getVersion()) && Objects.equals(this.fileEncoding, other.getFileEncoding()) && Objects.equals(this.payLoadManifests, other.getPayLoadManifests()) && Objects.equals(this.tagManifests, other.getTagManifests()) && Objects.equals(this.itemsToFetch, other.getItemsToFetch()) && Objects.equals(this.metadata, other.getMetadata());
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

