/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.creator;

import gov.loc.repository.bagit.creator.AddPayloadToBagManifestVistor;
import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.domain.SupportedAlgorithms;
import gov.loc.repository.bagit.verify.Verifier;
import gov.loc.repository.bagit.writer.BagWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BagCreator {
    private static final Logger logger = LoggerFactory.getLogger(Verifier.class);

    public static Bag bagInPlace(File root, SupportedAlgorithms algorithm, boolean includeHidden) throws NoSuchAlgorithmException, IOException {
        Bag bag = new Bag();
        bag.setRootDir(root);
        File[] files = root.listFiles();
        File dataDir = new File(root, "data");
        if (!dataDir.exists() && !dataDir.mkdir()) {
            throw new IOException("Unable to make " + dataDir);
        }
        BagCreator.moveFilesToDataDir(files, dataDir);
        Manifest manifest = new Manifest(algorithm.name().toLowerCase());
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm.getMessageDigestName());
        AddPayloadToBagManifestVistor visitor = new AddPayloadToBagManifestVistor(manifest, messageDigest, includeHidden);
        Files.walkFileTree(Paths.get(dataDir.toURI()), visitor);
        bag.getPayLoadManifests().add(manifest);
        BagWriter.writeBagitFile(bag.getVersion(), bag.getFileEncoding(), root);
        BagWriter.writePayloadManifests(bag.getPayLoadManifests(), root, bag.getFileEncoding());
        return bag;
    }

    protected static void moveFilesToDataDir(File[] files, File dataDir) throws IOException {
        if (files != null) {
            for (File file : files) {
                Path dest = Paths.get(dataDir.getPath(), file.getName());
                logger.debug("Moving [{}] to [{}]", (Object)file, (Object)dest);
                Files.move(Paths.get(file.toURI()), dest, new CopyOption[0]);
            }
        }
    }
}

