/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.writer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import gov.loc.repository.bagit.writer.Writer;
import gov.loc.repository.bagit.writer.impl.AbstractWriterTest;
import gov.loc.repository.bagit.writer.impl.ZipWriter;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZipBagWriterTest
extends AbstractWriterTest {
    File bagFile;

    @Override
    @Before
    public void setUp() throws Exception {
        this.bagFile = new File(ResourceHelper.getFile("bags"), "foo.zip");
    }

    @Override
    public File getBagFile() {
        return this.bagFile;
    }

    @Override
    public Writer getBagWriter() {
        return new ZipWriter(this.bagFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompress() throws Exception {
        Bag bag = this.bagFactory.createBag(ResourceHelper.getFile("bags/v0_95/bag"));
        try {
            ZipWriter writer = new ZipWriter(this.bagFactory);
            File uncompressedBagFile = new File(ResourceHelper.getFile("bags"), "uncompressed.zip");
            writer.write(bag, uncompressedBagFile);
            File compressedBagFile = new File(ResourceHelper.getFile("bags"), "compressed.zip");
            writer.setCompressionLevel(Integer.valueOf(1));
            writer.write(bag, compressedBagFile);
            Assert.assertTrue((compressedBagFile.length() < uncompressedBagFile.length() ? 1 : 0) != 0);
        }
        finally {
            bag.close();
        }
    }
}

