/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.writer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.transformer.impl.UpdateCompleter;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import gov.loc.repository.bagit.writer.Writer;
import gov.loc.repository.bagit.writer.impl.AbstractWriterTest;
import gov.loc.repository.bagit.writer.impl.FileSystemWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileSystemWriterTest
extends AbstractWriterTest {
    File bagDir;
    private static int testCounter = 0;

    @Override
    @Before
    public void setUp() throws Exception {
        this.bagDir = new File(ResourceHelper.getFile("bags"), "writer_test" + ++testCounter);
    }

    @Override
    public File getBagFile() {
        return this.bagDir;
    }

    @Override
    public Writer getBagWriter() {
        return new FileSystemWriter(this.bagFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverwriteWithChange() throws Exception {
        Bag bag = this.bagFactory.createBag(ResourceHelper.getFile("bags/v0_95/bag"));
        Bag newBag = null;
        Bag newBag2 = null;
        Bag newBag3 = null;
        try {
            Writer writer = this.getBagWriter();
            newBag = writer.write(bag, this.getBagFile());
            Assert.assertTrue((boolean)newBag.verifyValid().isSuccess());
            File newFile = new File(this.getBagFile(), "data/test3.txt");
            FileWriter fileWriter = new FileWriter(newFile);
            fileWriter.write("test");
            fileWriter.close();
            Assert.assertTrue((boolean)newFile.exists());
            File newDir = new File(this.getBagFile(), "data/dir3");
            FileUtils.forceMkdir((File)newDir);
            Assert.assertTrue((boolean)newDir.exists());
            File removeFile = new File(this.getBagFile(), "data/test1.txt");
            Assert.assertTrue((boolean)removeFile.exists());
            newBag.removeBagFile("data/test1.txt");
            Assert.assertFalse((boolean)newBag.verifyValid().isSuccess());
            newBag2 = newBag.makeComplete();
            newBag3 = writer.write(newBag2, this.getBagFile());
            Assert.assertTrue((boolean)newBag3.verifyValid().isSuccess());
            Assert.assertFalse((boolean)newFile.exists());
            Assert.assertTrue((boolean)newDir.exists());
            Assert.assertFalse((boolean)removeFile.exists());
        }
        finally {
            bag.close();
            if (newBag != null) {
                newBag.close();
            }
            if (newBag2 != null) {
                newBag2.close();
            }
            if (newBag3 != null) {
                newBag3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteTagsOnly() throws Exception {
        Bag bag = this.bagFactory.createBag(ResourceHelper.getFile("bags/v0_95/bag"));
        Bag newBag = null;
        Bag newBag2 = null;
        try {
            Writer writer = this.getBagWriter();
            newBag = writer.write(bag, this.getBagFile());
            Assert.assertTrue((boolean)newBag.verifyValid().isSuccess());
            File newFile = new File(this.getBagFile(), "data/test3.txt");
            FileWriter fileWriter = new FileWriter(newFile);
            fileWriter.write("test");
            fileWriter.close();
            Assert.assertTrue((boolean)newFile.exists());
            File newDir = new File(this.getBagFile(), "data/dir3");
            FileUtils.forceMkdir((File)newDir);
            Assert.assertTrue((boolean)newDir.exists());
            ((FileSystemWriter)writer).setTagFilesOnly(true);
            newBag2 = writer.write(newBag, this.getBagFile());
            Assert.assertFalse((boolean)newBag2.verifyValid().isSuccess());
            Assert.assertTrue((boolean)newFile.exists());
            Assert.assertTrue((boolean)newDir.exists());
        }
        finally {
            bag.close();
            if (newBag != null) {
                newBag.close();
            }
            if (newBag2 != null) {
                newBag2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteFilesThatDoNotMatchManifestOnly() throws Exception {
        Bag bag = this.bagFactory.createBag(ResourceHelper.getFile("bags/v0_95/bag"));
        Bag newBag = null;
        Bag newBag2 = null;
        Bag newBag3 = null;
        try {
            Writer writer = this.getBagWriter();
            newBag = writer.write(bag, this.getBagFile());
            Assert.assertTrue((boolean)newBag.verifyValid().isSuccess());
            Long manifestLastModified = new File(this.getBagFile(), "manifest-md5.txt").lastModified();
            File changedFile = new File(this.getBagFile(), "data/test1.txt");
            Long changedFileLastModified = new File(this.getBagFile(), "data/test1.txt").lastModified();
            Long unchangedFileLastModified = new File(this.getBagFile(), "data/test2.txt").lastModified();
            Thread.sleep(1000L);
            FileUtils.writeStringToFile((File)changedFile, (String)"changing this file");
            Assert.assertTrue((changedFileLastModified.longValue() != new File(changedFile.getCanonicalPath()).lastModified() ? 1 : 0) != 0);
            Assert.assertTrue((unchangedFileLastModified.longValue() == new File(this.getBagFile(), "data/test2.txt").lastModified() ? 1 : 0) != 0);
            UpdateCompleter completer = new UpdateCompleter(this.bagFactory);
            ArrayList<String> updatedFiles = new ArrayList<String>();
            updatedFiles.add("data/test1.txt");
            completer.setLimitUpdatePayloadFilepaths(updatedFiles);
            newBag2 = completer.complete(newBag);
            Assert.assertTrue((boolean)newBag2.verifyValid().isSuccess());
            FileSystemWriter writer2 = new FileSystemWriter(this.bagFactory);
            writer2.setFilesThatDoNotMatchManifestOnly(true);
            newBag3 = writer2.write(newBag2, this.getBagFile());
            Assert.assertTrue((boolean)newBag3.verifyValid().isSuccess());
            Assert.assertTrue((changedFileLastModified.longValue() != new File(this.getBagFile(), "data/test1.txt").lastModified() ? 1 : 0) != 0);
            Assert.assertTrue((unchangedFileLastModified.longValue() == new File(this.getBagFile(), "data/test2.txt").lastModified() ? 1 : 0) != 0);
            Assert.assertTrue((manifestLastModified.longValue() != new File(this.getBagFile(), "manifest-md5.txt").lastModified() ? 1 : 0) != 0);
        }
        finally {
            bag.close();
            if (newBag != null) {
                newBag.close();
            }
            if (newBag2 != null) {
                newBag2.close();
            }
            if (newBag3 != null) {
                newBag3.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriteMode() throws Exception {
        Bag bag = this.bagFactory.createBag(ResourceHelper.getFile("bags/v0_95/bag"));
        File payloadFile = new File(bag.getFile(), "data/test1.txt");
        System.out.println("XXXXXXXXXXXX" + payloadFile);
        Assert.assertTrue((boolean)payloadFile.exists());
        Bag copyBag = null;
        Bag streamBag = null;
        Bag moveBag = null;
        try {
            Writer writer = this.getBagWriter();
            copyBag = writer.write(bag, new File(this.getBagFile().getParentFile(), "copy_bag"));
            Assert.assertTrue((boolean)copyBag.verifyValid().isSuccess());
            File newPayloadFile = new File(copyBag.getFile(), "data/test1.txt");
            Assert.assertTrue((boolean)newPayloadFile.exists());
            Assert.assertTrue((boolean)Long.valueOf(payloadFile.lastModified()).equals(newPayloadFile.lastModified()));
            ((FileSystemWriter)writer).setPayloadWriteMode(FileSystemWriter.WriteMode.STREAM);
            streamBag = writer.write(bag, new File(this.getBagFile().getParentFile(), "stream_bag"));
            Assert.assertTrue((boolean)streamBag.verifyValid().isSuccess());
            newPayloadFile = new File(streamBag.getFile(), "data/test1.txt");
            Assert.assertTrue((boolean)newPayloadFile.exists());
            Assert.assertFalse((boolean)Long.valueOf(payloadFile.lastModified()).equals(newPayloadFile.lastModified()));
            File movedPayloadFile = new File(copyBag.getFile(), "data/test1.txt");
            Assert.assertTrue((boolean)movedPayloadFile.exists());
            ((FileSystemWriter)writer).setPayloadWriteMode(FileSystemWriter.WriteMode.MOVE);
            moveBag = writer.write(copyBag, new File(this.getBagFile().getParentFile(), "move_bag"));
            Assert.assertTrue((boolean)moveBag.verifyValid().isSuccess());
            newPayloadFile = new File(moveBag.getFile(), "data/test1.txt");
            Assert.assertTrue((boolean)newPayloadFile.exists());
            Assert.assertTrue((boolean)Long.valueOf(payloadFile.lastModified()).equals(newPayloadFile.lastModified()));
            Assert.assertFalse((boolean)movedPayloadFile.exists());
        }
        finally {
            bag.close();
            if (copyBag != null) {
                copyBag.close();
            }
            if (streamBag != null) {
                streamBag.close();
            }
        }
    }
}

