/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.writer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.Cancellable;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.ProgressListener;
import gov.loc.repository.bagit.bag.CancelTriggeringBagDecorator;
import gov.loc.repository.bagit.progresslistener.PrintingProgressListener;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import gov.loc.repository.bagit.writer.Writer;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractWriterTest {
    BagFactory bagFactory = new BagFactory();

    @Before
    public void setUp() throws Exception {
        if (this.getBagFile().exists()) {
            FileUtils.forceDelete((File)this.getBagFile());
        }
    }

    public abstract Writer getBagWriter();

    public abstract File getBagFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWriter() throws Exception {
        Bag bag = this.bagFactory.createBag(ResourceHelper.getFile("bags/v0_95/bag"));
        try {
            Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
            Writer writer = this.getBagWriter();
            writer.addProgressListener((ProgressListener)new PrintingProgressListener());
            Bag newBag = writer.write(bag, this.getBagFile());
            try {
                Assert.assertNotNull((Object)newBag);
                Assert.assertTrue((boolean)this.getBagFile().exists());
                Assert.assertTrue((boolean)newBag.verifyValid().isSuccess());
                List payloadManifests = newBag.getPayloadManifests();
                Assert.assertEquals((long)1L, (long)payloadManifests.size());
                Assert.assertEquals((Object)"manifest-md5.txt", (Object)((Manifest)payloadManifests.get(0)).getFilepath());
                Assert.assertEquals((long)4L, (long)newBag.getTags().size());
                Assert.assertNotNull((Object)newBag.getBagFile("bagit.txt"));
                Assert.assertEquals((long)5L, (long)newBag.getPayload().size());
                Assert.assertNotNull((Object)newBag.getBagFile("data/dir1/test3.txt"));
            }
            finally {
                newBag.close();
            }
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancel() throws Exception {
        Bag bag = this.bagFactory.createBag(ResourceHelper.getFile("bags/v0_95/bag"));
        try {
            Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
            Writer writer = this.getBagWriter();
            Bag newBag = writer.write((Bag)new CancelTriggeringBagDecorator(bag, 10, (Cancellable)writer), this.getBagFile());
            try {
                Assert.assertNull((Object)newBag);
            }
            finally {
                bag.close();
            }
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOverwrite() throws Exception {
        Bag bag = this.bagFactory.createBag(ResourceHelper.getFile("bags/v0_95/bag"));
        Bag newBag = null;
        Bag newestBag = null;
        try {
            Writer writer = this.getBagWriter();
            newBag = writer.write(bag, this.getBagFile());
            Assert.assertTrue((boolean)newBag.verifyValid().isSuccess());
            newestBag = writer.write(newBag, this.getBagFile());
            Assert.assertTrue((boolean)newestBag.verifyValid().isSuccess());
        }
        finally {
            bag.close();
            if (newBag != null) {
                newBag.close();
            }
            if (newestBag != null) {
                newestBag.close();
            }
        }
    }
}

