/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.verify.impl.PayloadOxumVerifier;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class PayloadOxumVerifierTest {
    PayloadOxumVerifier verifier = new PayloadOxumVerifier();
    BagFactory bagFactory = new BagFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVerifyPayloadOxum() throws Exception {
        Bag testBag = this.getBag();
        try {
            SimpleResult result = this.verifier.verify(testBag);
            Assert.assertTrue((boolean)result.isSuccess());
            Assert.assertEquals((long)1L, (long)result.getWarningMessages().size());
            testBag.getBagInfoTxt().setPayloadOxum("25.5");
            result = this.verifier.verify(testBag);
            Assert.assertTrue((boolean)result.isSuccess());
            testBag.getBagInfoTxt().setPayloadOxum("25.4");
            result = this.verifier.verify(testBag);
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertTrue((boolean)result.hasSimpleMessage("incorrect_payload-oxum"));
        }
        finally {
            testBag.close();
        }
    }

    private Bag getBag() throws Exception {
        File bagDir = ResourceHelper.getFile("bags/v0_96/bag");
        return this.bagFactory.createBag(bagDir);
    }
}

