/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.ProgressListener;
import gov.loc.repository.bagit.progresslistener.PrintingProgressListener;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.verify.impl.ParallelManifestChecksumVerifier;
import java.io.File;
import java.text.MessageFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParallelManifestChecksumVerifierTest {
    private ParallelManifestChecksumVerifier unit = new ParallelManifestChecksumVerifier();
    BagFactory bagFactory = new BagFactory();

    @Before
    public void setUp() {
        this.unit.setNumberOfThreads(3);
    }

    @Test
    public void testCannotSetNumberOfThreadsToZero() {
        try {
            this.unit.setNumberOfThreads(0);
            Assert.fail((String)"Expected IllegalArgumentException was not thrown.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVerifyCorrect() throws Exception {
        Bag testBag = this.getBag(BagFactory.Version.V0_96, Bag.Format.FILESYSTEM);
        try {
            this.unit.addProgressListener((ProgressListener)new PrintingProgressListener());
            SimpleResult result = this.unit.verify(testBag.getPayloadManifests(), testBag);
            Assert.assertEquals((Object)true, (Object)result.isSuccess());
        }
        finally {
            testBag.close();
        }
    }

    private Bag getBag(BagFactory.Version version, Bag.Format format) throws Exception {
        return this.bagFactory.createBag(this.getBagDir(version, format), version, BagFactory.LoadOption.BY_MANIFESTS);
    }

    private File getBagDir(BagFactory.Version version, Bag.Format format) throws Exception {
        return ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag{1}", version.toString().toLowerCase(), format.extension));
    }
}

