/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.v0_97;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.ManifestReader;
import gov.loc.repository.bagit.impl.AbstractManifestReaderImplTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class ManifestReaderImplTest
extends AbstractManifestReaderImplTest {
    BagFactory bagFactory = new BagFactory();

    @Test
    public void test() throws Exception {
        Bag.BagPartFactory factory = this.bagFactory.getBagPartFactory(BagFactory.Version.V0_97);
        String manifest = "8ad8757baa8564dc136c1e07507f4a98 data/test1.txt\n8ad8757baa8564dc136c1e07507f4a98\tdata/test3.txt\n8ad8757baa8564dc136c1e07507f4a98\tdata/test 4.txt\n8ad8757baa8564dc136c1e07507f4a98  data/test5.txt\n8ad8757baa8564dc136c1e07507f4a98 *data/test6.txt\n8ad8757baa8564dc136c1e07507f4a98__data/test7.txt\n";
        ManifestReader reader = factory.createManifestReader((InputStream)new ByteArrayInputStream(manifest.getBytes("utf-8")), "utf-8");
        ManifestReader.FilenameFixity ff = (ManifestReader.FilenameFixity)reader.next();
        Assert.assertEquals((Object)"8ad8757baa8564dc136c1e07507f4a98", (Object)ff.getFixityValue());
        Assert.assertEquals((Object)"data/test1.txt", (Object)ff.getFilename());
        ff = (ManifestReader.FilenameFixity)reader.next();
        Assert.assertEquals((Object)"8ad8757baa8564dc136c1e07507f4a98", (Object)ff.getFixityValue());
        Assert.assertEquals((Object)"data/test3.txt", (Object)ff.getFilename());
        ff = (ManifestReader.FilenameFixity)reader.next();
        Assert.assertEquals((Object)"8ad8757baa8564dc136c1e07507f4a98", (Object)ff.getFixityValue());
        Assert.assertEquals((Object)"data/test 4.txt", (Object)ff.getFilename());
        ff = (ManifestReader.FilenameFixity)reader.next();
        Assert.assertEquals((Object)"8ad8757baa8564dc136c1e07507f4a98", (Object)ff.getFixityValue());
        Assert.assertEquals((Object)"data/test5.txt", (Object)ff.getFilename());
        ff = (ManifestReader.FilenameFixity)reader.next();
        Assert.assertEquals((Object)"8ad8757baa8564dc136c1e07507f4a98", (Object)ff.getFixityValue());
        Assert.assertEquals((Object)"data/test6.txt", (Object)ff.getFilename());
        Assert.assertFalse((boolean)reader.hasNext());
        reader.close();
    }

    @Override
    public boolean canReadDoubleSpaceWithUnixSep() {
        return true;
    }

    @Override
    public boolean canReadSingleSpaceWithUnixSep() {
        return true;
    }

    @Override
    public void testSingleSpaceWithWindowsSep() throws Exception {
        boolean isException = false;
        try {
            Assert.assertEquals((Object)true, (Object)this.canReadLine("8ad8757baa8564dc136c1e07507f4a98 data\\test1.txt\n", "8ad8757baa8564dc136c1e07507f4a98", "data\\test1.txt"));
        }
        catch (RuntimeException ex) {
            isException = true;
        }
        Assert.assertTrue((boolean)isException);
        Assert.assertEquals((Object)true, (Object)this.canReadLine("8ad8757baa8564dc136c1e07507f4a98 data\\test1.txt\n", "8ad8757baa8564dc136c1e07507f4a98", "data/test1.txt", true));
    }

    @Override
    public boolean canReadSpaceAstericksWithUnixSep() {
        return true;
    }

    @Override
    public boolean canReadTabWithUnixSep() {
        return true;
    }

    @Override
    public boolean canReadTabWithUnixSepWithSpaceInFilename() {
        return true;
    }

    @Override
    public BagFactory.Version getVersion() {
        return BagFactory.Version.V0_97;
    }
}

