/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.v0_96;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.FetchTxtReader;
import gov.loc.repository.bagit.impl.FetchTxtReaderImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class FetchTxtImplTest {
    BagFactory bagFactory = new BagFactory();

    @Test
    public void testCorrectlyReadsFetch() throws Exception {
        Bag.BagPartFactory factory = this.bagFactory.getBagPartFactory(BagFactory.Version.V0_96);
        FetchTxtReader reader = factory.createFetchTxtReader((InputStream)new ByteArrayInputStream("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt - data/dir1/test3.txt".getBytes("UTF-8")), "UTF-8");
        Assert.assertTrue((boolean)reader.hasNext());
        FetchTxt.FilenameSizeUrl line = (FetchTxt.FilenameSizeUrl)reader.next();
        Assert.assertFalse((boolean)reader.hasNext());
        Assert.assertEquals((Object)"http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt", (Object)line.getUrl());
        Assert.assertNull((Object)line.getSize());
        Assert.assertEquals((Object)"data/dir1/test3.txt", (Object)line.getFilename());
    }

    @Test
    public void testLeavesWhitespaceInFilename() {
        ByteArrayInputStream in = new ByteArrayInputStream("http://example.org - FETCH_FAILED data/this is a [filename] with spaces".getBytes());
        FetchTxtReaderImpl reader = new FetchTxtReaderImpl((InputStream)in, "UTF-8");
        Assert.assertTrue((boolean)reader.hasNext());
        FetchTxt.FilenameSizeUrl line = reader.next();
        Assert.assertFalse((boolean)reader.hasNext());
        Assert.assertEquals((Object)"http://example.org", (Object)line.getUrl());
        Assert.assertNull((Object)line.getSize());
        Assert.assertEquals((Object)"data/this is a [filename] with spaces", (Object)line.getFilename());
        Assert.assertEquals((Object)FetchTxt.FetchStatus.FETCH_FAILED, (Object)line.getFetchStatus());
    }
}

