/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.v0_96;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.impl.BaseBagImplTest;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class BagWithEncodedNamesTest
extends BaseBagImplTest {
    @Override
    public BagFactory.Version getVersion() {
        return BagFactory.Version.V0_96;
    }

    @Override
    protected String getBagName() {
        return "bag-with-encoded-names";
    }

    @Test
    public void testFileSystemBagByPayloadManifests() throws Exception {
        this.testBag(this.getBagByPayloadManifests(Bag.Format.FILESYSTEM));
    }

    @Test
    public void testFileSystemBagByPayloadFiles() throws Exception {
        this.testBag(this.getBagByPayloadFiles(Bag.Format.FILESYSTEM));
    }

    @Override
    protected void assertBagPayloadManifests(Bag bag) throws Exception {
        List payloadManifests = bag.getPayloadManifests();
        Assert.assertEquals((long)1L, (long)payloadManifests.size());
        Assert.assertEquals((Object)"manifest-md5.txt", (Object)((Manifest)payloadManifests.get(0)).getFilepath());
        Assert.assertEquals((Object)"manifest-md5.txt", (Object)bag.getPayloadManifest(Manifest.Algorithm.MD5).getFilepath());
        Assert.assertNull((Object)bag.getPayloadManifest(Manifest.Algorithm.SHA1));
        Assert.assertEquals((Object)"ad0234829205b9033196ba818f7a872b", bag.getChecksums("data/%test2.txt").get(Manifest.Algorithm.MD5));
    }

    @Override
    protected void assertBagPayloadFiles(Bag bag) throws Exception {
        Assert.assertEquals((long)5L, (long)bag.getPayload().size());
        Assert.assertNotNull((Object)bag.getBagFile("data/dir1/~test3.txt"));
        Assert.assertNull((Object)bag.getBagFile("xdata/dir1/test3.txt"));
    }
}

