/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.v0_96;

import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.impl.AbstractBagInfoTxtImplTest;
import java.text.ParseException;
import org.junit.Assert;
import org.junit.Test;

public class BagInfoTxtImplTest
extends AbstractBagInfoTxtImplTest {
    @Override
    public BagFactory.Version getVersion() {
        return BagFactory.Version.V0_96;
    }

    @Override
    public String getTestBagInfoTxtBagInfoTxtString() {
        return "Source-Organization: Spengler University\nOrganization-Address: 1400 Elm St., Cupertino, California, 95014\nContact-Name: Edna Janssen\nContact-Phone: +1 408-555-1212\nContact-Email: ej@spengler.edu\nExternal-Description: Uncompressed greyscale TIFF images from the\n     Yoshimuri papers collection.\nBagging-Date: 2008-01-15\nExternal-Identifier: spengler_yoshimuri_001\nBag-Size: 260 GB\nPayload-Oxum: 279164409832.1198\nBag-Group-Identifier: spengler_yoshimuri\nBag-Count: 1 of 15\nInternal-Sender-Identifier: /storage/images/yoshimuri\nInternal-Sender-Description: Uncompressed greyscale TIFFs created from\n     microfilm.\n";
    }

    @Override
    public void addlTestBagInfoTxt(BagInfoTxt bagInfo) {
        Assert.assertEquals((Object)"279164409832.1198", (Object)bagInfo.getPayloadOxum());
    }

    @Test
    public void testPayloadOxum() throws Exception {
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt();
        bagInfo.setPayloadOxum("279164409832.1198");
        Assert.assertEquals((Object)"279164409832.1198", (Object)bagInfo.getPayloadOxum());
        Assert.assertEquals((Object)279164409832L, (Object)bagInfo.getOctetCount());
        Assert.assertEquals((Object)1198L, (Object)bagInfo.getStreamCount());
        bagInfo.setPayloadOxum(279164409833L, 1199L);
        Assert.assertEquals((Object)"279164409833.1199", (Object)bagInfo.getPayloadOxum());
    }

    @Test(expected=ParseException.class)
    public void testBadPayloadOxum() throws Exception {
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt();
        bagInfo.setPayloadOxum("279164409832");
        bagInfo.getOctetCount();
    }
}

