/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.v0_96;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.impl.AbstractBagImplTest;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class BagInABagTests
extends AbstractBagImplTest {
    @Override
    public BagFactory.Version getVersion() {
        return BagFactory.Version.V0_96;
    }

    @Override
    protected String getBagName() {
        return "bag-in-a-bag";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testRemoveDirectory() throws Exception {
        Bag bag = this.getBagByPayloadManifests(Bag.Format.FILESYSTEM);
        try {
            Assert.assertNotNull((Object)bag.getBagFile("data/bag/data/test1.txt"));
            Assert.assertNotNull((Object)bag.getBagFile("data/bag/data/dir2/test4.txt"));
            Assert.assertNotNull((Object)bag.getBagFile("data/bag/data/dir2/dir3/test5.txt"));
            bag.removePayloadDirectory("data/bag/data/dir2");
            Assert.assertNotNull((Object)bag.getBagFile("data/bag/data/test1.txt"));
            Assert.assertNull((Object)bag.getBagFile("data/bag/data/dir2/test4.txt"));
            Assert.assertNull((Object)bag.getBagFile("data/bag/data/dir2/dir3/test5.txt"));
            bag.removePayloadDirectory("data/bag/data/test1.txt");
            Assert.assertNotNull((Object)bag.getBagFile("data/bag/data/test1.txt"));
            bag.removePayloadDirectory("data");
            Assert.assertNotNull((Object)bag.getBagFile("data/bag/manifest-md5.txt"));
        }
        finally {
            bag.close();
        }
    }

    @Override
    protected void assertBagPayloadManifests(Bag bag) throws Exception {
        List payloadManifests = bag.getPayloadManifests();
        Assert.assertEquals((long)1L, (long)payloadManifests.size());
        Assert.assertEquals((Object)"manifest-md5.txt", (Object)((Manifest)payloadManifests.get(0)).getFilepath());
        Assert.assertEquals((Object)"manifest-md5.txt", (Object)bag.getPayloadManifest(Manifest.Algorithm.MD5).getFilepath());
        Assert.assertNull((Object)bag.getPayloadManifest(Manifest.Algorithm.SHA1));
        Assert.assertEquals((Object)"ad0234829205b9033196ba818f7a872b", bag.getChecksums("data/bag/data/test2.txt").get(Manifest.Algorithm.MD5));
        Assert.assertEquals((Object)"ba8644f8c8b7adb3d5cf3ad4245606e8", bag.getChecksums("data/bag/manifest-md5.txt").get(Manifest.Algorithm.MD5));
    }

    @Override
    protected void assertBagPayloadFiles(Bag bag) throws Exception {
        Assert.assertEquals((long)9L, (long)bag.getPayload().size());
        Assert.assertNotNull((Object)bag.getBagFile("data/bag/data/dir1/test3.txt"));
        Assert.assertNull((Object)bag.getBagFile("xdata/bag/data/dir1/test3.txt"));
        Assert.assertNotNull((Object)bag.getBagFile("data/bag/manifest-md5.txt"));
        Assert.assertNull((Object)bag.getBagFile("data/bag/manifest-sha42.txt"));
    }

    @Override
    public void performTestBagWithTagDirectory(Bag bag) {
        this.performTestBagWithTagDirectoryPrev97(bag);
    }

    @Override
    public void performTestBagWithIgnoredTagDirectory(Bag bag) {
        this.performTestBagWithIgnoredTagDirectoryPrev97(bag);
    }
}

