/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.utilities.namevalue.impl;

import gov.loc.repository.bagit.utilities.namevalue.NameValueWriter;
import gov.loc.repository.bagit.utilities.namevalue.impl.NameValueWriterImpl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NameValueWriterImplTest {
    NameValueWriter writer;
    ByteArrayOutputStream out = new ByteArrayOutputStream();

    @Before
    public void setup() {
        this.writer = new NameValueWriterImpl((OutputStream)this.out, "utf-8", 79, 2, "test");
    }

    @Test
    public void testWrite() throws Exception {
        this.writer.write("Source-Organization", "Spengler University");
        this.writer.write("External-Description", "This collection consists of six large-scale web crawls run against U.S. city web sites from May 2005 to October 2007 as part of the Stanford WebBase project.\nFormat:  ARC files generated from WebBase content.");
        this.writer.write("Organization-Address", "1400 Really Tall Elm Street, Suite 1112, Floor 17, Los Angeles, California, 95014");
        this.writer.write("Internal-Sender-Description", "Uncompressed greyscale TIFFs.\r\nThey were created from microfilm.");
        this.writer.close();
        String outString = new String(this.out.toByteArray(), "utf-8");
        Assert.assertEquals((Object)"Source-Organization: Spengler University\nExternal-Description: This collection consists of six large-scale web crawls\n  run against U.S. city web sites from May 2005 to October 2007 as part of the\n  Stanford WebBase project.\n  \n  Format:  ARC files generated from WebBase content.\nOrganization-Address: 1400 Really Tall Elm Street, Suite 1112, Floor 17, Los\n  Angeles, California, 95014\nInternal-Sender-Description: Uncompressed greyscale TIFFs.\n  \n  They were created from microfilm.\n", (Object)outString);
    }
}

