/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.utilities;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;

public class ResourceHelper {
    public static final File PROJECT_DIR = new File(System.getProperty("user.dir"));
    public static final File TARGET_DIR = new File(PROJECT_DIR, "target");
    public static final File TEST_DATA_DIR = new File(TARGET_DIR, "unit-test-data");
    private static final IOFileFilter REAL_FILE_FILTER = new AndFileFilter(HiddenFileFilter.VISIBLE, (IOFileFilter)new NotFileFilter((IOFileFilter)new PrefixFileFilter(".")));
    private static boolean initialCopyCompleted = false;

    public static File getFile(String filePath) throws Exception {
        ResourceHelper.copyUnitTestData();
        return new File(TEST_DATA_DIR, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyUnitTestData() throws IOException {
        File file = TEST_DATA_DIR;
        synchronized (file) {
            if (!initialCopyCompleted) {
                if (TEST_DATA_DIR.exists()) {
                    FileUtils.deleteQuietly((File)TEST_DATA_DIR);
                }
                FileUtils.copyDirectory((File)new File(PROJECT_DIR, "src/test/resources/bags"), (File)new File(TEST_DATA_DIR, "bags"), (FileFilter)REAL_FILE_FILTER, (boolean)true);
                FileUtils.copyDirectory((File)new File(PROJECT_DIR, "src/test/resources/file_systems"), (File)new File(TEST_DATA_DIR, "file_systems"), (FileFilter)REAL_FILE_FILTER, (boolean)true);
                initialCopyCompleted = true;
            }
        }
    }
}

