/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.utilities;

import gov.loc.repository.bagit.utilities.FilenameHelper;
import org.junit.Assert;
import org.junit.Test;

public class FilenameHelperTest {
    @Test
    public void testRemoveBasePath() throws Exception {
        Assert.assertEquals((Object)"bar.html", (Object)FilenameHelper.removeBasePath((String)"/foo", (String)"/foo/bar.html"));
        Assert.assertEquals((Object)"bar.html", (Object)FilenameHelper.removeBasePath((String)"c:/foo", (String)"c:\\foo\\bar.html"));
        Assert.assertEquals((Object)"foo/bar.html", (Object)FilenameHelper.removeBasePath((String)"c:\\", (String)"c:\\foo\\bar.html"));
    }

    @Test(expected=Exception.class)
    public void testRemoveBadBasePath() throws Exception {
        FilenameHelper.removeBasePath((String)"/xfoo", (String)"/foo/bar.html");
    }

    @Test
    public void testNormalizePathSeparators() {
        Assert.assertEquals((Object)"data/foo.txt", (Object)FilenameHelper.normalizePathSeparators((String)"data/foo.txt"));
        Assert.assertEquals((Object)"data/foo.txt", (Object)FilenameHelper.normalizePathSeparators((String)"data\\foo.txt"));
    }

    @Test
    public void testNormalizePath() {
        Assert.assertEquals((Object)"data/foo.txt", (Object)FilenameHelper.normalizePath((String)"data/foo.txt"));
        Assert.assertEquals((Object)"data\\foo.txt", (Object)FilenameHelper.normalizePath((String)"data\\foo.txt"));
        Assert.assertEquals((Object)"/data/foo.txt", (Object)FilenameHelper.normalizePath((String)"/data/foo.txt"));
        Assert.assertEquals((Object)"\\data\\foo.txt", (Object)FilenameHelper.normalizePath((String)"\\data\\foo.txt"));
        Assert.assertEquals((Object)"data/foo.txt", (Object)FilenameHelper.normalizePath((String)"./data/foo.txt"));
        Assert.assertEquals((Object)"data\\foo.txt", (Object)FilenameHelper.normalizePath((String)".\\data\\foo.txt"));
        Assert.assertEquals((Object)"data/foo.txt", (Object)FilenameHelper.normalizePath((String)"data/./foo.txt"));
        Assert.assertEquals((Object)"data\\foo.txt", (Object)FilenameHelper.normalizePath((String)"data\\.\\foo.txt"));
        Assert.assertEquals((Object)"foo.txt", (Object)FilenameHelper.normalizePath((String)"data/../foo.txt"));
        Assert.assertEquals((Object)"foo.txt", (Object)FilenameHelper.normalizePath((String)"data\\..\\foo.txt"));
        Assert.assertEquals((Object)"data/foo.txt", (Object)FilenameHelper.normalizePath((String)"data/dir1/../foo.txt"));
        Assert.assertEquals((Object)"data\\foo.txt", (Object)FilenameHelper.normalizePath((String)"data\\dir1\\..\\foo.txt"));
    }
}

