/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagHelper;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.transformer.impl.UpdatePayloadOxumCompleter;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import java.io.Closeable;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UpdatePayloadOxumCompleterTest {
    BagFactory bagFactory = new BagFactory();
    UpdatePayloadOxumCompleter completer;
    Bag bag;
    File testBagFile;

    private File createTestBag() throws Exception {
        File sourceBagDir = ResourceHelper.getFile("bags/v0_96/bag");
        File testBagDir = new File(sourceBagDir.getParentFile(), "test_bag");
        if (testBagDir.exists()) {
            FileUtils.forceDelete((File)testBagDir);
        }
        FileUtils.copyDirectory((File)sourceBagDir, (File)testBagDir);
        return testBagDir;
    }

    @Before
    public void setup() throws Exception {
        this.completer = new UpdatePayloadOxumCompleter(this.bagFactory);
        this.testBagFile = this.createTestBag();
        this.bag = this.bagFactory.createBag(this.testBagFile);
        Assert.assertTrue((boolean)this.bag.verifyValid().isSuccess());
    }

    @After
    public void cleanup() {
        IOUtils.closeQuietly((Closeable)this.bag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComplete() throws Exception {
        Bag newBag = null;
        Bag newBag2 = null;
        try {
            Assert.assertNull((Object)this.bag.getBagInfoTxt().getPayloadOxum());
            newBag = this.completer.complete(this.bag);
            Assert.assertNull((Object)newBag.getBagInfoTxt().getPayloadOxum());
            newBag.getBagInfoTxt().setPayloadOxum(2L, 3L);
            Assert.assertFalse((boolean)this.comparePayloadOxum(newBag));
            newBag2 = this.completer.complete(newBag);
            Assert.assertTrue((boolean)this.comparePayloadOxum(newBag2));
        }
        finally {
            if (newBag != null) {
                newBag.close();
            }
            if (newBag2 != null) {
                newBag2.close();
            }
        }
    }

    private boolean comparePayloadOxum(Bag bag) {
        String genOxum = BagHelper.generatePayloadOxum((Bag)bag);
        BagInfoTxt bagInfo = bag.getBagInfoTxt();
        String checkOxum = bagInfo.getPayloadOxum();
        return genOxum.equals(checkOxum);
    }
}

