/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.ProgressListener;
import gov.loc.repository.bagit.progresslistener.LoggingProgressListener;
import gov.loc.repository.bagit.transformer.impl.UpdateCompleter;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import gov.loc.repository.bagit.utilities.SimpleResult;
import java.io.File;
import java.io.FileWriter;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UpdateCompleterTest {
    BagFactory bagFactory = new BagFactory();
    UpdateCompleter completer;
    File bagFile;
    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");

    private File createTestBag() throws Exception {
        File sourceBagDir = ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag", BagFactory.LATEST.toString().toLowerCase()));
        File testBagDir = new File(sourceBagDir.getParentFile(), "test_bag");
        if (testBagDir.exists()) {
            FileUtils.forceDelete((File)testBagDir);
        }
        FileUtils.copyDirectory((File)sourceBagDir, (File)testBagDir);
        return testBagDir;
    }

    @Before
    public void setup() throws Exception {
        this.completer = new UpdateCompleter(this.bagFactory);
        this.completer.addProgressListener((ProgressListener)new LoggingProgressListener());
        this.bagFile = this.createTestBag();
        File file1 = new File(this.bagFile, "data/test1.txt");
        file1.renameTo(new File(this.bagFile, "data/xtest1.txt"));
        File file2 = new File(this.bagFile, "data/test2.txt");
        FileWriter writer1 = new FileWriter(file2);
        writer1.append("x");
        writer1.close();
        File file3 = new File(this.bagFile, "newtag.txt");
        FileWriter writer2 = new FileWriter(file3);
        writer2.append("newtag");
        writer2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComplete() throws Exception {
        Bag bag = this.bagFactory.createBag(this.bagFile, BagFactory.LoadOption.BY_FILES);
        Bag newBag = null;
        try {
            Assert.assertFalse((boolean)bag.verifyValid().isSuccess());
            newBag = this.completer.complete(bag);
            SimpleResult result = newBag.verifyValid();
            Assert.assertTrue((boolean)result.isSuccess());
            BagInfoTxt bagInfoTxt = newBag.getBagInfoTxt();
            Assert.assertNull((Object)bagInfoTxt.getPayloadOxum());
            Assert.assertEquals((Object)this.dateFormat.format(new Date()), (Object)bagInfoTxt.getBaggingDate());
        }
        finally {
            bag.close();
            if (newBag != null) {
                newBag.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompleteWithoutBagInfoTxt() throws Exception {
        File bagInfoTxtFile = new File(this.bagFile, this.bagFactory.getBagConstants().getBagInfoTxt());
        FileUtils.forceDelete((File)bagInfoTxtFile);
        Bag bag = this.bagFactory.createBag(this.bagFile, BagFactory.LoadOption.BY_FILES);
        Bag newBag = null;
        try {
            Assert.assertFalse((boolean)bag.verifyValid().isSuccess());
            newBag = this.completer.complete(bag);
            try {
                SimpleResult result = newBag.verifyValid();
                Assert.assertTrue((boolean)result.isSuccess());
                Assert.assertNull((Object)newBag.getBagInfoTxt());
            }
            finally {
                newBag.close();
            }
        }
        finally {
            bag.close();
            if (newBag != null) {
                newBag.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompleteLimit() throws Exception {
        Bag bag = this.bagFactory.createBag(this.bagFile, BagFactory.LoadOption.BY_FILES);
        Bag newBag = null;
        Bag newBag2 = null;
        try {
            Assert.assertFalse((boolean)bag.verifyValid().isSuccess());
            this.completer.setLimitAddPayloadFilepaths(new ArrayList());
            this.completer.setLimitUpdatePayloadFilepaths(new ArrayList());
            this.completer.setLimitDeletePayloadFilepaths(new ArrayList());
            this.completer.setLimitAddTagFilepaths(new ArrayList());
            this.completer.setLimitUpdateTagFilepaths(new ArrayList());
            this.completer.setLimitDeleteTagFilepaths(new ArrayList());
            newBag = this.completer.complete(bag);
            Assert.assertFalse((boolean)newBag.verifyValid().isSuccess());
            Assert.assertTrue((boolean)newBag.getChecksums("newtag.txt").isEmpty());
            this.completer.setLimitAddPayloadFilepaths(Arrays.asList("data/xtest1.txt"));
            this.completer.setLimitUpdatePayloadFilepaths(Arrays.asList("data/test2.txt"));
            this.completer.setLimitDeletePayloadFilepaths(Arrays.asList("data/test1.txt"));
            this.completer.setLimitAddTagFilepaths(Arrays.asList("newtag.txt"));
            newBag2 = this.completer.complete(bag);
            Assert.assertTrue((boolean)newBag2.verifyValid().isSuccess());
            Assert.assertFalse((boolean)newBag.getChecksums("newtag.txt").isEmpty());
        }
        finally {
            bag.close();
            if (newBag != null) {
                newBag.close();
            }
            if (newBag2 != null) {
                newBag2.close();
            }
        }
    }
}

