/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.transformer.impl.TagManifestCompleter;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TagManifestCompleterTest {
    BagFactory bagFactory = new BagFactory();
    TagManifestCompleter completer;
    Bag bag;
    File testBagFile;

    private File createTestBag() throws Exception {
        File sourceBagDir = ResourceHelper.getFile("bags/v0_96/bag");
        File testBagDir = new File(sourceBagDir.getParentFile(), "test_bag");
        if (testBagDir.exists()) {
            FileUtils.forceDelete((File)testBagDir);
        }
        FileUtils.copyDirectory((File)sourceBagDir, (File)testBagDir);
        return testBagDir;
    }

    @Before
    public void setup() throws Exception {
        this.completer = new TagManifestCompleter(this.bagFactory);
        this.testBagFile = this.createTestBag();
        this.bag = this.bagFactory.createBag(this.testBagFile);
        Assert.assertTrue((boolean)this.bag.verifyValid().isSuccess());
    }

    @After
    public void cleanup() {
        IOUtils.closeQuietly((Closeable)this.bag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComplete() throws Exception {
        Bag newBag = this.completer.complete(this.bag);
        Bag newBag2 = null;
        Bag newBag3 = null;
        Bag newBag4 = null;
        try {
            Assert.assertTrue((boolean)newBag.verifyValid().isSuccess());
            File test1File = new File(this.testBagFile, "tag.txt");
            Assert.assertFalse((boolean)test1File.exists());
            FileWriter writer = new FileWriter(test1File);
            writer.write("tag");
            writer.close();
            newBag.addFileAsTag(test1File);
            newBag2 = this.completer.complete(newBag);
            Assert.assertTrue((boolean)newBag2.verifyValid().isSuccess());
            writer = new FileWriter(test1File);
            writer.write("xtag");
            writer.close();
            newBag3 = this.completer.complete(newBag2);
            Assert.assertTrue((boolean)newBag3.verifyValid().isSuccess());
            test1File.delete();
            newBag3.removeBagFile("tag.txt");
            newBag4 = this.completer.complete(newBag3);
            Assert.assertTrue((boolean)newBag4.verifyValid().isSuccess());
        }
        finally {
            newBag.close();
            if (newBag2 != null) {
                newBag2.close();
            }
            if (newBag3 != null) {
                newBag3.close();
            }
            if (newBag4 != null) {
                newBag4.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompleteWithLimits() throws Exception {
        Bag newBag = this.completer.complete(this.bag);
        Bag newBag2 = null;
        Bag newBag3 = null;
        Bag newBag4 = null;
        Bag newBag5 = null;
        Bag newBag6 = null;
        Bag newBag7 = null;
        try {
            Assert.assertTrue((boolean)newBag.verifyValid().isSuccess());
            File test1File = new File(this.testBagFile, "tag.txt");
            Assert.assertFalse((boolean)test1File.exists());
            FileWriter writer = new FileWriter(test1File);
            writer.write("tag");
            writer.close();
            newBag.addFileAsTag(test1File);
            this.completer.setLimitAddTagFilepaths(new ArrayList());
            this.completer.setLimitDeleteTagFilepaths(new ArrayList());
            this.completer.setLimitUpdateTagFilepaths(new ArrayList());
            newBag2 = this.completer.complete(newBag);
            Assert.assertTrue((boolean)newBag2.verifyValid().isSuccess());
            Assert.assertTrue((boolean)newBag2.getChecksums("tag.txt").isEmpty());
            this.completer.setLimitAddTagFilepaths(Arrays.asList("tag.txt"));
            newBag3 = this.completer.complete(newBag);
            Assert.assertTrue((boolean)newBag3.verifyValid().isSuccess());
            Assert.assertFalse((boolean)newBag3.getChecksums("tag.txt").isEmpty());
            writer = new FileWriter(test1File);
            writer.write("xtag");
            writer.close();
            newBag4 = this.completer.complete(newBag2);
            Assert.assertFalse((boolean)newBag4.verifyValid().isSuccess());
            this.completer.setLimitUpdateTagFilepaths(Arrays.asList("tag.txt"));
            newBag5 = this.completer.complete(newBag2);
            Assert.assertTrue((boolean)newBag5.verifyValid().isSuccess());
            test1File.delete();
            newBag4.removeBagFile("tag.txt");
            newBag6 = this.completer.complete(newBag4);
            Assert.assertFalse((boolean)newBag6.verifyValid().isSuccess());
            this.completer.setLimitDeleteTagFilepaths(Arrays.asList("tag.txt"));
            newBag7 = this.completer.complete(newBag4);
            Assert.assertTrue((boolean)newBag7.verifyValid().isSuccess());
        }
        finally {
            newBag.close();
            if (newBag2 != null) {
                newBag2.close();
            }
            if (newBag3 != null) {
                newBag3.close();
            }
            if (newBag4 != null) {
                newBag4.close();
            }
            if (newBag5 != null) {
                newBag5.close();
            }
            if (newBag6 != null) {
                newBag6.close();
            }
            if (newBag7 != null) {
                newBag7.close();
            }
        }
    }
}

