/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.transformer.impl.SplitBySize;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import java.io.Closeable;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SplitBySizeTest {
    BagFactory bagFactory = new BagFactory();
    SplitBySize splitter;
    Bag bag;
    Collection<BagFile> srcBagPayloadFiles;
    Set<String> srcBagPayloadFileDirs = new HashSet<String>();
    Double maxPayloadSize;
    long srcBagPayloadSize = 0L;

    @Before
    public void setup() throws Exception {
        this.maxPayloadSize = new Double(20.0);
        this.splitter = new SplitBySize(this.bagFactory, this.maxPayloadSize, false, null);
        File sourceBagDir = ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag-split", BagFactory.Version.V0_96.toString().toLowerCase()));
        this.bag = this.bagFactory.createBag(sourceBagDir, BagFactory.LoadOption.BY_FILES);
        this.srcBagPayloadFiles = this.bag.getPayload();
        for (BagFile bagFile : this.srcBagPayloadFiles) {
            this.srcBagPayloadFileDirs.add(bagFile.getFilepath());
            this.srcBagPayloadSize += bagFile.getSize();
        }
        Assert.assertEquals((long)this.srcBagPayloadFileDirs.size(), (long)11L);
        Assert.assertEquals((long)this.srcBagPayloadSize, (long)55L);
    }

    @After
    public void cleanup() {
        IOUtils.closeQuietly((Closeable)this.bag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplit() {
        List newBags = this.splitter.split(this.bag);
        try {
            int fileCount = 0;
            long fileSize = 0L;
            for (Bag newBag : newBags) {
                long newBagSize = 0L;
                Collection bagFiles = newBag.getPayload();
                fileCount += bagFiles.size();
                for (BagFile bagFile : bagFiles) {
                    newBagSize += bagFile.getSize();
                    Assert.assertTrue((boolean)this.srcBagPayloadFileDirs.contains(bagFile.getFilepath()));
                }
                Assert.assertTrue(((double)newBagSize <= this.maxPayloadSize ? 1 : 0) != 0);
                fileSize += newBagSize;
            }
            Assert.assertEquals((long)fileCount, (long)this.srcBagPayloadFiles.size());
            Assert.assertEquals((long)fileSize, (long)this.srcBagPayloadSize);
            Assert.assertEquals((long)newBags.size(), (long)3L);
        }
        finally {
            for (Bag bag : newBags) {
                IOUtils.closeQuietly((Closeable)bag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitWithoutBagInfoTxt() {
        this.bag.removeBagFile(this.bag.getBagConstants().getBagInfoTxt());
        List newBags = this.splitter.split(this.bag);
        try {
            int fileCount = 0;
            long fileSize = 0L;
            for (Bag newBag : newBags) {
                long newBagSize = 0L;
                Collection bagFiles = newBag.getPayload();
                fileCount += bagFiles.size();
                for (BagFile bagFile : bagFiles) {
                    newBagSize += bagFile.getSize();
                    Assert.assertTrue((boolean)this.srcBagPayloadFileDirs.contains(bagFile.getFilepath()));
                }
                Assert.assertTrue(((double)newBagSize <= this.maxPayloadSize ? 1 : 0) != 0);
                fileSize += newBagSize;
            }
            Assert.assertEquals((long)fileCount, (long)this.srcBagPayloadFiles.size());
            Assert.assertEquals((long)fileSize, (long)this.srcBagPayloadSize);
            Assert.assertEquals((long)newBags.size(), (long)3L);
        }
        finally {
            for (Bag bag : newBags) {
                IOUtils.closeQuietly((Closeable)bag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitKeepLowestLevelDir() {
        this.splitter.setKeepLowestLevelDir(true);
        Assert.assertTrue((boolean)this.splitter.isKeepLowestLevelDir());
        List newBags = this.splitter.split(this.bag);
        try {
            boolean containsDir1 = false;
            boolean containsDir3 = false;
            int fileCount = 0;
            long fileSize = 0L;
            for (Bag newBag : newBags) {
                long newBagSize = 0L;
                Collection bagFiles = newBag.getPayload();
                HashSet<String> bagFileDirs = new HashSet<String>();
                fileCount += bagFiles.size();
                for (BagFile bagFile : bagFiles) {
                    newBagSize += bagFile.getSize();
                    bagFileDirs.add(bagFile.getFilepath());
                    Assert.assertTrue((boolean)this.srcBagPayloadFileDirs.contains(bagFile.getFilepath()));
                }
                if (bagFileDirs.contains("data/dir1/test3.txt")) {
                    Assert.assertTrue((boolean)bagFileDirs.contains("data/dir1/test3.xml"));
                    Assert.assertTrue((boolean)bagFileDirs.contains("data/dir1/test3.html"));
                    containsDir1 = true;
                }
                if (bagFileDirs.contains("data/dir2/dir3/test5.txt")) {
                    Assert.assertTrue((boolean)bagFileDirs.contains("data/dir2/dir3/test5.xml"));
                    Assert.assertTrue((boolean)bagFileDirs.contains("data/dir2/dir3/test5.html"));
                    containsDir3 = true;
                }
                Assert.assertTrue(((double)newBagSize <= this.maxPayloadSize ? 1 : 0) != 0);
                fileSize += newBagSize;
            }
            Assert.assertTrue((boolean)containsDir1);
            Assert.assertTrue((boolean)containsDir3);
            Assert.assertEquals((long)fileCount, (long)this.srcBagPayloadFiles.size());
            Assert.assertEquals((long)fileSize, (long)this.srcBagPayloadSize);
            Assert.assertEquals((long)newBags.size(), (long)3L);
        }
        finally {
            for (Bag bag : newBags) {
                IOUtils.closeQuietly((Closeable)bag);
            }
        }
    }

    @Test
    public void testSplitExcludeDirs() {
        this.splitter.setExludeDirs(new String[]{"data/dir1"});
        Assert.assertEquals((long)this.splitter.getExludeDirs().length, (long)1L);
        List newBags = this.splitter.split(this.bag);
        int fileCount = 0;
        for (Bag newBag : newBags) {
            Collection bagFiles = newBag.getPayload();
            HashSet<String> bagFileDirs = new HashSet<String>();
            fileCount += bagFiles.size();
            for (BagFile bagFile : bagFiles) {
                bagFileDirs.add(bagFile.getFilepath());
            }
            Assert.assertFalse((boolean)bagFileDirs.contains("data/dir1/test3.txt"));
            Assert.assertFalse((boolean)bagFileDirs.contains("data/dir1/test3.xml"));
            Assert.assertFalse((boolean)bagFileDirs.contains("data/dir1/test3.html"));
        }
        Assert.assertEquals((long)fileCount, (long)(this.srcBagPayloadFiles.size() - 3));
        Assert.assertEquals((long)newBags.size(), (long)2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitKeepLowestLevelDirAndExcludeDirs() {
        this.splitter.setKeepLowestLevelDir(true);
        this.splitter.setExludeDirs(new String[]{"data/dir1"});
        List newBags = this.splitter.split(this.bag);
        try {
            boolean containsDir3 = false;
            int fileCount = 0;
            for (Bag newBag : newBags) {
                long newBagSize = 0L;
                Collection bagFiles = newBag.getPayload();
                HashSet<String> bagFileDirs = new HashSet<String>();
                fileCount += bagFiles.size();
                for (BagFile bagFile : bagFiles) {
                    newBagSize += bagFile.getSize();
                    bagFileDirs.add(bagFile.getFilepath());
                    Assert.assertTrue((boolean)this.srcBagPayloadFileDirs.contains(bagFile.getFilepath()));
                }
                Assert.assertFalse((boolean)bagFileDirs.contains("data/dir1/test3.txt"));
                Assert.assertFalse((boolean)bagFileDirs.contains("data/dir1/test3.xml"));
                Assert.assertFalse((boolean)bagFileDirs.contains("data/dir1/test3.html"));
                if (bagFileDirs.contains("data/dir2/dir3/test5.txt")) {
                    Assert.assertTrue((boolean)bagFileDirs.contains("data/dir2/dir3/test5.xml"));
                    Assert.assertTrue((boolean)bagFileDirs.contains("data/dir2/dir3/test5.html"));
                    containsDir3 = true;
                }
                Assert.assertTrue(((double)newBagSize <= this.maxPayloadSize ? 1 : 0) != 0);
            }
            Assert.assertTrue((boolean)containsDir3);
            Assert.assertEquals((long)fileCount, (long)(this.srcBagPayloadFiles.size() - 3));
            Assert.assertEquals((long)newBags.size(), (long)2L);
        }
        finally {
            for (Bag bag : newBags) {
                IOUtils.closeQuietly((Closeable)bag);
            }
        }
    }

    @Test
    public void testSplitWithException() {
        this.maxPayloadSize = new Double(10.0);
        this.splitter.setKeepLowestLevelDir(true);
        this.splitter.setMaxBagSize(this.maxPayloadSize);
        this.splitter.setExludeDirs(null);
        boolean caughtEx = false;
        try {
            this.splitter.split(this.bag);
        }
        catch (Exception e) {
            caughtEx = true;
        }
        Assert.assertTrue((boolean)caughtEx);
        this.maxPayloadSize = new Double(4.0);
        this.splitter.setMaxBagSize(this.maxPayloadSize);
        caughtEx = false;
        try {
            this.splitter.split(this.bag);
        }
        catch (Exception e) {
            caughtEx = true;
        }
        Assert.assertTrue((boolean)caughtEx);
    }
}

