/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.transformer.HolePuncher;
import gov.loc.repository.bagit.transformer.impl.HolePuncherImpl;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HolePuncherImplTest {
    BagFactory bagFactory = new BagFactory();
    HolePuncher puncher;

    @Before
    public void setup() {
        this.puncher = new HolePuncherImpl(this.bagFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMakeHoley() throws Exception {
        Bag bag = this.bagFactory.createBag(ResourceHelper.getFile("bags/v0_96/bag-with-space"));
        try {
            Assert.assertEquals((long)5L, (long)bag.getPayload().size());
            Assert.assertNull((Object)bag.getFetchTxt());
            Bag newBag = this.puncher.makeHoley(bag, "http://foo.com/bag", true, false, false);
            try {
                FetchTxt fetch = newBag.getFetchTxt();
                Assert.assertNotNull((Object)fetch);
                Assert.assertEquals((long)5L, (long)fetch.size());
                boolean foundNoSpace = false;
                boolean foundSpace = false;
                for (int i = 0; i < fetch.size(); ++i) {
                    FetchTxt.FilenameSizeUrl filenameSizeUrl = (FetchTxt.FilenameSizeUrl)fetch.get(i);
                    System.out.println(filenameSizeUrl.getFilename());
                    if ("data/dir2/dir3/test5.txt".equals(filenameSizeUrl.getFilename())) {
                        Assert.assertEquals((Object)5L, (Object)filenameSizeUrl.getSize());
                        Assert.assertEquals((Object)"http://foo.com/bag/data/dir2/dir3/test5.txt", (Object)filenameSizeUrl.getUrl());
                        foundNoSpace = true;
                        continue;
                    }
                    if (!"data/test 1.txt".equals(filenameSizeUrl.getFilename())) continue;
                    Assert.assertEquals((Object)5L, (Object)filenameSizeUrl.getSize());
                    Assert.assertEquals((Object)"http://foo.com/bag/data/test%201.txt", (Object)filenameSizeUrl.getUrl());
                    foundSpace = true;
                }
                Assert.assertTrue((boolean)foundNoSpace);
                Assert.assertTrue((boolean)foundSpace);
                Assert.assertEquals((long)0L, (long)newBag.getPayload().size());
            }
            finally {
                bag.close();
            }
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMakeHoleyWithSlash() throws Exception {
        Bag bag = this.bagFactory.createBag(ResourceHelper.getFile("bags/v0_96/bag"));
        try {
            Assert.assertEquals((long)5L, (long)bag.getPayload().size());
            Assert.assertNull((Object)bag.getFetchTxt());
            bag = this.bagFactory.createBag(ResourceHelper.getFile("bags/v0_96/bag"));
            Bag newBag = this.puncher.makeHoley(bag, "http://foo.com/bag/", false, false, false);
            try {
                FetchTxt fetch = newBag.getFetchTxt();
                Assert.assertNotNull((Object)fetch);
                Assert.assertEquals((long)5L, (long)fetch.size());
                for (int i = 0; i < fetch.size(); ++i) {
                    FetchTxt.FilenameSizeUrl filenameSizeUrl = (FetchTxt.FilenameSizeUrl)fetch.get(i);
                    System.out.println(filenameSizeUrl.getFilename());
                    if ("data/dir2/dir3/test5.txt".equals(filenameSizeUrl.getFilename())) {
                        Assert.assertEquals((Object)5L, (Object)filenameSizeUrl.getSize());
                        Assert.assertEquals((Object)"http://foo.com/bag/dir2/dir3/test5.txt", (Object)filenameSizeUrl.getUrl());
                        continue;
                    }
                    if ("data/test1.txt".equals(filenameSizeUrl.getFilename())) {
                        Assert.assertEquals((Object)5L, (Object)filenameSizeUrl.getSize());
                        Assert.assertEquals((Object)"http://foo.com/bag/test1.txt", (Object)filenameSizeUrl.getUrl());
                        continue;
                    }
                    if ("data/test2.txt".equals(filenameSizeUrl.getFilename())) {
                        Assert.assertEquals((Object)5L, (Object)filenameSizeUrl.getSize());
                        Assert.assertEquals((Object)"http://foo.com/bag/test2.txt", (Object)filenameSizeUrl.getUrl());
                        continue;
                    }
                    if ("data/dir1/test3.txt".equals(filenameSizeUrl.getFilename())) {
                        Assert.assertEquals((Object)5L, (Object)filenameSizeUrl.getSize());
                        Assert.assertEquals((Object)"http://foo.com/bag/dir1/test3.txt", (Object)filenameSizeUrl.getUrl());
                        continue;
                    }
                    if ("data/dir2/test4.txt".equals(filenameSizeUrl.getFilename())) {
                        Assert.assertEquals((Object)5L, (Object)filenameSizeUrl.getSize());
                        Assert.assertEquals((Object)"http://foo.com/bag/dir2/test4.txt", (Object)filenameSizeUrl.getUrl());
                        continue;
                    }
                    Assert.fail((String)("Found unexpected line in fetch.txt: " + filenameSizeUrl));
                }
            }
            finally {
                bag.close();
            }
        }
        finally {
            bag.close();
        }
    }
}

