/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.BagItTxt;
import gov.loc.repository.bagit.Cancellable;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.ManifestHelper;
import gov.loc.repository.bagit.ProgressListener;
import gov.loc.repository.bagit.bag.CancelTriggeringBagDecorator;
import gov.loc.repository.bagit.progresslistener.LoggingProgressListener;
import gov.loc.repository.bagit.transformer.impl.DefaultCompleter;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import java.io.Closeable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultCompleterTest {
    BagFactory bagFactory = new BagFactory();
    DefaultCompleter completer;
    Bag bag;

    @Before
    public void setup() throws Exception {
        this.completer = new DefaultCompleter(this.bagFactory);
        this.completer.addProgressListener((ProgressListener)new LoggingProgressListener());
        this.bag = this.bagFactory.createBag();
        this.bag.addFileToPayload(ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag/data/dir1", BagFactory.LATEST.toString().toLowerCase())));
        this.bag.addFileToPayload(ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag/data/dir2", BagFactory.LATEST.toString().toLowerCase())));
        this.bag.addFileToPayload(ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag/data/test1.txt", BagFactory.LATEST.toString().toLowerCase())));
        this.bag.addFileToPayload(ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag/data/test2.txt", BagFactory.LATEST.toString().toLowerCase())));
        Manifest manifest = this.bag.getBagPartFactory().createManifest(ManifestHelper.getPayloadManifestFilename((Manifest.Algorithm)Manifest.Algorithm.SHA1, (Bag.BagConstants)this.bag.getBagConstants()));
        manifest.put((Object)"data/test1.txt", (Object)"b444ac06613fc8d63795be9ad0beaf55011936ac");
        this.bag.putBagFile((BagFile)manifest);
        this.bag.putBagFile((BagFile)this.bag.getBagPartFactory().createManifest(ManifestHelper.getTagManifestFilename((Manifest.Algorithm)Manifest.Algorithm.SHA1, (Bag.BagConstants)this.bag.getBagConstants())));
        Assert.assertEquals((long)5L, (long)this.bag.getPayload().size());
        Assert.assertNotNull((Object)this.bag.getPayloadManifest(Manifest.Algorithm.SHA1));
        Assert.assertNotNull((Object)this.bag.getTagManifest(Manifest.Algorithm.SHA1));
        Assert.assertNotNull(this.bag.getChecksums("data/test1.txt").get(Manifest.Algorithm.SHA1));
    }

    @After
    public void cleanup() {
        IOUtils.closeQuietly((Closeable)this.bag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComplete() throws Exception {
        Bag newBag = this.completer.complete(this.bag);
        try {
            Assert.assertTrue((boolean)newBag.verifyComplete().isSuccess());
            Assert.assertTrue((boolean)newBag.verifyValid().isSuccess());
            Assert.assertNotNull((Object)newBag.getPayloadManifest(Manifest.Algorithm.SHA1));
            Assert.assertNull((Object)newBag.getTagManifest(Manifest.Algorithm.SHA1));
            Assert.assertNotNull(newBag.getChecksums("data/test1.txt").get(Manifest.Algorithm.SHA1));
            Assert.assertNull(newBag.getChecksums("data/test1.txt").get(Manifest.Algorithm.MD5));
            BagItTxt bagIt = newBag.getBagItTxt();
            Assert.assertEquals((Object)"UTF-8", (Object)bagIt.getCharacterEncoding());
            Assert.assertEquals((Object)BagFactory.LATEST.versionString, (Object)bagIt.getVersion());
            Assert.assertEquals((long)1L, (long)newBag.getTagManifests().size());
            Assert.assertEquals((long)2L, (long)newBag.getPayloadManifests().size());
            BagInfoTxt bagInfo = newBag.getBagInfoTxt();
            Assert.assertNotNull((Object)bagInfo);
            Assert.assertEquals((Object)"25.5", (Object)bagInfo.getPayloadOxum());
            Assert.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime()), (Object)bagInfo.getBaggingDate());
            Assert.assertEquals((Object)"0.2 KB", (Object)bagInfo.getBagSize());
        }
        finally {
            newBag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompleteWithClear() throws Exception {
        this.completer.setClearExistingPayloadManifests(true);
        Bag newBag = this.completer.complete(this.bag);
        try {
            Assert.assertTrue((boolean)newBag.verifyComplete().isSuccess());
            Assert.assertTrue((boolean)newBag.verifyValid().isSuccess());
            Assert.assertNull((Object)newBag.getPayloadManifest(Manifest.Algorithm.SHA1));
            Assert.assertNull((Object)newBag.getTagManifest(Manifest.Algorithm.SHA1));
            Assert.assertNull(newBag.getChecksums("data/test1.txt").get(Manifest.Algorithm.SHA1));
            Assert.assertNotNull(newBag.getChecksums("data/test1.txt").get(Manifest.Algorithm.MD5));
            BagItTxt bagIt = newBag.getBagItTxt();
            Assert.assertEquals((Object)"UTF-8", (Object)bagIt.getCharacterEncoding());
            Assert.assertEquals((Object)BagFactory.LATEST.versionString, (Object)bagIt.getVersion());
            Assert.assertEquals((long)1L, (long)newBag.getTagManifests().size());
            Assert.assertEquals((long)1L, (long)newBag.getPayloadManifests().size());
            BagInfoTxt bagInfo = newBag.getBagInfoTxt();
            Assert.assertNotNull((Object)bagInfo);
            Assert.assertEquals((Object)"25.5", (Object)bagInfo.getPayloadOxum());
            Assert.assertEquals((Object)new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime()), (Object)bagInfo.getBaggingDate());
            Assert.assertEquals((Object)"0.2 KB", (Object)bagInfo.getBagSize());
        }
        finally {
            newBag.close();
        }
    }

    @Test
    public void testCancel() throws Exception {
        Assert.assertNull((Object)this.completer.complete((Bag)new CancelTriggeringBagDecorator(this.bag, 3, (Cancellable)this.completer)));
    }
}

