/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.ManifestHelper;
import gov.loc.repository.bagit.transformer.impl.CompleterHelper;
import gov.loc.repository.bagit.utilities.MessageDigestHelper;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompleterHelperTest {
    BagFactory bagFactory = new BagFactory();
    CompleterHelper completerHelper;
    Bag bag;
    File testBagFile;

    private File createTestBag() throws Exception {
        File sourceBagDir = ResourceHelper.getFile("bags/v0_96/bag");
        File testBagDir = new File(sourceBagDir.getParentFile(), "test_bag");
        if (testBagDir.exists()) {
            FileUtils.forceDelete((File)testBagDir);
        }
        FileUtils.copyDirectory((File)sourceBagDir, (File)testBagDir);
        return testBagDir;
    }

    @Before
    public void setup() throws Exception {
        this.completerHelper = new CompleterHelper();
        this.testBagFile = this.createTestBag();
        this.bag = this.bagFactory.createBag(this.testBagFile);
        Assert.assertTrue((boolean)this.bag.verifyValid().isSuccess());
    }

    @After
    public void cleanup() {
        IOUtils.closeQuietly((Closeable)this.bag);
    }

    @Test
    public void testUpdateTagManifestsWithoutCleaning() throws Exception {
        Manifest newManifest = this.bag.getBagPartFactory().createManifest(ManifestHelper.getPayloadManifestFilename((Manifest.Algorithm)Manifest.Algorithm.SHA256, (Bag.BagConstants)this.bag.getBagConstants()));
        File payloadFile = new File(this.testBagFile, "data/test1.txt");
        newManifest.put((Object)"data/test1.txt", (Object)MessageDigestHelper.generateFixity((File)payloadFile, (Manifest.Algorithm)Manifest.Algorithm.SHA256));
        Assert.assertNull((Object)newManifest.originalInputStream());
        this.bag.putBagFile((BagFile)newManifest);
        this.bag.getTagManifest(Manifest.Algorithm.MD5).put((Object)ManifestHelper.getPayloadManifestFilename((Manifest.Algorithm)Manifest.Algorithm.SHA256, (Bag.BagConstants)this.bag.getBagConstants()), (Object)MessageDigestHelper.generateFixity((InputStream)newManifest.newInputStream(), (Manifest.Algorithm)Manifest.Algorithm.MD5));
        for (Manifest manifest : this.bag.getTagManifests()) {
            this.completerHelper.regenerateManifest(this.bag, manifest, true);
        }
        Assert.assertTrue((boolean)this.bag.verifyValid().isSuccess());
    }
}

