/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer.fetch;

import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.transfer.FetchContext;
import gov.loc.repository.bagit.transfer.FetchedFileDestination;
import gov.loc.repository.bagit.transfer.FileFetcher;
import gov.loc.repository.bagit.transfer.NullFetchContext;
import gov.loc.repository.bagit.transfer.dest.FileSystemFileDestination;
import gov.loc.repository.bagit.transfer.fetch.LocalFileFetchProtocol;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class LocalFileFetchProtocolTest {
    private static File tempDir = new File("target/unittestdata/LocalFileFetchProtocolTest");
    private LocalFileFetchProtocol unit = new LocalFileFetchProtocol();
    private FileSystemFileDestination destination;

    @Before
    public void setUp() throws Exception {
        if (tempDir.exists()) {
            FileUtils.forceDelete((File)tempDir);
        }
        tempDir.mkdirs();
        this.destination = new FileSystemFileDestination(tempDir);
    }

    @After
    public void tearDown() throws Exception {
        if (tempDir.exists()) {
            FileUtils.forceDelete((File)tempDir);
        }
    }

    @Test
    public void testCopiesFiles() throws Exception {
        File src = ResourceHelper.getFile("bags/v0_96/bag/data/test1.txt");
        URI uri = src.toURI();
        FileFetcher fetcher = this.unit.createFetcher(uri, null);
        FetchedFileDestination destinationLocation = this.destination.createDestination("data/test1.txt", null);
        fetcher.fetchFile(uri, null, destinationLocation, (FetchContext)new NullFetchContext());
        BagFile bagFile = destinationLocation.commit();
        Assert.assertEquals((String)"data/test1.txt", (String)bagFile.getFilepath());
        Assert.assertTrue((boolean)bagFile.exists());
        Assert.assertEquals((long)5L, (long)bagFile.getSize());
        Assert.assertEquals((String)"test1", (String)IOUtils.toString((InputStream)new AutoCloseInputStream(bagFile.newInputStream())));
        File test1File = new File(tempDir, "data/test1.txt");
        Assert.assertTrue((boolean)test1File.exists());
        Assert.assertEquals((long)5L, (long)test1File.length());
        Assert.assertEquals((String)"test1", (String)IOUtils.toString((InputStream)new AutoCloseInputStream((InputStream)new FileInputStream(test1File))));
    }
}

