/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer.fetch;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.transfer.BagFetcher;
import gov.loc.repository.bagit.transfer.FetchContext;
import gov.loc.repository.bagit.transfer.FetchProtocol;
import gov.loc.repository.bagit.transfer.FetchedFileDestination;
import gov.loc.repository.bagit.transfer.FetchedFileDestinationFactory;
import gov.loc.repository.bagit.transfer.FileFetcher;
import gov.loc.repository.bagit.transfer.NullFetchContext;
import gov.loc.repository.bagit.transfer.dest.FileSystemFileDestination;
import gov.loc.repository.bagit.transfer.fetch.HttpFetchProtocol;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import gov.loc.repository.bagit.writer.impl.FileSystemWriter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.webapp.WebAppContext;

@RunWith(value=JMock.class)
public class HttpFetchProtocolTest {
    private static final URI TEST1_URI = HttpFetchProtocolTest.newV96Uri("data/test%201.txt");
    private static Server webServer;
    private Mockery context = new JUnit4Mockery();
    private File testDataRoot = new File("target/unittestdata/HttpFetchProtocolTest");
    private BagFactory bagFactory = new BagFactory();

    @BeforeClass
    public static void startJetty() throws Exception {
        webServer = new Server(8989);
        WebAppContext context = new WebAppContext(ResourceHelper.TEST_DATA_DIR.getAbsolutePath(), "/");
        webServer.addHandler((Handler)context);
        webServer.start();
    }

    @AfterClass
    public static void stopJetty() throws Exception {
        if (webServer != null) {
            webServer.stop();
        }
    }

    @After
    public void cleanUpTestData() throws Exception {
        FileUtils.deleteDirectory((File)this.testDataRoot);
    }

    private static URI newV96Uri(String path) {
        return URI.create("http://localhost:8989/bags/v0_96/bag-with-space/" + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJettyIsUp() throws Exception {
        URL url = new URL("http://localhost:8989/bags/v0_96/bag/bagit.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        try {
            String line = reader.readLine();
            Assert.assertEquals((Object)"BagIt-Version: 0.96", (Object)line);
            line = reader.readLine();
            Assert.assertEquals((Object)"Tag-File-Character-Encoding: UTF-8", (Object)line);
            line = reader.readLine();
            Assert.assertNull((Object)line);
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void testFetchesFiles() throws Exception {
        final FetchedFileDestination destination = (FetchedFileDestination)this.context.mock(FetchedFileDestination.class);
        final ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchedFileDestination)this.oneOf(destination)).openOutputStream(false);
                this.will(1.returnValue((Object)stream));
                ((FetchedFileDestination)this.allowing(destination)).getFilepath();
                this.will(1.returnValue((Object)"/tmp/unittest"));
            }
        });
        HttpFetchProtocol protocol = new HttpFetchProtocol();
        FileFetcher fetcher = protocol.createFetcher(TEST1_URI, null);
        fetcher.fetchFile(TEST1_URI, null, destination, (FetchContext)new NullFetchContext());
        Assert.assertEquals((Object)IOUtils.toString((InputStream)TEST1_URI.toURL().openStream()), (Object)new String(stream.toByteArray()));
    }

    @Test
    public void testWorksWithBagFetcher() throws Exception {
        File testDestination = new File(this.testDataRoot, "testWorksWithBagFetcher");
        System.out.println("Writing to: " + testDestination);
        Bag bag = this.bagFactory.createBag(ResourceHelper.getFile("bags/v0_96/holey-bag"));
        HoleyWriter writer = new HoleyWriter(this.bagFactory);
        writer.write(bag, testDestination);
        BagFetcher fetcher = new BagFetcher(this.bagFactory);
        fetcher.setNumberOfThreads(1);
        fetcher.registerProtocol("http", (FetchProtocol)new HttpFetchProtocol());
        fetcher.fetch(bag, (FetchedFileDestinationFactory)new FileSystemFileDestination(testDestination), false);
        Bag newBag = this.bagFactory.createBag(testDestination);
        Assert.assertTrue((boolean)newBag.verifyValid().isSuccess());
    }

    private static class HoleyWriter
    extends FileSystemWriter {
        public HoleyWriter(BagFactory bagFactory) {
            super(bagFactory);
        }

        public void visitPayload(BagFile bagFile) {
        }
    }
}

