/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer.fetch;

import gov.loc.cygwin.Cygpath;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.transfer.BagTransferException;
import gov.loc.repository.bagit.transfer.FetchedFileDestination;
import gov.loc.repository.bagit.transfer.dest.ByteArrayFetchDestination;
import gov.loc.repository.bagit.transfer.fetch.ExternalRsyncFetchProtocol;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import java.io.InputStream;
import java.net.URI;
import junit.framework.Assert;
import org.apache.commons.io.IOUtils;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExternalRsyncFetchProtocolTest {
    private static boolean skipTests = false;

    @BeforeClass
    public static void checkForRsyncInstallation() {
        ExternalRsyncFetchProtocol protocol = new ExternalRsyncFetchProtocol();
        try {
            protocol.checkRsyncSanity();
            skipTests = false;
        }
        catch (BagTransferException e) {
            skipTests = true;
            System.err.println("Could not find installed rysnc for unit tests.");
            e.printStackTrace(System.err);
        }
    }

    @Test
    public void testFetchesCorrectly() throws Exception {
        if (skipTests) {
            return;
        }
        ByteArrayFetchDestination destination = new ByteArrayFetchDestination("foo.txt");
        ExternalRsyncFetchProtocol protocol = new ExternalRsyncFetchProtocol();
        ExternalRsyncFetchProtocol.ExternalRsyncFetcher fetcher = protocol.createFetcher(new URI("rsync:///bar.txt"), null);
        String path = Cygpath.toUnix((String)ResourceHelper.getFile("bags/v0_96/bag/data/test1.txt").getAbsolutePath());
        URI uri = new URI(path);
        fetcher.initialize();
        fetcher.fetchFile(uri, null, (FetchedFileDestination)destination, null);
        BagFile bagFile = destination.commit();
        fetcher.close();
        Assert.assertEquals((String)"foo.txt", (String)bagFile.getFilepath());
        String data = IOUtils.toString((InputStream)bagFile.newInputStream());
        Assert.assertEquals((String)"test1", (String)data);
    }

    @Test
    public void testUnescapesSpacesBeforePassingToCommandline() throws Exception {
        if (skipTests) {
            return;
        }
        ByteArrayFetchDestination destination = new ByteArrayFetchDestination("foo bar.txt");
        ExternalRsyncFetchProtocol protocol = new ExternalRsyncFetchProtocol();
        ExternalRsyncFetchProtocol.ExternalRsyncFetcher fetcher = protocol.createFetcher(new URI("rsync:///bar.txt"), null);
        String path = Cygpath.toUnix((String)ResourceHelper.getFile("bags/v0_96/bag-with-escapable-characters/data/test file with spaces.txt").getAbsolutePath());
        path = path.replace(" ", "%20");
        URI uri = new URI(path);
        fetcher.initialize();
        fetcher.fetchFile(uri, null, (FetchedFileDestination)destination, null);
        BagFile bagFile = destination.commit();
        fetcher.close();
        Assert.assertEquals((String)"foo bar.txt", (String)bagFile.getFilepath());
        String data = IOUtils.toString((InputStream)bagFile.newInputStream());
        Assert.assertEquals((String)"test file with spaces", (String)data);
    }
}

