/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer.dest;

import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.transfer.FetchedFileDestination;
import gov.loc.repository.bagit.transfer.dest.FileSystemFileDestination;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class FileSystemFileDestinationTest {
    private static File tempDir = new File("target/unittestdata/FileSystemFileDestinationTest");
    private FileSystemFileDestination unit;

    @Before
    public void setUp() throws Exception {
        if (tempDir.exists()) {
            FileUtils.forceDelete((File)tempDir);
        }
        tempDir.mkdirs();
        this.unit = new FileSystemFileDestination(tempDir);
    }

    @After
    public void tearDown() throws Exception {
        if (tempDir.exists()) {
            FileUtils.forceDelete((File)tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreatesFiles() throws Exception {
        FetchedFileDestination destination = this.unit.createDestination("data/foo/bar.txt", Long.valueOf(23L));
        Assert.assertEquals((String)"data/foo/bar.txt", (String)destination.getFilepath());
        OutputStream stream = destination.openOutputStream(false);
        try {
            IOUtils.write((String)"testing testing 1 2 3 4", (OutputStream)stream);
        }
        finally {
            stream.close();
        }
        BagFile bagFile = destination.commit();
        Assert.assertEquals((long)23L, (long)bagFile.getSize());
        Assert.assertEquals((String)"data/foo/bar.txt", (String)bagFile.getFilepath());
        String data = IOUtils.toString((InputStream)new AutoCloseInputStream(bagFile.newInputStream()));
        Assert.assertEquals((String)"testing testing 1 2 3 4", (String)data);
        File resultFile = new File(tempDir, "data/foo/bar.txt");
        Assert.assertTrue((boolean)resultFile.exists());
        Assert.assertEquals((long)23L, (long)resultFile.length());
        data = IOUtils.toString((InputStream)new AutoCloseInputStream((InputStream)new FileInputStream(resultFile)));
        Assert.assertEquals((String)"testing testing 1 2 3 4", (String)data);
    }
}

