/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer;

import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.transfer.ChainSorter;
import gov.loc.repository.bagit.transfer.FetchFilenameSorter;
import gov.loc.repository.bagit.transfer.FetchSizeSorter;
import java.util.Arrays;
import java.util.Comparator;
import junit.framework.Assert;
import org.junit.Test;

public class ChainSorterTests {
    private ChainSorter<FetchTxt.FilenameSizeUrl> unit;

    @Test
    public void testSortsByFirstThenSecond() {
        this.unit = new ChainSorter(new Comparator[]{new FetchFilenameSorter(), new FetchSizeSorter()});
        FetchTxt.FilenameSizeUrl[] items = new FetchTxt.FilenameSizeUrl[]{new FetchTxt.FilenameSizeUrl("/ddd", Long.valueOf(300L), "http://www.example.org/foo"), new FetchTxt.FilenameSizeUrl("/ccc", Long.valueOf(100L), "http://www.example.org/foo"), new FetchTxt.FilenameSizeUrl("/ddd", Long.valueOf(200L), "http://www.example.org/foo"), new FetchTxt.FilenameSizeUrl("/bbb", Long.valueOf(800L), "http://www.example.org/foo"), new FetchTxt.FilenameSizeUrl("/ccc", Long.valueOf(200L), "http://www.example.org/foo"), new FetchTxt.FilenameSizeUrl("/aaa", Long.valueOf(500L), "http://www.example.org/foo"), new FetchTxt.FilenameSizeUrl("/ddd", Long.valueOf(100L), "http://www.example.org/foo")};
        Arrays.sort(items, this.unit);
        Assert.assertEquals((int)7, (int)items.length);
        ChainSorterTests.assertEquals("/aaa", 500L, items[0]);
        ChainSorterTests.assertEquals("/bbb", 800L, items[1]);
        ChainSorterTests.assertEquals("/ccc", 100L, items[2]);
        ChainSorterTests.assertEquals("/ccc", 200L, items[3]);
        ChainSorterTests.assertEquals("/ddd", 100L, items[4]);
        ChainSorterTests.assertEquals("/ddd", 200L, items[5]);
        ChainSorterTests.assertEquals("/ddd", 300L, items[6]);
    }

    public static void assertEquals(String path, Long length, FetchTxt.FilenameSizeUrl actual) {
        Assert.assertEquals((String)path, (String)actual.getFilename());
        Assert.assertEquals((Object)length, (Object)actual.getSize());
    }
}

