/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.transfer.BagFetcher;
import gov.loc.repository.bagit.transfer.BagTransferException;
import gov.loc.repository.bagit.transfer.FetchContext;
import gov.loc.repository.bagit.transfer.FetchFailStrategy;
import gov.loc.repository.bagit.transfer.FetchProtocol;
import gov.loc.repository.bagit.transfer.FetchedFileDestination;
import gov.loc.repository.bagit.transfer.FetchedFileDestinationFactory;
import gov.loc.repository.bagit.transfer.FileFetcher;
import gov.loc.repository.bagit.transfer.StandardFailStrategies;
import gov.loc.repository.bagit.transfer.ThrowExceptionFailStrategy;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import gov.loc.repository.bagit.utilities.SimpleResult;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.States;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.internal.StatePredicate;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class BagFetcherTest {
    private static File tempDir = new File("target/unittestdata/BagFetcherTest");
    private Mockery context = new Mockery();
    private BagFactory bagFactory = new BagFactory();
    private BagFetcher unit;

    @Before
    public void setUp() throws Exception {
        if (tempDir.exists()) {
            FileUtils.forceDelete((File)tempDir);
        }
        tempDir.mkdirs();
        this.unit = new BagFetcher(this.bagFactory);
        this.unit.setFetchFailStrategy((FetchFailStrategy)new ThrowExceptionFailStrategy());
        FileUtils.copyDirectory((File)ResourceHelper.getFile("bags/v0_96/holey-bag"), (File)tempDir);
        FileUtils.deleteDirectory((File)new File(tempDir, "data"));
    }

    @After
    public void tearDown() throws Exception {
        if (tempDir.exists()) {
            FileUtils.deleteQuietly((File)tempDir);
        }
    }

    @Test
    public void testFetchSingleThread() throws Exception {
        this.unit.setNumberOfThreads(1);
        final FetchedFileDestinationFactory mockDestinationFactory = (FetchedFileDestinationFactory)this.context.mock(FetchedFileDestinationFactory.class);
        final FetchProtocol mockProtocol = (FetchProtocol)this.context.mock(FetchProtocol.class);
        final FileFetcher mockFetcher = (FileFetcher)this.context.mock(FileFetcher.class);
        final States fetcherState = this.context.states("fetcher").startsAs("new");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                BagFetcherTest.this.expectDest(this, mockDestinationFactory, "data/dir1/test3.txt");
                BagFetcherTest.this.expectDest(this, mockDestinationFactory, "data/dir2/dir3/test5.txt");
                BagFetcherTest.this.expectDest(this, mockDestinationFactory, "data/dir2/test4.txt");
                BagFetcherTest.this.expectDest(this, mockDestinationFactory, "data/test 1.txt");
                BagFetcherTest.this.expectDest(this, mockDestinationFactory, "data/test2.txt");
                ((FetchProtocol)this.one(mockProtocol)).createFetcher(new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt"), null);
                this.will(1.returnValue((Object)mockFetcher));
                ((FileFetcher)this.one(mockFetcher)).initialize();
                this.when((StatePredicate)fetcherState.is("new"));
                this.then(fetcherState.is("ready"));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(1.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt"))), Long.valueOf(this.with(1.any(Long.class))), (FetchedFileDestination)this.with(1.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(1.aNonNull(FetchContext.class)));
                this.when((StatePredicate)fetcherState.is("ready"));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(1.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir2/dir3/test5.txt"))), Long.valueOf(this.with(1.any(Long.class))), (FetchedFileDestination)this.with(1.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(1.aNonNull(FetchContext.class)));
                this.when((StatePredicate)fetcherState.is("ready"));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(1.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir2/test4.txt"))), Long.valueOf(this.with(1.any(Long.class))), (FetchedFileDestination)this.with(1.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(1.aNonNull(FetchContext.class)));
                this.when((StatePredicate)fetcherState.is("ready"));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(1.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/test%201.txt"))), Long.valueOf(this.with(1.any(Long.class))), (FetchedFileDestination)this.with(1.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(1.aNonNull(FetchContext.class)));
                this.when((StatePredicate)fetcherState.is("ready"));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(1.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/test2.txt"))), Long.valueOf(this.with(1.any(Long.class))), (FetchedFileDestination)this.with(1.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(1.aNonNull(FetchContext.class)));
                this.when((StatePredicate)fetcherState.is("ready"));
                ((FileFetcher)this.one(mockFetcher)).close();
                this.when((StatePredicate)fetcherState.is("ready"));
                this.then(fetcherState.is("closed"));
            }
        });
        this.unit.registerProtocol("http", mockProtocol);
        Bag bag = this.bagFactory.createBag(tempDir);
        SimpleResult result = this.unit.fetch(bag, mockDestinationFactory, false);
    }

    @Test
    public void testFailsFast() throws Exception {
        this.unit.setNumberOfThreads(1);
        this.unit.setFetchFailStrategy(StandardFailStrategies.FAIL_FAST);
        final FetchedFileDestinationFactory mockDestinationFactory = (FetchedFileDestinationFactory)this.context.mock(FetchedFileDestinationFactory.class);
        final FetchedFileDestination mockDestination = (FetchedFileDestination)this.context.mock(FetchedFileDestination.class);
        final FetchProtocol mockProtocol = (FetchProtocol)this.context.mock(FetchProtocol.class);
        final FileFetcher mockFetcher = (FileFetcher)this.context.mock(FileFetcher.class);
        final States fetcherState = this.context.states("fetcher").startsAs("new");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchedFileDestinationFactory)this.one(mockDestinationFactory)).createDestination("data/dir1/test3.txt", null);
                this.will(2.returnValue((Object)mockDestination));
                ((FetchedFileDestination)this.allowing(mockDestination)).getFilepath();
                this.will(2.returnValue((Object)"data/dir1/test3.txt"));
                ((FetchedFileDestination)this.never(mockDestination)).commit();
                ((FetchedFileDestination)this.one(mockDestination)).abandon();
                ((FetchProtocol)this.one(mockProtocol)).createFetcher(new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt"), null);
                this.will(2.returnValue((Object)mockFetcher));
                ((FileFetcher)this.one(mockFetcher)).initialize();
                this.when((StatePredicate)fetcherState.is("new"));
                this.then(fetcherState.is("ready"));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(2.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt"))), Long.valueOf(this.with(2.any(Long.class))), (FetchedFileDestination)this.with(2.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(2.aNonNull(FetchContext.class)));
                this.when((StatePredicate)fetcherState.is("ready"));
                this.will(2.throwException((Throwable)new BagTransferException("Unit test failure.")));
                ((FileFetcher)this.one(mockFetcher)).close();
                this.when((StatePredicate)fetcherState.is("ready"));
                this.then(fetcherState.is("closed"));
            }
        });
        this.unit.registerProtocol("http", mockProtocol);
        Bag bag = this.bagFactory.createBag(tempDir);
        SimpleResult result = this.unit.fetch(bag, mockDestinationFactory, false);
        Assert.assertFalse((String)"Bag transferred successfully when it shouldn't have.", (boolean)result.isSuccess());
    }

    @Test
    public void testRetriesFile() throws Exception {
        this.unit.setNumberOfThreads(1);
        this.unit.setFetchFailStrategy(StandardFailStrategies.ALWAYS_RETRY);
        final FetchedFileDestinationFactory mockDestinationFactory = (FetchedFileDestinationFactory)this.context.mock(FetchedFileDestinationFactory.class);
        final FetchedFileDestination mockDestination = (FetchedFileDestination)this.context.mock(FetchedFileDestination.class);
        final FetchProtocol mockProtocol = (FetchProtocol)this.context.mock(FetchProtocol.class);
        final FileFetcher mockFetcher = (FileFetcher)this.context.mock(FileFetcher.class);
        final States fetcherState = this.context.states("fetcher").startsAs("new");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchedFileDestinationFactory)this.one(mockDestinationFactory)).createDestination("data/dir1/test3.txt", null);
                this.will(3.returnValue((Object)mockDestination));
                ((FetchedFileDestination)this.allowing(mockDestination)).getFilepath();
                this.will(3.returnValue((Object)"data/dir1/test3.txt"));
                ((FetchedFileDestination)this.never(mockDestination)).commit();
                ((FetchedFileDestination)this.one(mockDestination)).abandon();
                BagFetcherTest.this.expectDest(this, mockDestinationFactory, "data/dir1/test3.txt");
                ((FetchProtocol)this.one(mockProtocol)).createFetcher(new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt"), null);
                this.will(3.returnValue((Object)mockFetcher));
                ((FileFetcher)this.one(mockFetcher)).initialize();
                this.when((StatePredicate)fetcherState.is("new"));
                this.then(fetcherState.is("ready"));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(3.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt"))), Long.valueOf(this.with(3.any(Long.class))), (FetchedFileDestination)this.with(3.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(3.aNonNull(FetchContext.class)));
                this.when((StatePredicate)fetcherState.is("ready"));
                this.will(3.throwException((Throwable)new BagTransferException("Unit test failure.")));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(3.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt"))), Long.valueOf(this.with(3.any(Long.class))), (FetchedFileDestination)this.with(3.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(3.aNonNull(FetchContext.class)));
                this.when((StatePredicate)fetcherState.is("ready"));
                ((FileFetcher)this.one(mockFetcher)).close();
                this.when((StatePredicate)fetcherState.is("ready"));
                this.then(fetcherState.is("closed"));
            }
        });
        this.unit.registerProtocol("http", mockProtocol);
        Bag bag = this.bagFactory.createBag(tempDir);
        bag.getFetchTxt().remove(1);
        bag.getFetchTxt().remove(1);
        bag.getFetchTxt().remove(1);
        bag.getFetchTxt().remove(1);
        SimpleResult result = this.unit.fetch(bag, mockDestinationFactory, false);
    }

    @Test
    public void testRetriesNextFile() throws Exception {
        this.unit.setNumberOfThreads(1);
        this.unit.setFetchFailStrategy(StandardFailStrategies.ALWAYS_CONTINUE);
        final FetchedFileDestinationFactory mockDestinationFactory = (FetchedFileDestinationFactory)this.context.mock(FetchedFileDestinationFactory.class);
        final FetchedFileDestination mockDestination = (FetchedFileDestination)this.context.mock(FetchedFileDestination.class);
        final FetchProtocol mockProtocol = (FetchProtocol)this.context.mock(FetchProtocol.class);
        final FileFetcher mockFetcher = (FileFetcher)this.context.mock(FileFetcher.class);
        final States fetcherState = this.context.states("fetcher").startsAs("new");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchedFileDestinationFactory)this.one(mockDestinationFactory)).createDestination("data/dir1/test3.txt", null);
                this.will(4.returnValue((Object)mockDestination));
                ((FetchedFileDestination)this.allowing(mockDestination)).getFilepath();
                this.will(4.returnValue((Object)"data/dir1/test3.txt"));
                ((FetchedFileDestination)this.never(mockDestination)).commit();
                ((FetchedFileDestination)this.one(mockDestination)).abandon();
                BagFetcherTest.this.expectDest(this, mockDestinationFactory, "data/dir2/dir3/test5.txt");
                ((FetchProtocol)this.one(mockProtocol)).createFetcher(new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt"), null);
                this.will(4.returnValue((Object)mockFetcher));
                ((FileFetcher)this.one(mockFetcher)).initialize();
                this.when((StatePredicate)fetcherState.is("new"));
                this.then(fetcherState.is("ready"));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(4.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt"))), Long.valueOf(this.with(4.any(Long.class))), (FetchedFileDestination)this.with(4.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(4.aNonNull(FetchContext.class)));
                this.when((StatePredicate)fetcherState.is("ready"));
                this.will(4.throwException((Throwable)new BagTransferException("Unit test failure.")));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(4.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir2/dir3/test5.txt"))), Long.valueOf(this.with(4.any(Long.class))), (FetchedFileDestination)this.with(4.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(4.aNonNull(FetchContext.class)));
                this.when((StatePredicate)fetcherState.is("ready"));
                ((FileFetcher)this.one(mockFetcher)).close();
                this.when((StatePredicate)fetcherState.is("ready"));
                this.then(fetcherState.is("closed"));
            }
        });
        this.unit.registerProtocol("http", mockProtocol);
        Bag bag = this.bagFactory.createBag(tempDir);
        bag.getFetchTxt().remove(2);
        bag.getFetchTxt().remove(2);
        bag.getFetchTxt().remove(2);
        SimpleResult result = this.unit.fetch(bag, mockDestinationFactory, false);
        Assert.assertFalse((String)"Bag failed transfer.", (boolean)result.isSuccess());
    }

    @Test
    public void testResume() throws Exception {
        this.copyPartialBag();
        this.unit.setNumberOfThreads(1);
        this.unit.setFetchFailStrategy(StandardFailStrategies.ALWAYS_CONTINUE);
        final FetchedFileDestinationFactory mockDestinationFactory = (FetchedFileDestinationFactory)this.context.mock(FetchedFileDestinationFactory.class);
        final FetchedFileDestination mockDestination = (FetchedFileDestination)this.context.mock(FetchedFileDestination.class);
        final FetchProtocol mockProtocol = (FetchProtocol)this.context.mock(FetchProtocol.class);
        final FileFetcher mockFetcher = (FileFetcher)this.context.mock(FileFetcher.class);
        Bag bag = this.bagFactory.createBag(tempDir);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FetchedFileDestinationFactory)this.one(mockDestinationFactory)).createDestination("data/dir1/test3.txt", null);
                this.will(5.returnValue((Object)mockDestination));
                ((FetchedFileDestination)this.allowing(mockDestination)).getFilepath();
                this.will(5.returnValue((Object)"data/dir1/test3.txt"));
                ((FetchedFileDestination)this.never(mockDestination)).commit();
                ((FetchedFileDestination)this.one(mockDestination)).abandon();
                BagFetcherTest.this.expectDest(this, mockDestinationFactory, "data/dir2/dir3/test5.txt");
                ((FetchProtocol)this.one(mockProtocol)).createFetcher(new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt"), null);
                this.will(5.returnValue((Object)mockFetcher));
                ((FileFetcher)this.allowing(mockFetcher)).initialize();
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(5.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt"))), Long.valueOf(this.with(5.any(Long.class))), (FetchedFileDestination)this.with(5.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(5.aNonNull(FetchContext.class)));
                this.will(5.throwException((Throwable)new BagTransferException("Unit test failure.")));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(5.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir2/dir3/test5.txt"))), Long.valueOf(this.with(5.any(Long.class))), (FetchedFileDestination)this.with(5.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(5.aNonNull(FetchContext.class)));
                ((FileFetcher)this.never(mockFetcher)).fetchFile((URI)this.with(5.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir2/test4.txt"))), Long.valueOf(this.with(5.any(Long.class))), (FetchedFileDestination)this.with(5.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(5.aNonNull(FetchContext.class)));
                ((FileFetcher)this.never(mockFetcher)).fetchFile((URI)this.with(5.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/test%201.txt"))), Long.valueOf(this.with(5.any(Long.class))), (FetchedFileDestination)this.with(5.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(5.aNonNull(FetchContext.class)));
                ((FileFetcher)this.never(mockFetcher)).fetchFile((URI)this.with(5.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/test2.txt"))), Long.valueOf(this.with(5.any(Long.class))), (FetchedFileDestination)this.with(5.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(5.aNonNull(FetchContext.class)));
                ((FileFetcher)this.allowing(mockFetcher)).close();
            }
        });
        this.unit.registerProtocol("http", mockProtocol);
        SimpleResult result = this.unit.fetch(bag, mockDestinationFactory, true, false);
        Assert.assertFalse((boolean)result.isSuccess());
        this.deletePartialBag();
    }

    @Test
    public void testVerify() throws Exception {
        this.copyPartialBag();
        this.unit.setNumberOfThreads(1);
        this.unit.setFetchFailStrategy(StandardFailStrategies.ALWAYS_CONTINUE);
        final FetchedFileDestinationFactory mockDestinationFactory = (FetchedFileDestinationFactory)this.context.mock(FetchedFileDestinationFactory.class);
        final FetchProtocol mockProtocol = (FetchProtocol)this.context.mock(FetchProtocol.class);
        final FileFetcher mockFetcher = (FileFetcher)this.context.mock(FileFetcher.class);
        Bag bag = this.bagFactory.createBag(tempDir);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                BagFetcherTest.this.expectDest(this, mockDestinationFactory, "data/test 1.txt");
                BagFetcherTest.this.expectDest(this, mockDestinationFactory, "data/test2.txt");
                ((FetchProtocol)this.one(mockProtocol)).createFetcher(new URI("http://localhost:8989/bags/v0_96/holey-bag/data/test%201.txt"), null);
                this.will(6.returnValue((Object)mockFetcher));
                ((FileFetcher)this.allowing(mockFetcher)).initialize();
                ((FileFetcher)this.never(mockFetcher)).fetchFile((URI)this.with(6.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir1/test3.txt"))), Long.valueOf(this.with(6.any(Long.class))), (FetchedFileDestination)this.with(6.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(6.aNonNull(FetchContext.class)));
                this.will(6.throwException((Throwable)new BagTransferException("Unit test failure.")));
                ((FileFetcher)this.never(mockFetcher)).fetchFile((URI)this.with(6.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir2/dir3/test5.txt"))), Long.valueOf(this.with(6.any(Long.class))), (FetchedFileDestination)this.with(6.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(6.aNonNull(FetchContext.class)));
                ((FileFetcher)this.never(mockFetcher)).fetchFile((URI)this.with(6.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/dir2/test4.txt"))), Long.valueOf(this.with(6.any(Long.class))), (FetchedFileDestination)this.with(6.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(6.aNonNull(FetchContext.class)));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(6.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/test%201.txt"))), Long.valueOf(this.with(6.any(Long.class))), (FetchedFileDestination)this.with(6.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(6.aNonNull(FetchContext.class)));
                ((FileFetcher)this.one(mockFetcher)).fetchFile((URI)this.with(6.equal((Object)new URI("http://localhost:8989/bags/v0_96/holey-bag/data/test2.txt"))), Long.valueOf(this.with(6.any(Long.class))), (FetchedFileDestination)this.with(6.aNonNull(FetchedFileDestination.class)), (FetchContext)this.with(6.aNonNull(FetchContext.class)));
                ((FileFetcher)this.allowing(mockFetcher)).close();
            }
        });
        this.unit.registerProtocol("http", mockProtocol);
        SimpleResult result = this.unit.fetch(bag, mockDestinationFactory, true, true);
        Assert.assertTrue((bag.getFetchProgressTxt() == null ? 1 : 0) != 0);
        this.deletePartialBag();
    }

    @Test(expected=BagTransferException.class)
    public void testMissingFetchTxt() throws Exception {
        FetchedFileDestinationFactory mockDestinationFactory = (FetchedFileDestinationFactory)this.context.mock(FetchedFileDestinationFactory.class);
        File fetchTxtFile = new File(tempDir, this.bagFactory.getBagConstants().getFetchTxt());
        Assert.assertTrue((boolean)fetchTxtFile.exists());
        fetchTxtFile.delete();
        Assert.assertFalse((boolean)fetchTxtFile.exists());
        Bag bag = this.bagFactory.createBag(tempDir);
        this.unit.fetch(bag, mockDestinationFactory, false);
    }

    private void expectDest(Expectations e, FetchedFileDestinationFactory destFactory, String path) throws Exception {
        FetchedFileDestination mockDestination = (FetchedFileDestination)this.context.mock(FetchedFileDestination.class, "FetchedFileDestination:" + path);
        BagFile mockCommittedFile = (BagFile)this.context.mock(BagFile.class, "BagFile:" + path);
        ((FetchedFileDestinationFactory)e.one((Object)destFactory)).createDestination(path, null);
        e.will(Expectations.returnValue((Object)mockDestination));
        ((FetchedFileDestination)e.allowing((Object)mockDestination)).getFilepath();
        e.will(Expectations.returnValue((Object)path));
        ((FetchedFileDestination)e.one((Object)mockDestination)).commit();
        e.will(Expectations.returnValue((Object)mockCommittedFile));
        ((BagFile)e.one((Object)mockCommittedFile)).exists();
        e.will(Expectations.returnValue((Object)true));
        ((BagFile)e.one((Object)mockCommittedFile)).newInputStream();
        e.will(Expectations.returnValue((Object)new FileInputStream(ResourceHelper.getFile("bags/v0_96/holey-bag/" + path))));
        ((FetchedFileDestination)e.never((Object)mockDestination)).abandon();
    }

    private void copyPartialBag() throws Exception {
        if (tempDir.exists()) {
            FileUtils.forceDelete((File)tempDir);
        }
        tempDir.mkdirs();
        this.unit = new BagFetcher(this.bagFactory);
        this.unit.setFetchFailStrategy((FetchFailStrategy)new ThrowExceptionFailStrategy());
        FileUtils.copyDirectory((File)ResourceHelper.getFile("bags/v0_96/holey-bag-partially-fetched"), (File)tempDir);
    }

    private void deletePartialBag() throws Exception {
        if (tempDir.exists()) {
            FileUtils.deleteQuietly((File)tempDir);
        }
    }
}

