/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.PreBag;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import gov.loc.repository.bagit.verify.impl.CompleteVerifierImpl;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class PreBagImplTest {
    BagFactory bagFactory = new BagFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagInPlaceWithExistingDataDir() throws Exception {
        File testDir = this.createTestBag(true);
        Assert.assertTrue((boolean)testDir.exists());
        File testDataDir = new File(testDir, "data");
        Assert.assertTrue((boolean)testDataDir.exists());
        PreBag preBag = this.bagFactory.createPreBag(testDir);
        Bag bag = preBag.makeBagInPlace(BagFactory.LATEST, false);
        try {
            Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagInPlaceRetainingBaseDir() throws Exception {
        File testDir = this.createTestBag(false);
        Assert.assertTrue((boolean)testDir.exists());
        File testDataDir = new File(testDir, "data");
        Assert.assertFalse((boolean)testDataDir.exists());
        PreBag preBag = this.bagFactory.createPreBag(testDir);
        Bag bag = preBag.makeBagInPlace(BagFactory.LATEST, true);
        try {
            Assert.assertTrue((boolean)testDataDir.exists());
            File baseDir = new File(testDataDir, "test_bag");
            Assert.assertTrue((boolean)baseDir.exists());
            Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagInPlaceNotRetainingBaseDir() throws Exception {
        File testDir = this.createTestBag(false);
        Assert.assertTrue((boolean)testDir.exists());
        File testDataDir = new File(testDir, "data");
        Assert.assertFalse((boolean)testDataDir.exists());
        PreBag preBag = this.bagFactory.createPreBag(testDir);
        Bag bag = preBag.makeBagInPlace(BagFactory.LATEST, false);
        try {
            Assert.assertTrue((boolean)testDataDir.exists());
            File baseDir = new File(testDataDir, "test_bag");
            Assert.assertFalse((boolean)baseDir.exists());
            Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagInPlaceWithIgnoredExtraDir() throws Exception {
        File testDir = this.createTestBag(false);
        Assert.assertTrue((boolean)testDir.exists());
        File testDataDir = new File(testDir, "data");
        Assert.assertFalse((boolean)testDataDir.exists());
        File extraDir = new File(testDir, "extra");
        Assert.assertFalse((boolean)extraDir.exists());
        FileUtils.forceMkdir((File)extraDir);
        Assert.assertTrue((boolean)extraDir.exists());
        File extraFile = new File(extraDir, "extra.txt");
        FileUtils.write((File)extraFile, (CharSequence)"extra");
        Assert.assertTrue((boolean)extraFile.exists());
        PreBag preBag = this.bagFactory.createPreBag(testDir);
        ArrayList<String> ignoreDirs = new ArrayList<String>();
        ignoreDirs.add("extra");
        preBag.setIgnoreAdditionalDirectories(ignoreDirs);
        Bag bag = preBag.makeBagInPlace(BagFactory.LATEST, false);
        try {
            Assert.assertTrue((boolean)testDataDir.exists());
            File baseDir = new File(testDataDir, "test_bag");
            Assert.assertFalse((boolean)baseDir.exists());
            CompleteVerifierImpl verifier = new CompleteVerifierImpl();
            verifier.setIgnoreAdditionalDirectories(ignoreDirs);
            Assert.assertTrue((boolean)verifier.verify(bag).isSuccess());
            Assert.assertTrue((boolean)extraDir.exists());
            Assert.assertTrue((boolean)extraFile.exists());
        }
        finally {
            bag.close();
        }
    }

    @Test(expected=RuntimeException.class)
    public void testBagInPlaceWithDataDirAndTagDirPrev97() throws Exception {
        File testDir = this.createTestBag(true);
        Assert.assertTrue((boolean)testDir.exists());
        File testDataDir = new File(testDir, "data");
        Assert.assertTrue((boolean)testDataDir.exists());
        File extraDir = new File(testDir, "extra");
        Assert.assertFalse((boolean)extraDir.exists());
        FileUtils.forceMkdir((File)extraDir);
        Assert.assertTrue((boolean)extraDir.exists());
        File extraFile = new File(extraDir, "extra.txt");
        FileUtils.write((File)extraFile, (CharSequence)"extra");
        Assert.assertTrue((boolean)extraFile.exists());
        PreBag preBag = this.bagFactory.createPreBag(testDir);
        preBag.makeBagInPlace(BagFactory.Version.V0_96, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagInPlaceWithDataDirAndTagDirPostv97() throws Exception {
        File testDir = this.createTestBag(true);
        Assert.assertTrue((boolean)testDir.exists());
        File testDataDir = new File(testDir, "data");
        Assert.assertTrue((boolean)testDataDir.exists());
        File extraDir = new File(testDir, "extra");
        Assert.assertFalse((boolean)extraDir.exists());
        FileUtils.forceMkdir((File)extraDir);
        Assert.assertTrue((boolean)extraDir.exists());
        File extraFile = new File(extraDir, "extra.txt");
        FileUtils.write((File)extraFile, (CharSequence)"extra");
        Assert.assertTrue((boolean)extraFile.exists());
        PreBag preBag = this.bagFactory.createPreBag(testDir);
        Bag bag = preBag.makeBagInPlace(BagFactory.LATEST, false);
        try {
            Assert.assertTrue((boolean)testDataDir.exists());
            File baseDir = new File(testDataDir, "test_bag");
            Assert.assertFalse((boolean)baseDir.exists());
            Assert.assertTrue((boolean)bag.verifyComplete().isSuccess());
            Assert.assertTrue((boolean)extraDir.exists());
            Assert.assertTrue((boolean)extraFile.exists());
            Assert.assertNotNull((Object)bag.getBagFile("extra/extra.txt"));
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagInPlaceWithEmptyDir() throws Exception {
        File testDir = this.createTestBag(false);
        Assert.assertTrue((boolean)testDir.exists());
        File emptyDir = new File(testDir, "empty");
        Assert.assertTrue((boolean)emptyDir.mkdir());
        Assert.assertTrue((boolean)emptyDir.exists());
        File testDataDir = new File(testDir, "data");
        Assert.assertFalse((boolean)testDataDir.exists());
        PreBag preBag = this.bagFactory.createPreBag(testDir);
        Bag bag = preBag.makeBagInPlace(BagFactory.LATEST, false);
        try {
            Assert.assertTrue((boolean)testDataDir.exists());
            File movedEmptyDir = new File(testDataDir, "empty");
            Assert.assertTrue((boolean)movedEmptyDir.exists());
            Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagInPlaceKeepEmptyDirectories() throws Exception {
        File testDir = this.createTestBag(false);
        Assert.assertTrue((boolean)testDir.exists());
        File testDataDir = new File(testDir, "data");
        Assert.assertFalse((boolean)testDataDir.exists());
        File emptyDir = new File(testDir, "empty_dir");
        FileUtils.forceMkdir((File)emptyDir);
        Assert.assertTrue((boolean)emptyDir.exists());
        PreBag preBag = this.bagFactory.createPreBag(testDir);
        Bag bag = preBag.makeBagInPlace(BagFactory.LATEST, true, true);
        try {
            Assert.assertTrue((boolean)testDataDir.exists());
            File baseDir = new File(testDataDir, "test_bag");
            Assert.assertTrue((boolean)baseDir.exists());
            File newEmptyDir = new File(baseDir, "empty_dir");
            Assert.assertTrue((boolean)newEmptyDir.exists());
            Assert.assertTrue((boolean)new File(newEmptyDir, ".keep").exists());
            Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    private File createTestBag(boolean includeDataDirectory) throws Exception {
        File sourceBagDir = ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag", BagFactory.LATEST.toString().toLowerCase()));
        File sourceDataDir = new File(sourceBagDir, "data");
        File testBagDir = new File(sourceBagDir.getParentFile(), "test_bag");
        if (testBagDir.exists()) {
            FileUtils.forceDelete((File)testBagDir);
        }
        if (includeDataDirectory) {
            FileUtils.copyDirectoryToDirectory((File)sourceDataDir, (File)testBagDir);
        } else {
            System.out.println("Copying " + sourceDataDir + " to " + testBagDir);
            FileUtils.copyDirectory((File)sourceDataDir, (File)testBagDir);
            Assert.assertTrue((boolean)testBagDir.exists());
        }
        return testBagDir;
    }
}

