/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.BagItTxt;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.ManifestHelper;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;

public abstract class BaseBagImplTest {
    BagFactory bagFactory = new BagFactory();
    Bag.BagPartFactory factory;
    Bag.BagConstants constants;

    public abstract BagFactory.Version getVersion();

    @Before
    public void setup() {
        this.factory = this.bagFactory.getBagPartFactory(this.getVersion());
        this.constants = this.bagFactory.getBagConstants(this.getVersion());
    }

    protected Bag getBagByPayloadManifests(Bag.Format format) throws Exception {
        return this.getBagByPayloadManifests(this.getVersion(), format);
    }

    protected Bag getBagByPayloadFiles(Bag.Format format) throws Exception {
        return this.getBagByPayloadFiles(this.getVersion(), format);
    }

    protected Bag getBagByPayloadManifests(BagFactory.Version version, Bag.Format format) throws Exception {
        return this.bagFactory.createBag(this.getBagDir(version, format), version, BagFactory.LoadOption.BY_MANIFESTS);
    }

    protected Bag getBagByPayloadFiles(BagFactory.Version version, Bag.Format format) throws Exception {
        return this.bagFactory.createBag(this.getBagDir(version, format), version, BagFactory.LoadOption.BY_FILES);
    }

    protected File getBagDir(BagFactory.Version version, Bag.Format format) throws Exception {
        String versionString = version.toString().toLowerCase();
        String extension = format.extension;
        String bagName = this.getBagName();
        return ResourceHelper.getFile(MessageFormat.format("bags/{0}/{1}{2}", versionString, bagName, extension));
    }

    protected String getBagName() {
        return "bag";
    }

    protected File createTestBag() throws Exception {
        return this.createTestBag(true);
    }

    protected File createTestBag(boolean deleteTagManifest) throws Exception {
        File sourceBagDir = ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag", this.getVersion().toString().toLowerCase()));
        File testBagDir = new File(sourceBagDir.getParentFile(), "test_bag");
        if (testBagDir.exists()) {
            FileUtils.forceDelete((File)testBagDir);
        }
        FileUtils.copyDirectory((File)sourceBagDir, (File)testBagDir);
        if (deleteTagManifest) {
            File tagManifestFile = new File(testBagDir, ManifestHelper.getTagManifestFilename((Manifest.Algorithm)Manifest.Algorithm.MD5, (Bag.BagConstants)this.constants));
            FileUtils.forceDelete((File)tagManifestFile);
        }
        return testBagDir;
    }

    protected void testBag(Bag bag) throws Exception {
        this.assertBagPayloadManifests(bag);
        this.assertBagTagManifests(bag);
        this.assertBagTagFiles(bag);
        this.assertBagPayloadFiles(bag);
        this.assertBagDeclaration(bag);
        this.assertBagInfo(bag);
        this.assertBagComplete(bag);
        this.assertBagValid(bag);
        this.assertBagVerifyTagManifests(bag);
        this.assertBagVerifyPayloadManifests(bag);
    }

    protected void assertBagVerifyPayloadManifests(Bag bag) throws Exception {
        Assert.assertTrue((String)"Verify Payload Manifests", (boolean)bag.verifyPayloadManifests().isSuccess());
    }

    protected void assertBagVerifyTagManifests(Bag bag) throws Exception {
        Assert.assertTrue((String)"Verify Tag Manifests", (boolean)bag.verifyTagManifests().isSuccess());
    }

    protected void assertBagValid(Bag bag) throws Exception {
        Assert.assertTrue((String)"Verify Valid", (boolean)bag.verifyValid().isSuccess());
    }

    protected void assertBagComplete(Bag bag) throws Exception {
        Assert.assertTrue((String)"Verify Complete", (boolean)bag.verifyComplete().isSuccess());
    }

    protected void assertBagInfo(Bag bag) throws Exception {
        BagInfoTxt bagInfo = bag.getBagInfoTxt();
        Assert.assertEquals((Object)"Spengler University", (Object)bagInfo.getSourceOrganization());
    }

    protected void assertBagDeclaration(Bag bag) throws Exception {
        BagItTxt bagIt = bag.getBagItTxt();
        Assert.assertEquals((Object)"UTF-8", (Object)bagIt.getCharacterEncoding());
        Assert.assertEquals((Object)this.getVersion().versionString, (Object)bagIt.getVersion());
    }

    protected void assertBagPayloadFiles(Bag bag) throws Exception {
        Assert.assertEquals((long)5L, (long)bag.getPayload().size());
        Assert.assertNotNull((Object)bag.getBagFile("data/dir1/test3.txt"));
        Assert.assertNull((Object)bag.getBagFile("xdata/dir1/test3.txt"));
    }

    protected void assertBagTagFiles(Bag bag) throws Exception {
        Assert.assertEquals((long)4L, (long)bag.getTags().size());
        Assert.assertNotNull((Object)bag.getBagFile("bagit.txt"));
        Assert.assertNull((Object)bag.getBagFile("xbagit.txt"));
    }

    protected void assertBagTagManifests(Bag bag) throws Exception {
        List tagManifests = bag.getTagManifests();
        Assert.assertEquals((long)1L, (long)tagManifests.size());
        Assert.assertEquals((Object)"tagmanifest-md5.txt", (Object)((Manifest)tagManifests.get(0)).getFilepath());
        Assert.assertEquals((Object)"tagmanifest-md5.txt", (Object)bag.getTagManifest(Manifest.Algorithm.MD5).getFilepath());
        Assert.assertNull((Object)bag.getTagManifest(Manifest.Algorithm.SHA1));
        Assert.assertNotNull(bag.getChecksums("bagit.txt").get(Manifest.Algorithm.MD5));
    }

    protected void assertBagPayloadManifests(Bag bag) throws Exception {
        List payloadManifests = bag.getPayloadManifests();
        Assert.assertEquals((long)1L, (long)payloadManifests.size());
        Assert.assertEquals((Object)"manifest-md5.txt", (Object)((Manifest)payloadManifests.get(0)).getFilepath());
        Assert.assertEquals((Object)"manifest-md5.txt", (Object)bag.getPayloadManifest(Manifest.Algorithm.MD5).getFilepath());
        Assert.assertNull((Object)bag.getPayloadManifest(Manifest.Algorithm.SHA1));
        Assert.assertEquals((Object)"ad0234829205b9033196ba818f7a872b", bag.getChecksums("data/test2.txt").get(Manifest.Algorithm.MD5));
    }
}

