/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.impl.AddFilesToPayloadOperation;
import gov.loc.repository.bagit.transformer.impl.DefaultCompleter;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AddFilesToPayloadOperationTest {
    File destFile;
    static Integer counter = 0;
    AddFilesToPayloadOperation driver;
    BagFactory bagFactory;
    Bag.BagPartFactory bagPartFactory;

    @Before
    public void setup() throws Exception {
        this.bagFactory = new BagFactory();
        this.bagPartFactory = this.bagFactory.getBagPartFactory(this.getVersion());
    }

    public BagFactory.Version getVersion() {
        return BagFactory.Version.V0_96;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagByAddingPayloadFiles() throws Exception {
        File sourceBagDir = ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag", this.getVersion().toString().toLowerCase()));
        File srcAddFilesDir = new File(ResourceHelper.PROJECT_DIR + "/target/test-classes/srcFiles");
        Bag bag = this.bagFactory.createBag(sourceBagDir);
        try {
            bag.addFilesToPayload(Arrays.asList(srcAddFilesDir.listFiles()));
            DefaultCompleter completer = new DefaultCompleter(this.bagFactory);
            Bag bag2 = completer.complete(bag);
            try {
                Assert.assertTrue((boolean)bag2.verifyValid().isSuccess());
                Assert.assertEquals((long)7L, (long)bag2.getPayload().size());
                Assert.assertTrue((boolean)bag2.verifyValid().isSuccess());
                BagInfoTxt bagInfo = bag2.getBagInfoTxt();
                Assert.assertNotNull((Object)bagInfo);
                Assert.assertNotNull((Object)bagInfo.getBaggingDate());
                Assert.assertNotNull((Object)bagInfo.getBagSize());
                Assert.assertNotNull((Object)bagInfo.getPayloadOxum());
                Assert.assertEquals((long)1L, (long)bag2.getTagManifests().size());
            }
            finally {
                bag2.close();
            }
        }
        finally {
            bag.close();
        }
    }
}

