/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.ManifestReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractManifestReaderImplTest {
    BagFactory bagFactory = new BagFactory();
    Bag.BagPartFactory factory;

    public abstract BagFactory.Version getVersion();

    @Before
    public void setup() {
        this.factory = this.bagFactory.getBagPartFactory(this.getVersion());
    }

    public boolean canReadLine(String line) throws Exception {
        return this.canReadLine(line, "8ad8757baa8564dc136c1e07507f4a98", "data/test1.txt");
    }

    public boolean canReadLine(String line, String expectedFixityValue, String expectedFilename, boolean treatBackslashAsPathSeparator) throws Exception {
        ManifestReader reader = this.factory.createManifestReader((InputStream)new ByteArrayInputStream(line.getBytes("utf-8")), "utf-8", treatBackslashAsPathSeparator);
        boolean canRead = false;
        if (reader.hasNext()) {
            canRead = true;
            ManifestReader.FilenameFixity ff = (ManifestReader.FilenameFixity)reader.next();
            Assert.assertEquals((Object)expectedFixityValue, (Object)ff.getFixityValue());
            Assert.assertEquals((Object)expectedFilename, (Object)ff.getFilename());
        }
        reader.close();
        return canRead;
    }

    public boolean canReadLine(String line, String expectedFixityValue, String expectedFilename) throws Exception {
        ManifestReader reader = this.factory.createManifestReader((InputStream)new ByteArrayInputStream(line.getBytes("utf-8")), "utf-8");
        boolean canRead = false;
        if (reader.hasNext()) {
            canRead = true;
            ManifestReader.FilenameFixity ff = (ManifestReader.FilenameFixity)reader.next();
            Assert.assertEquals((Object)expectedFixityValue, (Object)ff.getFixityValue());
            Assert.assertEquals((Object)expectedFilename, (Object)ff.getFilename());
        }
        reader.close();
        return canRead;
    }

    @Test
    public void testSingleSpaceWithUnixSep() throws Exception {
        Assert.assertEquals((Object)this.canReadLine("8ad8757baa8564dc136c1e07507f4a98 data/test1.txt\n"), (Object)this.canReadSingleSpaceWithUnixSep());
    }

    public boolean canReadSingleSpaceWithUnixSep() {
        return false;
    }

    @Test
    public void testSingleSpaceWithWindowsSep() throws Exception {
        Assert.assertEquals((Object)this.canReadSingleSpaceWithWindowsSep(), (Object)this.canReadLine("8ad8757baa8564dc136c1e07507f4a98 data\\test1.txt\n"));
    }

    public boolean canReadSingleSpaceWithWindowsSep() {
        return false;
    }

    @Test
    public void testTabWithUnixSep() throws Exception {
        Assert.assertEquals((Object)this.canReadLine("8ad8757baa8564dc136c1e07507f4a98\tdata/test1.txt\n"), (Object)this.canReadTabWithUnixSep());
    }

    public boolean canReadTabWithUnixSep() {
        return false;
    }

    @Test
    public void testTabWithUnixSepWithSpaceInFilename() throws Exception {
        ManifestReader reader = this.factory.createManifestReader((InputStream)new ByteArrayInputStream("8ad8757baa8564dc136c1e07507f4a98\tdata/test 1.txt\n".getBytes("utf-8")), "utf-8");
        if (reader.hasNext()) {
            Assert.assertTrue((boolean)this.canReadTabWithUnixSepWithSpaceInFilename());
            ManifestReader.FilenameFixity ff = (ManifestReader.FilenameFixity)reader.next();
            Assert.assertEquals((Object)"8ad8757baa8564dc136c1e07507f4a98", (Object)ff.getFixityValue());
            Assert.assertEquals((Object)"data/test 1.txt", (Object)ff.getFilename());
        } else {
            Assert.assertFalse((boolean)this.canReadTabWithUnixSepWithSpaceInFilename());
        }
    }

    public boolean canReadTabWithUnixSepWithSpaceInFilename() {
        return false;
    }

    @Test
    public void testDoubleSpaceWithUnixSep() throws Exception {
        Assert.assertEquals((Object)this.canReadLine("8ad8757baa8564dc136c1e07507f4a98  data/test1.txt\n"), (Object)this.canReadDoubleSpaceWithUnixSep());
    }

    public boolean canReadDoubleSpaceWithUnixSep() {
        return false;
    }

    @Test
    public void testUnderscoreWithUnixSep() throws Exception {
        Assert.assertEquals((Object)this.canReadLine("8ad8757baa8564dc136c1e07507f4a98_data/test1.txt\n"), (Object)this.canReadUnderscoreWithUnixSep());
    }

    public boolean canReadUnderscoreWithUnixSep() {
        return false;
    }

    @Test
    public void testSpaceAstericksWithUnixSep() throws Exception {
        Assert.assertEquals((Object)this.canReadLine("8ad8757baa8564dc136c1e07507f4a98 *data/test1.txt\n"), (Object)this.canReadSpaceAstericksWithUnixSep());
    }

    public boolean canReadSpaceAstericksWithUnixSep() {
        return false;
    }
}

