/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.impl.StringBagFile;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractBagInfoTxtImplTest {
    protected BagFactory bagFactory = new BagFactory();
    protected Bag.BagPartFactory factory;
    protected Bag.BagConstants constants;

    public abstract BagFactory.Version getVersion();

    @Before
    public void setup() {
        this.factory = this.bagFactory.getBagPartFactory(this.getVersion());
        this.constants = this.bagFactory.getBagConstants(this.getVersion());
    }

    @Test
    public void testBagInfoTxt() {
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), this.getTestBagInfoTxtBagInfoTxtString()));
        Assert.assertEquals((Object)"Spengler University", (Object)bagInfo.getSourceOrganization());
        Assert.assertEquals((Object)"1400 Elm St., Cupertino, California, 95014", (Object)bagInfo.getOrganizationAddress());
        Assert.assertEquals((Object)"Edna Janssen", (Object)bagInfo.getContactName());
        Assert.assertEquals((Object)"+1 408-555-1212", (Object)bagInfo.getContactPhone());
        Assert.assertEquals((Object)"ej@spengler.edu", (Object)bagInfo.getContactEmail());
        Assert.assertEquals((Object)"Uncompressed greyscale TIFF images from the Yoshimuri papers collection.", (Object)bagInfo.getExternalDescription());
        Assert.assertEquals((Object)"2008-01-15", (Object)bagInfo.getBaggingDate());
        Assert.assertEquals((Object)"spengler_yoshimuri_001", (Object)bagInfo.getExternalIdentifier());
        Assert.assertEquals((Object)"260 GB", (Object)bagInfo.getBagSize());
        Assert.assertEquals((Object)"spengler_yoshimuri", (Object)bagInfo.getBagGroupIdentifier());
        Assert.assertEquals((Object)"1 of 15", (Object)bagInfo.getBagCount());
        Assert.assertEquals((Object)"/storage/images/yoshimuri", (Object)bagInfo.getInternalSenderIdentifier());
        Assert.assertEquals((Object)"Uncompressed greyscale TIFFs created from microfilm.", (Object)bagInfo.getInternalSenderDescription());
        this.addlTestBagInfoTxt(bagInfo);
    }

    public abstract String getTestBagInfoTxtBagInfoTxtString();

    public void addlTestBagInfoTxt(BagInfoTxt bagInfo) {
    }

    @Test
    public void testBagInfoTxtNullFields() throws Exception {
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), this.getTestBagInfoTxtBagInfoTxtString()));
        bagInfo.put((Object)"Foo", null);
        String bagInfoString = new String(IOUtils.toByteArray((InputStream)bagInfo.newInputStream()));
        Assert.assertFalse((boolean)bagInfoString.contains("null"));
    }

    @Test
    public void testCaseInsensitive() {
        String bagInfoTxtStr = "SOURCE-ORGANIZATION: Spengler University\norganization-address: 1400 Elm St., Cupertino, California, 95014\nCoNTact-NaMe: Edna Janssen\n";
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), bagInfoTxtStr));
        Assert.assertEquals((Object)"Spengler University", (Object)bagInfo.getSourceOrganization());
        Assert.assertEquals((Object)"1400 Elm St., Cupertino, California, 95014", (Object)bagInfo.getOrganizationAddress());
        Assert.assertEquals((Object)"Edna Janssen", (Object)bagInfo.getContactName());
    }

    @Test
    public void testColons() {
        String bagInfoTxtStr1 = "External-Description: This collection consists of six\n   large-scale web crawls run against U.S. city web sites from May 2005\n   to October 2007 as part of the Stanford WebBase project. Format:  ARC files\n   generated from WebBase content.\nExternal-Identifier: ark:/13030/sw1154dn7r\n";
        String bagInfoTxtStr2 = "External-Description: This collection consists of six large-scale web crawls run against U.S. city web sites from May 2005 to October 2007 as part of the Stanford WebBase project. Format:  ARC files generated from WebBase content.\nExternal-Identifier: ark:/13030/sw1154dn7r\n";
        String bagInfoTxtStr3 = "External-Description: This collection consists of six\n   large-scale web crawls run against U.S. city web sites from May 2005\n   to October 2007 as part of the Stanford WebBase project.\n   Format:  ARC files\n   generated from WebBase content.\nExternal-Identifier: ark:/13030/sw1154dn7r\n";
        String externalDescription = "This collection consists of six large-scale web crawls run against U.S. city web sites from May 2005 to October 2007 as part of the Stanford WebBase project. Format:  ARC files generated from WebBase content.";
        String externalIdentifier = "ark:/13030/sw1154dn7r";
        BagInfoTxt bagInfo1 = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), bagInfoTxtStr1));
        Assert.assertEquals((Object)"This collection consists of six large-scale web crawls run against U.S. city web sites from May 2005 to October 2007 as part of the Stanford WebBase project. Format:  ARC files generated from WebBase content.", (Object)bagInfo1.getExternalDescription());
        Assert.assertEquals((Object)"ark:/13030/sw1154dn7r", (Object)bagInfo1.getExternalIdentifier());
        BagInfoTxt bagInfo2 = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), bagInfoTxtStr2));
        Assert.assertEquals((Object)"This collection consists of six large-scale web crawls run against U.S. city web sites from May 2005 to October 2007 as part of the Stanford WebBase project. Format:  ARC files generated from WebBase content.", (Object)bagInfo2.getExternalDescription());
        Assert.assertEquals((Object)"ark:/13030/sw1154dn7r", (Object)bagInfo2.getExternalIdentifier());
        BagInfoTxt bagInfo3 = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), bagInfoTxtStr3));
        Assert.assertEquals((Object)"This collection consists of six large-scale web crawls run against U.S. city web sites from May 2005 to October 2007 as part of the Stanford WebBase project. Format:  ARC files generated from WebBase content.", (Object)bagInfo3.getExternalDescription());
        Assert.assertEquals((Object)"ark:/13030/sw1154dn7r", (Object)bagInfo3.getExternalIdentifier());
    }

    @Test
    public void testBaggingDate() throws Exception {
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt();
        bagInfo.setBaggingDate("2008-01-15");
        Assert.assertEquals((Object)"2008-01-15", (Object)bagInfo.getBaggingDate());
        Calendar baggingDate = Calendar.getInstance();
        baggingDate.setTime(bagInfo.getBaggingDateObj());
        Assert.assertEquals((long)2008L, (long)baggingDate.get(1));
        Assert.assertEquals((long)0L, (long)baggingDate.get(2));
        Assert.assertEquals((long)15L, (long)baggingDate.get(5));
        baggingDate.set(5, 16);
        bagInfo.setBaggingDate(baggingDate.getTime());
        Assert.assertEquals((Object)"2008-01-16", (Object)bagInfo.getBaggingDate());
        bagInfo.setBaggingDate(2008, 1, 17);
        Assert.assertEquals((Object)"2008-01-17", (Object)bagInfo.getBaggingDate());
    }

    @Test
    public void testBagCount() throws Exception {
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt();
        bagInfo.setBagCount("1 of 15");
        Assert.assertEquals((Object)"1 of 15", (Object)bagInfo.getBagCount());
        Assert.assertEquals((Object)1, (Object)bagInfo.getBagInGroup());
        Assert.assertEquals((Object)15, (Object)bagInfo.getTotalBagsInGroup());
        bagInfo.setBagCount(2, 16);
        Assert.assertEquals((Object)"2 of 16", (Object)bagInfo.getBagCount());
        bagInfo.setBagCount(3, -1);
        Assert.assertEquals((Object)"3 of ?", (Object)bagInfo.getBagCount());
    }

    @Test(expected=ParseException.class)
    public void testBadBagCount() throws Exception {
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt();
        bagInfo.setBagCount(" of 15");
        bagInfo.getBagInGroup();
    }

    @Test(expected=ParseException.class)
    public void testBadBagCount2() throws Exception {
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt();
        bagInfo.setBagCount("1 of ");
        bagInfo.getTotalBagsInGroup();
    }

    @Test(expected=ParseException.class)
    public void testBadBagCount3() throws Exception {
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt();
        bagInfo.setBagCount("1 x 15");
        bagInfo.getBagInGroup();
    }

    @Test(expected=RuntimeException.class)
    public void testImproperlyFormatted() {
        String bagInfoTxtStr = "Source-Organization: Spengler University\nOrganization-Address: 1400 Elm St., Cupertino, California, 95014\nExternal-Description: This collection consists of six\nlarge-scale web crawls run against U.S. city web sites from May 2005\nto October 2007 as part of the Stanford WebBase project. Format:  ARC files\ngenerated from WebBase content.\n";
        this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), bagInfoTxtStr));
    }

    @Test
    public void testGetStandardFields() throws Exception {
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), this.getTestBagInfoTxtBagInfoTxtString()));
        bagInfo.put((Object)"foo", (Object)"bar");
        bagInfo.remove((Object)"Bag-Size");
        bagInfo.put((Object)"bag-size", (Object)"1 gb");
        List fields = bagInfo.getStandardFields();
        Assert.assertTrue((boolean)fields.contains("Contact-Email"));
        Assert.assertTrue((boolean)fields.contains("Contact-Name"));
        Assert.assertTrue((boolean)fields.contains("Contact-Phone"));
        Assert.assertTrue((boolean)fields.contains("bag-size"));
        Assert.assertFalse((boolean)fields.contains("foo"));
    }

    @Test
    public void testGetNonstandardFields() throws Exception {
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), this.getTestBagInfoTxtBagInfoTxtString()));
        bagInfo.put((Object)"foo", (Object)"bar");
        bagInfo.remove((Object)"Bag-Size");
        bagInfo.put((Object)"bag-size", (Object)"1 gb");
        List fields = bagInfo.getNonstandardFields();
        Assert.assertFalse((boolean)fields.contains("Contact-Email"));
        Assert.assertTrue((boolean)fields.contains("foo"));
        Assert.assertFalse((boolean)fields.contains("bag-size"));
        Assert.assertEquals((long)1L, (long)fields.size());
    }

    @Test
    public void testDupeMapFunctions() {
        String bagInfoTxtStr = "Source-Organization: Spengler University\nSource-Organization: Mangler University\n";
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), bagInfoTxtStr));
        Assert.assertEquals((Object)"Spengler University", (Object)bagInfo.getSourceOrganization());
        bagInfo.put((Object)"Source-Organization", (Object)"Fangler University");
        Assert.assertEquals((Object)"Fangler University", (Object)bagInfo.getSourceOrganization());
        bagInfo.remove((Object)"Source-Organization");
        Assert.assertTrue((boolean)bagInfo.containsKey((Object)"Source-Organization"));
        Assert.assertEquals((Object)"Mangler University", (Object)bagInfo.getSourceOrganization());
    }

    @Test
    public void testDupeListFunctions() {
        String bagInfoTxtStr = "Source-Organization: Spengler University\nSource-Organization: Mangler University\n";
        BagInfoTxt bagInfo = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), bagInfoTxtStr));
        List values = bagInfo.getList("Source-Organization");
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)"Spengler University", values.get(0));
        Assert.assertEquals((Object)"Mangler University", values.get(1));
        values = bagInfo.getSourceOrganizationList();
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)"Spengler University", values.get(0));
        Assert.assertEquals((Object)"Mangler University", values.get(1));
        bagInfo.putList("Source-Organization", "Fangler University");
        values = bagInfo.getList("Source-Organization");
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertEquals((Object)"Fangler University", values.get(2));
        bagInfo.removeList("Source-Organization", "Mangler University");
        values = bagInfo.getList("Source-Organization");
        Assert.assertEquals((long)2L, (long)values.size());
        bagInfo.addSourceOrganization("Wangler University");
        values = bagInfo.getList("Source-Organization");
        Assert.assertEquals((long)3L, (long)values.size());
        bagInfo.removeAllList("Source-Organization");
        values = bagInfo.getList("Source-Organization");
        Assert.assertEquals((long)0L, (long)values.size());
    }

    @Test
    public void testNewLines() {
        String bagInfoTxtStr1 = "Source-Organization: Spengler University\nExternal-Description: This collection consists of six\n   large-scale web crawls run against U.S. city web sites from May 2005\n   to October 2007 as part of the Stanford WebBase project.\n\n   Format:  ARC files\n   generated from WebBase content.\n";
        BagInfoTxt bagInfo1 = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), bagInfoTxtStr1));
        Assert.assertEquals((Object)"Spengler University", (Object)bagInfo1.getSourceOrganization());
        Assert.assertEquals((Object)"This collection consists of six large-scale web crawls run against U.S. city web sites from May 2005 to October 2007 as part of the Stanford WebBase project.\nFormat:  ARC files generated from WebBase content.", (Object)bagInfo1.getExternalDescription());
        String bagInfoTxtStr2 = "Source-Organization: Spengler University\nExternal-Description: This collection consists of six\n   large-scale web crawls run against U.S. city web sites from May 2005\n   to October 2007 as part of the Stanford WebBase project.\n   \n   Format:  ARC files\n   generated from WebBase content.\n";
        BagInfoTxt bagInfo2 = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), bagInfoTxtStr2));
        Assert.assertEquals((Object)"Spengler University", (Object)bagInfo2.getSourceOrganization());
        Assert.assertEquals((Object)"This collection consists of six large-scale web crawls run against U.S. city web sites from May 2005 to October 2007 as part of the Stanford WebBase project.\nFormat:  ARC files generated from WebBase content.", (Object)bagInfo2.getExternalDescription());
        String bagInfoTxtStr3 = "Source-Organization: Spengler University\nExternal-Description: This collection consists of six\n   large-scale web crawls run against U.S. city web sites from May 2005\n   to October 2007 as part of the Stanford WebBase project.\n   \n   Format:  ARC files\n   generated from WebBase content.\nContact-Name: Edna Janssen";
        BagInfoTxt bagInfo3 = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), bagInfoTxtStr3));
        Assert.assertEquals((Object)"Spengler University", (Object)bagInfo3.getSourceOrganization());
        Assert.assertEquals((Object)"This collection consists of six large-scale web crawls run against U.S. city web sites from May 2005 to October 2007 as part of the Stanford WebBase project.\nFormat:  ARC files generated from WebBase content.", (Object)bagInfo3.getExternalDescription());
        Assert.assertEquals((Object)"Edna Janssen", (Object)bagInfo3.getContactName());
        String bagInfoTxtStr4 = "Source-Organization: Spengler University\n\nContact-Name: Edna Janssen";
        BagInfoTxt bagInfo4 = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), bagInfoTxtStr4));
        Assert.assertEquals((Object)"Spengler University", (Object)bagInfo4.getSourceOrganization());
        Assert.assertEquals((Object)"Edna Janssen", (Object)bagInfo4.getContactName());
        String bagInfoTxtStr5 = "Source-Organization: Spengler University\n   \nContact-Name: Edna Janssen";
        BagInfoTxt bagInfo5 = this.factory.createBagInfoTxt((BagFile)new StringBagFile(this.constants.getBagInfoTxt(), bagInfoTxtStr5));
        Assert.assertEquals((Object)"Spengler University", (Object)bagInfo5.getSourceOrganization());
        Assert.assertEquals((Object)"Edna Janssen", (Object)bagInfo5.getContactName());
    }
}

