/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.BagInfoTxtWriter;
import gov.loc.repository.bagit.Cancellable;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.ManifestHelper;
import gov.loc.repository.bagit.ManifestWriter;
import gov.loc.repository.bagit.bag.CancelTriggeringBagDecorator;
import gov.loc.repository.bagit.impl.BaseBagImplTest;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.utilities.SimpleResultHelper;
import gov.loc.repository.bagit.verify.CompleteVerifier;
import gov.loc.repository.bagit.verify.FailModeSupporting;
import gov.loc.repository.bagit.verify.ManifestChecksumVerifier;
import gov.loc.repository.bagit.verify.impl.CompleteVerifierImpl;
import gov.loc.repository.bagit.verify.impl.ParallelManifestChecksumVerifier;
import gov.loc.repository.bagit.verify.impl.ValidVerifierImpl;
import gov.loc.repository.bagit.writer.Writer;
import gov.loc.repository.bagit.writer.impl.FileSystemWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractBagImplTest
extends BaseBagImplTest {
    @Test
    public void testFileSystemBagByPayloadManifests() throws Exception {
        this.testBag(this.getBagByPayloadManifests(Bag.Format.FILESYSTEM));
    }

    @Test
    public void testFileSystemBagByPayloadFiles() throws Exception {
        this.testBag(this.getBagByPayloadFiles(Bag.Format.FILESYSTEM));
    }

    @Test
    public void testZipBagByPayloadManifests() throws Exception {
        this.testBag(this.getBagByPayloadManifests(Bag.Format.ZIP));
    }

    @Test
    public void testZipBagByPayloadFiles() throws Exception {
        this.testBag(this.getBagByPayloadFiles(Bag.Format.ZIP));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithTwoEqualManifests() throws Exception {
        File testBagDir = this.createTestBag();
        File sha1ManifestFile = new File(testBagDir, ManifestHelper.getPayloadManifestFilename((Manifest.Algorithm)Manifest.Algorithm.SHA1, (Bag.BagConstants)this.constants));
        ManifestWriter writer = this.factory.createManifestWriter((OutputStream)new FileOutputStream(sha1ManifestFile));
        writer.write("data/dir1/test3.txt", "3ebfa301dc59196f18593c45e519287a23297589");
        writer.write("data/dir2/dir3/test5.txt", "911ddc3b8f9a13b5499b6bc4638a2b4f3f68bf23");
        writer.write("data/dir2/test4.txt", "1ff2b3704aede04eecb51e50ca698efd50a1379b");
        writer.write("data/test1.txt", "b444ac06613fc8d63795be9ad0beaf55011936ac");
        writer.write("data/test2.txt", "109f4b3c50d7b0df729d299bc6f8e9ef9066971f");
        writer.close();
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            Assert.assertEquals((long)2L, (long)bag.getPayloadManifests().size());
            Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithTwoUnequalManifests() throws Exception {
        File testBagDir = this.createTestBag();
        File sha1ManifestFile = new File(testBagDir, ManifestHelper.getPayloadManifestFilename((Manifest.Algorithm)Manifest.Algorithm.SHA1, (Bag.BagConstants)this.constants));
        ManifestWriter sha1Writer = this.factory.createManifestWriter((OutputStream)new FileOutputStream(sha1ManifestFile));
        sha1Writer.write("data/dir1/test3.txt", "3ebfa301dc59196f18593c45e519287a23297589");
        sha1Writer.write("data/dir2/dir3/test5.txt", "911ddc3b8f9a13b5499b6bc4638a2b4f3f68bf23");
        sha1Writer.write("data/dir2/test4.txt", "1ff2b3704aede04eecb51e50ca698efd50a1379b");
        sha1Writer.close();
        File md5ManifestFile = new File(testBagDir, ManifestHelper.getPayloadManifestFilename((Manifest.Algorithm)Manifest.Algorithm.MD5, (Bag.BagConstants)this.constants));
        ManifestWriter md5Writer = this.factory.createManifestWriter((OutputStream)new FileOutputStream(md5ManifestFile));
        md5Writer.write("data/dir1/test3.txt", "8ad8757baa8564dc136c1e07507f4a98");
        md5Writer.write("data/test1.txt", "5a105e8b9d40e1329780d62ea2265d8a");
        md5Writer.write("data/test2.txt", "ad0234829205b9033196ba818f7a872b");
        md5Writer.close();
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            Assert.assertEquals((long)2L, (long)bag.getPayloadManifests().size());
            Assert.assertTrue((boolean)bag.verifyComplete().isSuccess());
            Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
            Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
            Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithNoBagItTxt() throws Exception {
        File testBagDir = this.createTestBag();
        File bagItTxtFile = new File(testBagDir, this.constants.getBagItTxt());
        Assert.assertTrue((boolean)bagItTxtFile.exists());
        FileUtils.forceDelete((File)bagItTxtFile);
        Assert.assertFalse((boolean)bagItTxtFile.exists());
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            Assert.assertNull((Object)bag.getBagItTxt());
            Assert.assertFalse((boolean)bag.verifyComplete().isSuccess());
            Assert.assertFalse((boolean)bag.verifyValid().isSuccess());
            CompleteVerifierImpl completeVerifier = new CompleteVerifierImpl();
            completeVerifier.setMissingBagItTolerant(true);
            Assert.assertTrue((boolean)completeVerifier.verify(bag).isSuccess());
            Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
            Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithChangedPayloadFile() throws Exception {
        File testBagDir = this.createTestBag();
        File test1File = new File(testBagDir, "data/test1.txt");
        Assert.assertTrue((boolean)test1File.exists());
        FileWriter writer = new FileWriter(test1File);
        writer.write("xtest1");
        writer.close();
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            Assert.assertTrue((boolean)bag.verifyComplete().isSuccess());
            SimpleResult result = bag.verifyValid();
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertTrue((boolean)SimpleResultHelper.getInvalidPayloadFiles((SimpleResult)result).contains("data/test1.txt"));
            Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
            Assert.assertFalse((boolean)bag.verifyPayloadManifests().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithChangedTagFile() throws Exception {
        File testBagDir = this.createTestBag(false);
        File bagInfoTxtFile = new File(testBagDir, this.constants.getBagInfoTxt());
        BagInfoTxtWriter writer = this.factory.createBagInfoTxtWriter((OutputStream)new FileOutputStream(bagInfoTxtFile), this.constants.getBagEncoding());
        writer.write("foo", "bar");
        writer.close();
        Assert.assertTrue((boolean)bagInfoTxtFile.exists());
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            Assert.assertTrue((boolean)bag.verifyComplete().isSuccess());
            SimpleResult result = bag.verifyValid();
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertTrue((boolean)SimpleResultHelper.getInvalidTagFiles((SimpleResult)result).contains(this.constants.getBagInfoTxt()));
            Assert.assertFalse((boolean)bag.verifyTagManifests().isSuccess());
            Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithMissingPayloadFile() throws Exception {
        File testBagDir = this.createTestBag();
        File test1File = new File(testBagDir, "data/test1.txt");
        Assert.assertTrue((boolean)test1File.exists());
        FileUtils.forceDelete((File)test1File);
        Assert.assertFalse((boolean)test1File.exists());
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            SimpleResult result = bag.verifyComplete();
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertTrue((boolean)SimpleResultHelper.getMissingPayloadFiles((SimpleResult)result).contains("data/test1.txt"));
            Assert.assertFalse((boolean)bag.verifyValid().isSuccess());
            Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
            Assert.assertFalse((boolean)bag.verifyPayloadManifests().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithMissingTagFile() throws Exception {
        File testBagDir = this.createTestBag(false);
        File bagInfoTxtFile = new File(testBagDir, this.constants.getBagInfoTxt());
        Assert.assertTrue((boolean)bagInfoTxtFile.exists());
        FileUtils.forceDelete((File)bagInfoTxtFile);
        Assert.assertFalse((boolean)bagInfoTxtFile.exists());
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            SimpleResult result = bag.verifyComplete();
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertTrue((boolean)SimpleResultHelper.getMissingTagFiles((SimpleResult)result).contains(this.constants.getBagInfoTxt()));
            Assert.assertFalse((boolean)bag.verifyValid().isSuccess());
            Assert.assertFalse((boolean)bag.verifyTagManifests().isSuccess());
            Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithExtraPayloadFile() throws Exception {
        File testBagDir = this.createTestBag();
        File extraFile = new File(testBagDir, "data/extra.txt");
        FileWriter writer = new FileWriter(extraFile);
        writer.write("extra");
        writer.close();
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            SimpleResult result = bag.verifyComplete();
            Assert.assertFalse((boolean)result.isSuccess());
            Assert.assertTrue((boolean)SimpleResultHelper.getExtraPayloadFiles((SimpleResult)result).contains("data/extra.txt"));
            Assert.assertFalse((boolean)bag.verifyValid().isSuccess());
            Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
            Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompleteBagWithExtraPayloadFile() throws Exception {
        File testBagDir = this.createTestBag();
        File extraFile = new File(testBagDir, "data/extra.txt");
        FileWriter writer = new FileWriter(extraFile);
        writer.write("extra");
        writer.close();
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_FILES);
        try {
            bag.makeComplete();
            Assert.assertTrue((boolean)bag.verifyComplete().isSuccess());
            Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
            Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
            Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithExtraTagFile() throws Exception {
        File testBagDir = this.createTestBag(false);
        File extraFile = new File(testBagDir, "extra.txt");
        FileWriter writer = new FileWriter(extraFile);
        writer.write("extra");
        writer.close();
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            Assert.assertTrue((boolean)bag.verifyComplete().isSuccess());
            Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
            Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
            Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithNoPayloadManifests() throws Exception {
        File testBagDir = this.createTestBag();
        File manifestFile = new File(testBagDir, ManifestHelper.getPayloadManifestFilename((Manifest.Algorithm)Manifest.Algorithm.MD5, (Bag.BagConstants)this.constants));
        Assert.assertTrue((boolean)manifestFile.exists());
        FileUtils.forceDelete((File)manifestFile);
        Assert.assertFalse((boolean)manifestFile.exists());
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            Assert.assertFalse((boolean)bag.verifyComplete().isSuccess());
            Assert.assertFalse((boolean)bag.verifyValid().isSuccess());
            Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
            Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithTagDirectory() throws Exception {
        File testBagDir = this.createTestBag();
        File extraDir = new File(testBagDir, "extra");
        Assert.assertFalse((boolean)extraDir.exists());
        FileUtils.forceMkdir((File)extraDir);
        Assert.assertTrue((boolean)extraDir.exists());
        File extraFile = new File(extraDir, "extra.txt");
        FileUtils.write((File)extraFile, (CharSequence)"extra");
        Assert.assertTrue((boolean)extraFile.exists());
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            this.performTestBagWithTagDirectory(bag);
        }
        finally {
            bag.close();
        }
    }

    public abstract void performTestBagWithTagDirectory(Bag var1);

    public void performTestBagWithTagDirectoryPrev97(Bag bag) {
        Assert.assertFalse((boolean)bag.verifyComplete().isSuccess());
        Assert.assertFalse((boolean)bag.verifyValid().isSuccess());
        Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
        Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
        CompleteVerifierImpl verifier = new CompleteVerifierImpl();
        verifier.setAdditionalDirectoriesInBagDirTolerant(true);
        Assert.assertTrue((boolean)verifier.verify(bag).isSuccess());
    }

    public void performTestBagWithTagDirectoryPostv97(Bag bag) {
        Assert.assertTrue((boolean)bag.verifyComplete().isSuccess());
        Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
        Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithIgnoredTagDirectory() throws Exception {
        File testBagDir = this.createTestBag();
        File extraDir = new File(testBagDir, "extra");
        Assert.assertFalse((boolean)extraDir.exists());
        FileUtils.forceMkdir((File)extraDir);
        Assert.assertTrue((boolean)extraDir.exists());
        File extraFile = new File(extraDir, "extra.txt");
        FileUtils.write((File)extraFile, (CharSequence)"extra");
        Assert.assertTrue((boolean)extraFile.exists());
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            this.performTestBagWithIgnoredTagDirectory(bag);
        }
        finally {
            bag.close();
        }
    }

    public abstract void performTestBagWithIgnoredTagDirectory(Bag var1);

    public void performTestBagWithIgnoredTagDirectoryPrev97(Bag bag) {
        Assert.assertFalse((boolean)bag.verifyComplete().isSuccess());
        Assert.assertFalse((boolean)bag.verifyValid().isSuccess());
        Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
        Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
        CompleteVerifierImpl verifier = new CompleteVerifierImpl();
        ArrayList<String> ignoreDirs = new ArrayList<String>();
        ignoreDirs.add("extra");
        verifier.setIgnoreAdditionalDirectories(ignoreDirs);
        Assert.assertTrue((boolean)verifier.verify(bag).isSuccess());
    }

    public void performTestBagWithIgnoredTagDirectoryPost97(Bag bag) {
        Assert.assertTrue((boolean)bag.verifyComplete().isSuccess());
        Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
        Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
        CompleteVerifierImpl verifier = new CompleteVerifierImpl();
        ArrayList<String> ignoreDirs = new ArrayList<String>();
        ignoreDirs.add("extra");
        verifier.setIgnoreAdditionalDirectories(ignoreDirs);
        Assert.assertTrue((boolean)verifier.verify(bag).isSuccess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithSpecialCharacters() throws Exception {
        File testBagDir = this.createTestBag();
        File specialCharFile = new File(testBagDir, "data/test\u00fc.txt");
        FileWriter writer = new FileWriter(specialCharFile);
        writer.write("test1");
        writer.close();
        File sha1ManifestFile = new File(testBagDir, ManifestHelper.getPayloadManifestFilename((Manifest.Algorithm)Manifest.Algorithm.SHA1, (Bag.BagConstants)this.constants));
        ManifestWriter manifestWriter = this.factory.createManifestWriter((OutputStream)new FileOutputStream(sha1ManifestFile));
        manifestWriter.write("data/test\u00fc.txt", "b444ac06613fc8d63795be9ad0beaf55011936ac");
        manifestWriter.close();
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            Assert.assertTrue((boolean)bag.verifyComplete().isSuccess());
            Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
            Assert.assertTrue((boolean)bag.verifyTagManifests().isSuccess());
            Assert.assertTrue((boolean)bag.verifyPayloadManifests().isSuccess());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrongVersion() throws Exception {
        BagFactory.Version otherVersion = null;
        for (BagFactory.Version checkVersion : BagFactory.Version.values()) {
            if (this.getVersion().equals((Object)checkVersion)) continue;
            otherVersion = checkVersion;
        }
        try {
            File bagDir = this.getBagDir(otherVersion, Bag.Format.FILESYSTEM);
            Bag bag = this.bagFactory.createBag(bagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
            try {
                Assert.assertFalse((boolean)bag.verifyComplete().isSuccess());
                Assert.assertFalse((boolean)bag.verifyValid().isSuccess());
            }
            finally {
                bag.close();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateBag() throws Exception {
        Bag bag = this.bagFactory.createBag(this.getVersion());
        try {
            bag.addFileToPayload(ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag/data/dir1", this.getVersion().toString().toLowerCase())));
            bag.addFileToPayload(ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag/data/dir2", this.getVersion().toString().toLowerCase())));
            bag.addFileToPayload(ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag/data/test1.txt", this.getVersion().toString().toLowerCase())));
            bag.addFileToPayload(ResourceHelper.getFile(MessageFormat.format("bags/{0}/bag/data/test2.txt", this.getVersion().toString().toLowerCase())));
            this.addlTestCreateBag(bag);
            BagInfoTxt bagInfo = bag.getBagPartFactory().createBagInfoTxt();
            bag.putBagFile((BagFile)bagInfo);
            String BAG_COUNT = "1 of 5";
            String BAG_SIZE = "10 gb";
            String BAGGING_DATE = "10.20.2008";
            bagInfo.setBagCount("1 of 5");
            bagInfo.setBagSize("10 gb");
            bagInfo.setBaggingDate("10.20.2008");
            Assert.assertEquals((long)5L, (long)bag.getPayload().size());
            Assert.assertNotNull((Object)bag.getBagFile("data/dir1/test3.txt"));
            Assert.assertNotNull((Object)bag.getBagFile("data/test1.txt"));
            Assert.assertNull((Object)bag.getBagFile("xdata/dir1/test3.txt"));
            Assert.assertNotNull((Object)bag.getBagInfoTxt());
            Assert.assertEquals((Object)"1 of 5", (Object)bag.getBagInfoTxt().getBagCount());
            Assert.assertEquals((Object)"10 gb", (Object)bagInfo.getBagSize());
            Assert.assertEquals((Object)"10.20.2008", (Object)bagInfo.getBaggingDate());
            this.performAddlTestCreateBag(bag);
        }
        finally {
            bag.close();
        }
    }

    public void addlTestCreateBag(Bag bag) throws Exception {
    }

    public void performAddlTestCreateBag(Bag bag) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompleterCancels() throws Exception {
        Bag bag = this.getBagByPayloadManifests(Bag.Format.FILESYSTEM);
        try {
            CompleteVerifierImpl completeVerifier = new CompleteVerifierImpl();
            Assert.assertNull((Object)completeVerifier.verify((Bag)new CancelTriggeringBagDecorator(bag, 10, (Cancellable)completeVerifier)));
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManifestVerifierCancels() throws Exception {
        Bag bag = this.getBagByPayloadManifests(Bag.Format.FILESYSTEM);
        try {
            ParallelManifestChecksumVerifier manifestVerifier = new ParallelManifestChecksumVerifier();
            Assert.assertNull((Object)manifestVerifier.verify(bag.getPayloadManifests(), (Bag)new CancelTriggeringBagDecorator(bag, 2, (Cancellable)manifestVerifier)));
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidVerifierCancels() throws Exception {
        Bag bag = this.getBagByPayloadManifests(Bag.Format.FILESYSTEM);
        try {
            ValidVerifierImpl validVerifier = new ValidVerifierImpl((CompleteVerifier)new CompleteVerifierImpl(), (ManifestChecksumVerifier)new ParallelManifestChecksumVerifier());
            Assert.assertNull((Object)validVerifier.verify((Bag)new CancelTriggeringBagDecorator(bag, 10, (Cancellable)validVerifier)));
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveDirectory() throws Exception {
        Bag bag = this.getBagByPayloadManifests(Bag.Format.FILESYSTEM);
        try {
            Assert.assertNotNull((Object)bag.getBagFile("data/test1.txt"));
            Assert.assertNotNull((Object)bag.getBagFile("data/dir2/test4.txt"));
            Assert.assertNotNull((Object)bag.getBagFile("data/dir2/dir3/test5.txt"));
            bag.removePayloadDirectory("data/dir2");
            Assert.assertNotNull((Object)bag.getBagFile("data/test1.txt"));
            Assert.assertNull((Object)bag.getBagFile("data/dir2/test4.txt"));
            Assert.assertNull((Object)bag.getBagFile("data/dir2/dir3/test5.txt"));
            bag.removePayloadDirectory("data/test1.txt");
            Assert.assertNotNull((Object)bag.getBagFile("data/test1.txt"));
            bag.removePayloadDirectory("data");
            Assert.assertNotNull((Object)bag.getBagFile("data/test1.txt"));
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBagWithDupeFieldsInBagInfoTxt() throws Exception {
        File testBagDir = this.createTestBag(true);
        File bagInfoTxtFile = new File(testBagDir, this.constants.getBagInfoTxt());
        BagInfoTxtWriter writer = this.factory.createBagInfoTxtWriter((OutputStream)new FileOutputStream(bagInfoTxtFile), this.constants.getBagEncoding());
        writer.write("Foo", "test1");
        writer.write("Foo", "test2");
        writer.close();
        Assert.assertTrue((boolean)bagInfoTxtFile.exists());
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        BagInfoTxt bagInfoTxt = null;
        try {
            bagInfoTxt = bag.getBagInfoTxt();
            Assert.assertEquals((long)2L, (long)bagInfoTxt.getList("Foo").size());
            ArrayList<String> values = new ArrayList<String>();
            values.add("test1");
            values.add("test2");
            bagInfoTxt.putList("Bar", values);
            bag.write((Writer)new FileSystemWriter(this.bagFactory), testBagDir);
        }
        finally {
            bag.close();
        }
        try {
            bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
            Assert.assertEquals((long)2L, (long)bagInfoTxt.getList("Foo").size());
            Assert.assertEquals((long)2L, (long)bagInfoTxt.getList("Bar").size());
        }
        finally {
            bag.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailModes() throws Exception {
        File testBagDir = this.createTestBag();
        File test1File = new File(testBagDir, "data/test1.txt");
        Assert.assertTrue((boolean)test1File.exists());
        FileUtils.write((File)test1File, (CharSequence)"xtest1");
        File extra1File = new File(testBagDir, "data/extra1.txt");
        Assert.assertFalse((boolean)extra1File.exists());
        FileUtils.write((File)extra1File, (CharSequence)"extra1");
        Assert.assertTrue((boolean)extra1File.exists());
        File test2File = new File(testBagDir, "data/test2.txt");
        Assert.assertTrue((boolean)test2File.exists());
        test2File.delete();
        Assert.assertFalse((boolean)test2File.exists());
        File test3File = new File(testBagDir, "data/dir1/test3.txt");
        Assert.assertTrue((boolean)test3File.exists());
        test3File.delete();
        Assert.assertFalse((boolean)test3File.exists());
        Bag bag = this.bagFactory.createBag(testBagDir, this.getVersion(), BagFactory.LoadOption.BY_MANIFESTS);
        try {
            System.out.println("FAILMODES");
            SimpleResult result = bag.verifyValid(FailModeSupporting.FailMode.FAIL_FAST);
            Assert.assertEquals((long)1L, (long)SimpleResultHelper.getMissingPayloadFiles((SimpleResult)result).size());
            result = bag.verifyValid(FailModeSupporting.FailMode.FAIL_STEP);
            Assert.assertEquals((long)2L, (long)SimpleResultHelper.getMissingPayloadFiles((SimpleResult)result).size());
            result = bag.verifyValid(FailModeSupporting.FailMode.FAIL_STAGE);
            Assert.assertEquals((long)2L, (long)SimpleResultHelper.getMissingPayloadFiles((SimpleResult)result).size());
            Assert.assertEquals((long)1L, (long)SimpleResultHelper.getExtraPayloadFiles((SimpleResult)result).size());
            result = bag.verifyValid(FailModeSupporting.FailMode.FAIL_SLOW);
            Assert.assertEquals((long)2L, (long)SimpleResultHelper.getMissingPayloadFiles((SimpleResult)result).size());
            Assert.assertEquals((long)1L, (long)SimpleResultHelper.getExtraPayloadFiles((SimpleResult)result).size());
            Assert.assertEquals((long)1L, (long)SimpleResultHelper.getInvalidPayloadFiles((SimpleResult)result).size());
        }
        finally {
            bag.close();
        }
    }
}

