/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.filesystem.impl;

import gov.loc.repository.bagit.filesystem.DirNode;
import gov.loc.repository.bagit.filesystem.FileNode;
import gov.loc.repository.bagit.filesystem.FileSystem;
import gov.loc.repository.bagit.filesystem.FileSystemNode;
import gov.loc.repository.bagit.filesystem.FileSystemNodeFilter;
import gov.loc.repository.bagit.filesystem.filter.FalseFileSystemNodeFilter;
import gov.loc.repository.bagit.filesystem.filter.FileNodeFileSystemNodeFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractFileSystemTest {
    abstract FileSystem getFileSystem();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileSystem() {
        FileSystem fs = this.getFileSystem();
        try {
            DirNode root = fs.getRoot();
            Assert.assertEquals((Object)"", (Object)root.getFilepath());
            Assert.assertNull((Object)root.getName());
            Assert.assertEquals((long)5L, (long)root.listChildren().size());
            Assert.assertEquals((long)4L, (long)root.listChildren((FileSystemNodeFilter)new FileNodeFileSystemNodeFilter()).size());
            Assert.assertEquals((long)9L, (long)root.listDescendants((FileSystemNodeFilter)new FileNodeFileSystemNodeFilter(), null).size());
            Assert.assertEquals((long)4L, (long)root.listDescendants((FileSystemNodeFilter)new FileNodeFileSystemNodeFilter(), (FileSystemNodeFilter)new FalseFileSystemNodeFilter()).size());
            Assert.assertEquals((long)14L, (long)root.listDescendants().size());
            DirNode dataDir = root.childDir("data");
            Assert.assertNotNull((Object)dataDir);
            Assert.assertEquals((long)5L, (long)dataDir.listChildren().size());
            Assert.assertEquals((Object)"data", (Object)dataDir.getName());
            Assert.assertEquals((Object)"data", (Object)dataDir.getFilepath());
            Assert.assertNull((Object)root.childDir("not a dir"));
            FileNode bagItTxtFile = root.childFile("bagit.txt");
            Assert.assertNotNull((Object)bagItTxtFile);
            Assert.assertEquals((Object)"bagit.txt", (Object)bagItTxtFile.getName());
            Assert.assertEquals((Object)"bagit.txt", (Object)bagItTxtFile.getFilepath());
            Assert.assertNull((Object)root.childFile("not a file"));
            DirNode dir1Dir = dataDir.childDir("dir1");
            Assert.assertNotNull((Object)dir1Dir);
            Assert.assertEquals((Object)"dir1", (Object)dir1Dir.getName());
            Assert.assertEquals((Object)"data/dir1", (Object)dir1Dir.getFilepath());
            Assert.assertEquals((long)1L, (long)dir1Dir.listChildren().size());
            FileNode test1TxtFile = dataDir.childFile("test1.txt");
            Assert.assertNotNull((Object)test1TxtFile);
            Assert.assertEquals((Object)"test1.txt", (Object)test1TxtFile.getName());
            Assert.assertEquals((Object)"data/test1.txt", (Object)test1TxtFile.getFilepath());
            DirNode dir4Dir = dataDir.childDir("dir4");
            Assert.assertNotNull((Object)dir4Dir);
            Assert.assertTrue((boolean)dir4Dir.listChildren().isEmpty());
        }
        finally {
            fs.closeQuietly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultithreading() throws Exception {
        FileSystem fs = this.getFileSystem();
        try {
            TestUncaughtExceptionHandler exHandler = new TestUncaughtExceptionHandler();
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (int i = 0; i < 10; ++i) {
                Thread t = new Thread(new TestRunnable(fs, 5));
                threads.add(t);
                t.setUncaughtExceptionHandler(exHandler);
                t.start();
            }
            for (Thread t : threads) {
                t.join();
            }
            Assert.assertFalse((boolean)exHandler.exceptionCaught);
        }
        finally {
            fs.closeQuietly();
        }
    }

    private class TestRunnable
    implements Runnable {
        private FileSystem fileSystem;
        private int iterations;

        public TestRunnable(FileSystem fileSystem, int iterations) {
            this.fileSystem = fileSystem;
            this.iterations = iterations;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.iterations; ++i) {
                Collection nodes = this.fileSystem.getRoot().listDescendants((FileSystemNodeFilter)new FileNodeFileSystemNodeFilter(), null);
                for (FileSystemNode node : nodes) {
                    FileNode fileNode = (FileNode)node;
                    InputStream in = fileNode.newInputStream();
                    try {
                        IOUtils.toByteArray((InputStream)in);
                    }
                    catch (IOException e) {
                        throw new RuntimeException();
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
            }
        }
    }

    private class TestUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        public boolean exceptionCaught = false;

        private TestUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.exceptionCaught = true;
        }
    }
}

