/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.driver;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.driver.CommandLineBagDriver;
import gov.loc.repository.bagit.utilities.ResourceHelper;
import java.io.File;
import java.text.MessageFormat;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommandLineBagDriverTest {
    File destFile;
    static Integer counter = 0;
    CommandLineBagDriver driver;
    BagFactory bagFactory = new BagFactory();

    @Before
    public void setup() throws Exception {
        Integer n = counter;
        Integer n2 = counter = Integer.valueOf(counter + 1);
        this.destFile = new File(ResourceHelper.getFile("bags"), MessageFormat.format("foo{0}.zip", counter));
        if (this.destFile.exists()) {
            FileUtils.forceDelete((File)this.destFile);
        }
        this.driver = new CommandLineBagDriver();
    }

    @Test
    public void testNoArgs() throws Exception {
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[0]));
    }

    @Test
    public void testMissingArgs() throws Exception {
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[]{"verifyvalid"}));
    }

    @Test
    public void testIsValid() throws Exception {
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[]{"verifyvalid", ResourceHelper.getFile("bags/v0_95/bag").getAbsolutePath()}));
    }

    @Test
    public void testIsComplete() throws Exception {
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[]{"verifycomplete", ResourceHelper.getFile("bags/v0_95/bag").getAbsolutePath()}));
    }

    @Test
    public void testverifyTagManifests() throws Exception {
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[]{"verifytagmanifests", ResourceHelper.getFile("bags/v0_95/bag").getAbsolutePath()}));
    }

    @Test
    public void testverifyPayloadManifests() throws Exception {
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[]{"verifypayloadmanifests", ResourceHelper.getFile("bags/v0_95/bag").getAbsolutePath()}));
    }

    @Test
    public void testCreate() throws Exception {
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[]{"create", this.destFile.getAbsolutePath(), ResourceHelper.getFile("bags/v0_95/bag/data/dir1").getAbsolutePath(), ResourceHelper.getFile("bags/v0_95/bag/data/dir2").getAbsolutePath(), "--writer", CommandLineBagDriver.VALUE_WRITER_ZIP, "--tagmanifestalgorithm", Manifest.Algorithm.SHA1.bagItAlgorithm}));
        Assert.assertTrue((boolean)this.destFile.exists());
        Bag bag = this.bagFactory.createBag(this.destFile);
        Assert.assertEquals((long)3L, (long)bag.getPayload().size());
        Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        BagInfoTxt bagInfo = bag.getBagInfoTxt();
        Assert.assertNotNull((Object)bagInfo);
        Assert.assertNotNull((Object)bagInfo.getBaggingDate());
        Assert.assertNotNull((Object)bagInfo.getBagSize());
        Assert.assertNotNull((Object)bagInfo.getPayloadOxum());
        Assert.assertEquals((long)1L, (long)bag.getTagManifests().size());
        Assert.assertEquals((Object)Manifest.Algorithm.SHA1, (Object)((Manifest)bag.getTagManifests().get(0)).getAlgorithm());
    }

    @Test
    public void testCreateWithWildcard() throws Exception {
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[]{"create", this.destFile.getAbsolutePath(), ResourceHelper.getFile("bags/v0_95/bag/data").getAbsolutePath() + File.separator + "*", "--writer", CommandLineBagDriver.VALUE_WRITER_ZIP, "--tagmanifestalgorithm", Manifest.Algorithm.SHA1.bagItAlgorithm}));
        Bag bag = this.bagFactory.createBag(this.destFile);
        Assert.assertEquals((long)5L, (long)bag.getPayload().size());
        Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        Assert.assertNotNull((Object)bag.getBagFile("data/test1.txt"));
    }

    @Test
    public void testCreateExcludeBagInfoAndTagManifest() throws Exception {
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[]{"create", this.destFile.getAbsolutePath(), ResourceHelper.getFile("bags/v0_95/bag/data/dir1").getAbsolutePath(), ResourceHelper.getFile("bags/v0_95/bag/data/dir2").getAbsolutePath(), "--writer", CommandLineBagDriver.VALUE_WRITER_ZIP, "--excludebaginfo", "--excludetagmanifest"}));
        Bag bag = this.bagFactory.createBag(this.destFile);
        Assert.assertEquals((long)3L, (long)bag.getPayload().size());
        Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        Assert.assertNull((Object)bag.getBagInfoTxt());
        Assert.assertTrue((boolean)bag.getTagManifests().isEmpty());
    }

    @Test
    public void testCreateWithMissingFile() throws Exception {
        Assert.assertEquals((long)2L, (long)this.driver.execute(new String[]{"create", this.destFile.getAbsolutePath(), ResourceHelper.getFile("bags/v0_95/bag/data/dir1").getAbsolutePath(), new File("foo").getAbsolutePath(), "--writer", CommandLineBagDriver.VALUE_WRITER_ZIP}));
    }

    @Test
    public void testCreateIncludeDelimiter() throws Exception {
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[]{"create", this.destFile.getAbsolutePath(), ResourceHelper.getFile("bags/v0_95/bag/data/dir1").getAbsolutePath(), ResourceHelper.getFile("bags/v0_95/bag/data/dir2").getAbsolutePath(), "--writer", CommandLineBagDriver.VALUE_WRITER_ZIP, "--manifestseparator", "    \t\t"}));
        Bag bag = this.bagFactory.createBag(this.destFile);
        Assert.assertEquals((long)3L, (long)bag.getPayload().size());
        Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        BagInfoTxt bagInfo = bag.getBagInfoTxt();
        Assert.assertNotNull((Object)bagInfo);
        Assert.assertNotNull((Object)bagInfo.getBaggingDate());
        Assert.assertNotNull((Object)bagInfo.getBagSize());
        Assert.assertNotNull((Object)bagInfo.getPayloadOxum());
        Assert.assertEquals((long)1L, (long)bag.getTagManifests().size());
    }

    @Test
    public void testMakeHoley() throws Exception {
        String BASE_URL = "http://foo.com/bag";
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[]{"makeholey", ResourceHelper.getFile("bags/v0_95/bag").getAbsolutePath(), this.destFile.getAbsolutePath(), "http://foo.com/bag", "--writer", CommandLineBagDriver.VALUE_WRITER_ZIP}));
        Assert.assertTrue((boolean)this.destFile.exists());
        Bag bag = this.bagFactory.createBag(this.destFile);
        FetchTxt fetch = bag.getFetchTxt();
        Assert.assertNotNull((Object)fetch);
        Assert.assertTrue((boolean)((FetchTxt.FilenameSizeUrl)fetch.get(0)).getUrl().startsWith("http://foo.com/bag"));
    }

    @Test
    public void testUpdateIncludeDelimiter() throws Exception {
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[]{"create", this.destFile.getAbsolutePath(), ResourceHelper.getFile("bags/v0_95/bag/data/dir1").getAbsolutePath(), ResourceHelper.getFile("bags/v0_95/bag/data/dir2").getAbsolutePath()}));
        Assert.assertEquals((long)0L, (long)this.driver.execute(new String[]{"update", this.destFile.getAbsolutePath(), "--manifestseparator", "    \t\t"}));
        Bag bag = this.bagFactory.createBag(this.destFile);
        Assert.assertEquals((long)3L, (long)bag.getPayload().size());
        Assert.assertTrue((boolean)bag.verifyValid().isSuccess());
        BagInfoTxt bagInfo = bag.getBagInfoTxt();
        Assert.assertNotNull((Object)bagInfo);
        Assert.assertNotNull((Object)bagInfo.getBaggingDate());
        Assert.assertNotNull((Object)bagInfo.getBagSize());
        Assert.assertNotNull((Object)bagInfo.getPayloadOxum());
        Assert.assertEquals((long)1L, (long)bag.getTagManifests().size());
    }
}

