/*
 * Decompiled with CFR 0.152.
 */
package gov.hhs.cms.bluebutton.datapipeline.fhir.transform;

import com.justdavis.karl.misc.exceptions.BadCodeMonkeyException;
import gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.ClaimType;
import gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.CurrentBeneficiary;
import gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.PartAClaimFact;
import gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.PartAClaimRevLineFact;
import gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.PartBClaimLineFact;
import gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.PartDEventFact;
import gov.hhs.cms.bluebutton.datapipeline.fhir.transform.BeneficiaryBundle;
import gov.hhs.cms.bluebutton.datapipeline.fhir.transform.TransformedBundle;
import gov.hhs.cms.bluebutton.datapipeline.rif.model.BeneficiaryRow;
import gov.hhs.cms.bluebutton.datapipeline.rif.model.PartDEventRow;
import gov.hhs.cms.bluebutton.datapipeline.rif.model.RecordAction;
import gov.hhs.cms.bluebutton.datapipeline.rif.model.RifRecordEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.dstu21.model.Address;
import org.hl7.fhir.dstu21.model.Bundle;
import org.hl7.fhir.dstu21.model.CodeableConcept;
import org.hl7.fhir.dstu21.model.Coding;
import org.hl7.fhir.dstu21.model.Coverage;
import org.hl7.fhir.dstu21.model.DateType;
import org.hl7.fhir.dstu21.model.Duration;
import org.hl7.fhir.dstu21.model.ExplanationOfBenefit;
import org.hl7.fhir.dstu21.model.Extension;
import org.hl7.fhir.dstu21.model.IdType;
import org.hl7.fhir.dstu21.model.IntegerType;
import org.hl7.fhir.dstu21.model.MedicationOrder;
import org.hl7.fhir.dstu21.model.Money;
import org.hl7.fhir.dstu21.model.Organization;
import org.hl7.fhir.dstu21.model.Patient;
import org.hl7.fhir.dstu21.model.Period;
import org.hl7.fhir.dstu21.model.Practitioner;
import org.hl7.fhir.dstu21.model.Reference;
import org.hl7.fhir.dstu21.model.Resource;
import org.hl7.fhir.dstu21.model.SimpleQuantity;
import org.hl7.fhir.dstu21.model.StringType;
import org.hl7.fhir.dstu21.model.Type;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public final class DataTransformer {
    static final String EXTENSION_CMS_CLAIM_TYPE = "http://bluebutton.cms.hhs.gov/extensions#claimType";
    static final String EXTENSION_CMS_DIAGNOSIS_GROUP = "http://bluebutton.cms.hhs.gov/extensions#diagnosisRelatedGroupCode";
    static final String EXTENSION_CMS_ADMITTING_DIAGNOSIS = "http://bluebutton.cms.hhs.gov/extensions#admittingDiagnosis";
    static final String EXTENSION_CMS_OTHER_PHYSICIAN = "http://bluebutton.cms.hhs.gov/extensions#otherPhysician";
    static final String EXTENSION_CMS_OPERATING_PHYSICIAN = "http://bluebutton.cms.hhs.gov/extensions#operatingPhysician";
    static final String EXTENSION_CMS_ATTENDING_PHYSICIAN = "http://bluebutton.cms.hhs.gov/extensions#attendingPhysician";
    static final String EXTENSION_CMS_DIAGNOSIS_LINK_ID = "http://bluebutton.cms.hhs.gov/extensions#diagnosisLinkId";
    static final String COVERAGE_ISSUER = "Centers for Medicare and Medicaid Services";
    static final String COVERAGE_PLAN = "Medicare";
    static final String COVERAGE_PLAN_PART_A = "Part A";
    static final String COVERAGE_PLAN_PART_B = "Part B";
    static final String COVERAGE_PLAN_PART_D = "Part D";
    static final String CODING_SYSTEM_HCPCS = "HCPCS";
    static final String CODING_SYSTEM_ICD9_DIAG = "http://hl7.org/fhir/sid/icd-9-cm/diagnosis";
    static final String CODING_SYSTEM_ICD9_PROC = "http://hl7.org/fhir/sid/icd-9-cm/procedure";
    static final String CODING_SYSTEM_NPI_US = "http://hl7.org/fhir/sid/us-npi";
    static final String CODING_SYSTEM_ADJUDICATION_FHIR = "http://hl7.org/fhir/adjudication";
    static final String CODING_SYSTEM_CMS_CLAIM_TYPES = "http://bluebutton.cms.hhs.gov/coding#claimType";
    static final String CODING_SYSTEM_ADJUDICATION_CMS = "CMS Adjudications";
    static final String CODING_SYSTEM_CCW_BENE_ID = "CCW.BENE_ID";
    static final String CODING_SYSTEM_CCW_PDE_ID = "CCW.PDE_ID";
    static final String CODING_SYSTEM_FHIR_ACT = "http://hl7.org/fhir/v3/ActCode";
    static final String CODED_CMS_CLAIM_TYPE_RX_DRUG = "FIXME3";
    static final String CODED_ADJUDICATION_ALLOWED_CHARGE = "Line Allowed Charge Amount";
    static final String CODED_ADJUDICATION_DEDUCTIBLE = "Line Beneficiary Part B Deductible Amount";
    static final String CODED_ADJUDICATION_BENEFICIARY_PRIMARY_PAYER_PAID = "Line Beneficiary Primary Payer Paid Amount";
    static final String CODED_ADJUDICATION_LINE_COINSURANCE_AMOUNT = "Line Coinsurance Amount";
    static final String CODED_ADJUDICATION_PAYMENT = "Line NCH Payment Amount";
    static final String CODED_ADJUDICATION_PASS_THROUGH_PER_DIEM_AMOUNT = "Claim Pass Thru Per Diem Amount";
    static final String CODED_ADJUDICATION_NCH_BENEFICIARY_INPATIENT_DEDUCTIBLE = "NCH Beneficiary Inpatient Deductible Amount";
    static final String CODED_ADJUDICATION_NCH_BENEFICIARY_PART_A_COINSURANCE_LIABILITY = "NCH Beneficiary Part A Coinsurance Liability Amount";
    static final String CODED_ADJUDICATION_PATIENT_PAY = "Patient Pay Amount";
    static final String CODED_ADJUDICATION_TOTAL_COST = "Total Prescription Cost";
    static final String CODED_ADJUDICATION_NCH_BENEFICIARY_BLOOD_DEDUCTIBLE_LIABILITY_AMOUNT = "NCH Beneficiary Blood Deductible Liability Amount";
    static final String CODED_ADJUDICATION_NCH_PRIMARY_PAYER_CLAIM_PAID_AMOUNT = "NCH Primary Payer Claim Paid Amount";
    static final String CODED_ADJUDICATION_NCH_BENEFICIARY_PART_B_DEDUCTIBLE = "NCH Beneficiary Part B Deductible Amount";
    static final String CODED_ADJUDICATION_NCH_BENEFICIARY_PART_B_COINSURANCE = "NCH Beneficiary Part B Coinsurance Amount";
    static final String CODING_SYSTEM_FHIR_EOB_ITEM_TYPE = "http://hl7.org/fhir/ValueSet/v3-ActInvoiceGroupCode";
    static final String CODED_EOB_ITEM_TYPE_CLINICAL_SERVICES_AND_PRODUCTS = "CSPINV";
    static final String CODING_SYSTEM_MONEY = "urn:std:iso:4217";
    static final String CODING_SYSTEM_MONEY_US = "USD";

    public Stream<BeneficiaryBundle> transformSourceData(Stream<CurrentBeneficiary> sourceBeneficiaries) {
        Stream<BeneficiaryBundle> transformedRecords = sourceBeneficiaries.map(b -> DataTransformer.convertToFhir(b));
        return transformedRecords;
    }

    static BeneficiaryBundle convertToFhir(CurrentBeneficiary sourceBeneficiary) {
        ExplanationOfBenefit eob;
        Extension operatingPhysicianExtension;
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        Patient patient = new Patient();
        resources.add((IBaseResource)patient);
        patient.setId((IIdType)IdType.newRandomUuid());
        patient.addIdentifier().setSystem("CCW_BENE_CRNT_VW.BENE_ID").setValue("" + sourceBeneficiary.getId());
        if (sourceBeneficiary.getBirthDate() != null) {
            patient.setBirthDate((java.util.Date)Date.valueOf(sourceBeneficiary.getBirthDate()));
        }
        patient.addName().addFamily(sourceBeneficiary.getSurname()).addGiven(sourceBeneficiary.getGivenName());
        List<String> addressComponents = Arrays.asList(sourceBeneficiary.getContactAddress(), sourceBeneficiary.getContactAddressZip());
        addressComponents = addressComponents.stream().filter(c -> c != null && c.trim().length() > 0).collect(Collectors.toList());
        if (!addressComponents.isEmpty()) {
            Address address = patient.addAddress();
            for (String string : addressComponents) {
                address.addLine(string);
            }
        }
        Organization cms = new Organization();
        resources.add((IBaseResource)cms);
        cms.setId((IIdType)IdType.newRandomUuid());
        cms.setName("CMS");
        Coverage partACoverage = new Coverage();
        resources.add((IBaseResource)partACoverage);
        partACoverage.setId((IIdType)IdType.newRandomUuid());
        partACoverage.setIssuer(new Reference(cms.getId()));
        partACoverage.setPlan(COVERAGE_PLAN_PART_A);
        for (Object sourceClaim : sourceBeneficiary.getPartAClaimFacts()) {
            if (sourceClaim.getClaimProfile() == null || sourceClaim.getClaimProfile().getClaimType() != ClaimType.INPATIENT_CLAIM) continue;
            ExplanationOfBenefit eob2 = new ExplanationOfBenefit();
            resources.add((IBaseResource)eob2);
            eob2.setId((IIdType)IdType.newRandomUuid());
            eob2.getCoverage().setCoverage(new Reference(partACoverage.getId()));
            eob2.addExtension().setUrl(EXTENSION_CMS_CLAIM_TYPE).setValue((Type)new Coding().setSystem(CODING_SYSTEM_CMS_CLAIM_TYPES).setCode(sourceClaim.getClaimProfile().getClaimType().getCode()).setDisplay(sourceClaim.getClaimProfile().getClaimType().getDescription()));
            eob2.setPatient(new Reference().setReference(patient.getId()));
            eob2.addIdentifier().setSystem("CCW_PTA_FACT.CLM_ID").setValue("" + sourceClaim.getId());
            if (sourceClaim.getDiagnosisGroup() != null) {
                eob2.addExtension().setUrl(EXTENSION_CMS_DIAGNOSIS_GROUP).setValue((Type)new StringType(sourceClaim.getDiagnosisGroup().getCode()));
            }
            if (sourceClaim.getDateFrom() != null || sourceClaim.getDateThrough() != null) {
                eob2.setBillablePeriod(new Period().setStart((java.util.Date)Date.valueOf(sourceClaim.getDateFrom())).setEnd((java.util.Date)Date.valueOf(sourceClaim.getDateThrough())));
            }
            if (sourceClaim.getProviderAtTimeOfClaimNpi() != null) {
                Practitioner provider = new Practitioner();
                resources.add((IBaseResource)provider);
                provider.setId((IIdType)IdType.newRandomUuid());
                provider.addIdentifier().setSystem(CODING_SYSTEM_NPI_US).setValue(sourceClaim.getProviderAtTimeOfClaimNpi().toString());
                eob2.setProvider(new Reference().setReference(provider.getId()));
            }
            if (sourceClaim.getAttendingPhysicianNpi() != null) {
                Practitioner attendingPhysician = new Practitioner();
                resources.add((IBaseResource)attendingPhysician);
                attendingPhysician.setId((IIdType)IdType.newRandomUuid());
                attendingPhysician.addIdentifier().setSystem(CODING_SYSTEM_NPI_US).setValue(sourceClaim.getAttendingPhysicianNpi().toString());
                Extension attendingPhysicianExtension = eob2.addExtension();
                attendingPhysicianExtension.setUrl(EXTENSION_CMS_ATTENDING_PHYSICIAN);
                attendingPhysicianExtension.setValue((Type)new Reference().setReference(attendingPhysician.getId()));
            }
            if (sourceClaim.getOperatingPhysicianNpi() != null) {
                Practitioner operatingPhysician = new Practitioner();
                resources.add((IBaseResource)operatingPhysician);
                operatingPhysician.setId((IIdType)IdType.newRandomUuid());
                operatingPhysician.addIdentifier().setSystem(CODING_SYSTEM_NPI_US).setValue(sourceClaim.getOperatingPhysicianNpi().toString());
                operatingPhysicianExtension = eob2.addExtension();
                operatingPhysicianExtension.setUrl(EXTENSION_CMS_OPERATING_PHYSICIAN);
                operatingPhysicianExtension.setValue((Type)new Reference().setReference(operatingPhysician.getId()));
            }
            if (sourceClaim.getOtherPhysicianNpi() != null) {
                Practitioner otherPhysician = new Practitioner();
                resources.add((IBaseResource)otherPhysician);
                otherPhysician.setId((IIdType)IdType.newRandomUuid());
                otherPhysician.addIdentifier().setSystem(CODING_SYSTEM_NPI_US).setValue(sourceClaim.getOtherPhysicianNpi().toString());
                Extension otherPhysicianExtension = eob2.addExtension();
                otherPhysicianExtension.setUrl(EXTENSION_CMS_OTHER_PHYSICIAN);
                otherPhysicianExtension.setValue((Type)new Reference().setReference(otherPhysician.getId()));
            }
            if (sourceClaim.getAdmittingDiagnosisCode() != null) {
                Extension operatingPhysicianExtension2 = eob2.addExtension();
                operatingPhysicianExtension2.setUrl(EXTENSION_CMS_ADMITTING_DIAGNOSIS);
                operatingPhysicianExtension2.setValue((Type)new Coding().setSystem(CODING_SYSTEM_ICD9_DIAG).setCode(sourceClaim.getAdmittingDiagnosisCode()));
            }
            ExplanationOfBenefit.ItemsComponent eobSoleItem = eob2.addItem();
            eobSoleItem.setType(new Coding().setSystem(CODING_SYSTEM_FHIR_EOB_ITEM_TYPE).setCode(CODED_EOB_ITEM_TYPE_CLINICAL_SERVICES_AND_PRODUCTS));
            if (sourceClaim.getDateAdmission() != null || sourceClaim.getDateDischarge() != null) {
                eobSoleItem.setServiced((Type)new Period().setStart((java.util.Date)Date.valueOf(sourceClaim.getDateAdmission())).setEnd((java.util.Date)Date.valueOf(sourceClaim.getDateDischarge())));
            }
            if (sourceClaim.getUtilizationDayCount() != null) {
                SimpleQuantity utilizationDayCount = (SimpleQuantity)new SimpleQuantity().setUnit("days").setValue(sourceClaim.getUtilizationDayCount().longValue());
                eobSoleItem.setQuantity(utilizationDayCount);
            }
            if (sourceClaim.getPayment() != null) {
                eobSoleItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_PAYMENT)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaim.getPayment());
            }
            if (sourceClaim.getPassThroughPerDiemAmount() != null) {
                eobSoleItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_PASS_THROUGH_PER_DIEM_AMOUNT)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaim.getPassThroughPerDiemAmount());
            }
            if (sourceClaim.getNchBeneficiaryBloodDeductibleLiability() != null) {
                eobSoleItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_NCH_BENEFICIARY_BLOOD_DEDUCTIBLE_LIABILITY_AMOUNT)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaim.getNchBeneficiaryBloodDeductibleLiability());
            }
            if (sourceClaim.getNchBeneficiaryInpatientDeductible() != null) {
                eobSoleItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_NCH_BENEFICIARY_INPATIENT_DEDUCTIBLE)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaim.getNchBeneficiaryInpatientDeductible());
            }
            if (sourceClaim.getNchBeneficiaryPartACoinsuranceLiability() != null) {
                eobSoleItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_NCH_BENEFICIARY_PART_A_COINSURANCE_LIABILITY)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaim.getNchBeneficiaryPartACoinsuranceLiability());
            }
            if (sourceClaim.getNchPrimaryPayerPaid() != null) {
                eobSoleItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_NCH_PRIMARY_PAYER_CLAIM_PAID_AMOUNT)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaim.getNchPrimaryPayerPaid());
            }
            for (PartAClaimRevLineFact sourceLine : sourceClaim.getClaimLines()) {
                ExplanationOfBenefit.DetailComponent eobDetail = eobSoleItem.addDetail();
                eobDetail.setSequence((int)sourceLine.getLineNumber());
                eobDetail.setType(new Coding().setSystem(CODING_SYSTEM_FHIR_EOB_ITEM_TYPE).setCode(CODED_EOB_ITEM_TYPE_CLINICAL_SERVICES_AND_PRODUCTS));
                DataTransformer.addDiagnosisCodeAndLink(eob2, eobDetail, sourceLine.getDiagnosisCode1());
                DataTransformer.addDiagnosisCodeAndLink(eob2, eobDetail, sourceLine.getDiagnosisCode2());
                DataTransformer.addDiagnosisCodeAndLink(eob2, eobDetail, sourceLine.getDiagnosisCode3());
                DataTransformer.addDiagnosisCodeAndLink(eob2, eobDetail, sourceLine.getDiagnosisCode4());
                DataTransformer.addDiagnosisCodeAndLink(eob2, eobDetail, sourceLine.getDiagnosisCode5());
                DataTransformer.addDiagnosisCodeAndLink(eob2, eobDetail, sourceLine.getDiagnosisCode6());
                DataTransformer.addDiagnosisCodeAndLink(eob2, eobDetail, sourceLine.getDiagnosisCode7());
                DataTransformer.addDiagnosisCodeAndLink(eob2, eobDetail, sourceLine.getDiagnosisCode8());
                DataTransformer.addDiagnosisCodeAndLink(eob2, eobDetail, sourceLine.getDiagnosisCode9());
                DataTransformer.addDiagnosisCodeAndLink(eob2, eobDetail, sourceLine.getDiagnosisCode10());
                List procedureCodes = Arrays.stream(new String[]{sourceLine.getProcedureCode1(), sourceLine.getProcedureCode2(), sourceLine.getProcedureCode3(), sourceLine.getProcedureCode4(), sourceLine.getProcedureCode5(), sourceLine.getProcedureCode6()}).filter(c -> c != null && !c.trim().isEmpty()).collect(Collectors.toList());
                for (Object procedureCode : procedureCodes) {
                    ExplanationOfBenefit.SubDetailComponent eobSubDetail = new ExplanationOfBenefit.SubDetailComponent();
                    eobDetail.addSubDetail(eobSubDetail);
                    eobSubDetail.setType(new Coding().setSystem(CODING_SYSTEM_FHIR_EOB_ITEM_TYPE).setCode(CODED_EOB_ITEM_TYPE_CLINICAL_SERVICES_AND_PRODUCTS));
                    eobSubDetail.setService(new Coding().setSystem(CODING_SYSTEM_ICD9_PROC).setCode((String)procedureCode));
                }
            }
        }
        Coverage coverage = new Coverage();
        resources.add((IBaseResource)coverage);
        coverage.setId((IIdType)IdType.newRandomUuid());
        coverage.setIssuer(new Reference(cms.getId()));
        coverage.setPlan(COVERAGE_PLAN_PART_B);
        for (PartAClaimFact sourceClaim : sourceBeneficiary.getPartAClaimFacts()) {
            if (sourceClaim.getClaimProfile() == null || sourceClaim.getClaimProfile().getClaimType() != ClaimType.OUTPATIENT_CLAIM) continue;
            eob = new ExplanationOfBenefit();
            resources.add((IBaseResource)eob);
            eob.setId((IIdType)IdType.newRandomUuid());
            eob.getCoverage().setCoverage(new Reference(coverage.getId()));
            eob.addExtension().setUrl(EXTENSION_CMS_CLAIM_TYPE).setValue((Type)new Coding().setSystem(CODING_SYSTEM_CMS_CLAIM_TYPES).setCode(sourceClaim.getClaimProfile().getClaimType().getCode()).setDisplay(sourceClaim.getClaimProfile().getClaimType().getDescription()));
            eob.setPatient(new Reference().setReference(patient.getId()));
            eob.addIdentifier().setSystem("CCW_PTA_FACT.CLM_ID").setValue("" + sourceClaim.getId());
            if (sourceClaim.getDateFrom() != null || sourceClaim.getDateThrough() != null) {
                eob.setBillablePeriod(new Period().setStart((java.util.Date)Date.valueOf(sourceClaim.getDateFrom())).setEnd((java.util.Date)Date.valueOf(sourceClaim.getDateThrough())));
            }
            if (sourceClaim.getProviderAtTimeOfClaimNpi() != null) {
                Practitioner provider = new Practitioner();
                resources.add((IBaseResource)provider);
                provider.setId((IIdType)IdType.newRandomUuid());
                provider.addIdentifier().setSystem(CODING_SYSTEM_NPI_US).setValue(sourceClaim.getProviderAtTimeOfClaimNpi().toString());
                eob.setProvider(new Reference().setReference(provider.getId()));
            }
            if (sourceClaim.getAttendingPhysicianNpi() != null) {
                Practitioner attendingPhysician = new Practitioner();
                resources.add((IBaseResource)attendingPhysician);
                attendingPhysician.setId((IIdType)IdType.newRandomUuid());
                attendingPhysician.addIdentifier().setSystem(CODING_SYSTEM_NPI_US).setValue(sourceClaim.getAttendingPhysicianNpi().toString());
                Extension attendingPhysicianExtension = eob.addExtension();
                attendingPhysicianExtension.setUrl(EXTENSION_CMS_ATTENDING_PHYSICIAN);
                attendingPhysicianExtension.setValue((Type)new Reference().setReference(attendingPhysician.getId()));
            }
            if (sourceClaim.getOperatingPhysicianNpi() != null) {
                Practitioner operatingPhysician = new Practitioner();
                resources.add((IBaseResource)operatingPhysician);
                operatingPhysician.setId((IIdType)IdType.newRandomUuid());
                operatingPhysician.addIdentifier().setSystem(CODING_SYSTEM_NPI_US).setValue(sourceClaim.getOperatingPhysicianNpi().toString());
                Extension operatingPhysicianExtension3 = eob.addExtension();
                operatingPhysicianExtension3.setUrl(EXTENSION_CMS_OPERATING_PHYSICIAN);
                operatingPhysicianExtension3.setValue((Type)new Reference().setReference(operatingPhysician.getId()));
            }
            if (sourceClaim.getOtherPhysicianNpi() != null) {
                Practitioner otherPhysician = new Practitioner();
                resources.add((IBaseResource)otherPhysician);
                otherPhysician.setId((IIdType)IdType.newRandomUuid());
                otherPhysician.addIdentifier().setSystem(CODING_SYSTEM_NPI_US).setValue(sourceClaim.getOtherPhysicianNpi().toString());
                Extension otherPhysicianExtension = eob.addExtension();
                otherPhysicianExtension.setUrl(EXTENSION_CMS_OTHER_PHYSICIAN);
                otherPhysicianExtension.setValue((Type)new Reference().setReference(otherPhysician.getId()));
            }
            if (sourceClaim.getAdmittingDiagnosisCode() != null) {
                operatingPhysicianExtension = eob.addExtension();
                operatingPhysicianExtension.setUrl(EXTENSION_CMS_ADMITTING_DIAGNOSIS);
                operatingPhysicianExtension.setValue((Type)new Coding().setSystem(CODING_SYSTEM_ICD9_DIAG).setCode(sourceClaim.getAdmittingDiagnosisCode()));
            }
            ExplanationOfBenefit.ItemsComponent eobSoleItem = eob.addItem();
            eobSoleItem.setType(new Coding().setSystem(CODING_SYSTEM_FHIR_EOB_ITEM_TYPE).setCode(CODED_EOB_ITEM_TYPE_CLINICAL_SERVICES_AND_PRODUCTS));
            if (sourceClaim.getPayment() != null) {
                eobSoleItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_PAYMENT)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaim.getPayment());
            }
            if (sourceClaim.getNchPrimaryPayerPaid() != null) {
                eobSoleItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_NCH_PRIMARY_PAYER_CLAIM_PAID_AMOUNT)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaim.getNchPrimaryPayerPaid());
            }
            if (sourceClaim.getNchBeneficiaryBloodDeductibleLiability() != null) {
                eobSoleItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_NCH_BENEFICIARY_BLOOD_DEDUCTIBLE_LIABILITY_AMOUNT)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaim.getNchBeneficiaryBloodDeductibleLiability());
            }
            if (sourceClaim.getNchBeneficiaryPartBDeductible() != null) {
                eobSoleItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_NCH_BENEFICIARY_PART_B_DEDUCTIBLE)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaim.getNchBeneficiaryPartBDeductible());
            }
            if (sourceClaim.getNchBeneficiaryPartBCoinsurance() != null) {
                eobSoleItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_NCH_BENEFICIARY_PART_B_COINSURANCE)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaim.getNchBeneficiaryPartBCoinsurance());
            }
            for (PartAClaimRevLineFact sourceLine : sourceClaim.getClaimLines()) {
                ExplanationOfBenefit.DetailComponent eobDetail = eobSoleItem.addDetail();
                eobDetail.setSequence((int)sourceLine.getLineNumber());
                eobDetail.setType(new Coding().setSystem(CODING_SYSTEM_FHIR_EOB_ITEM_TYPE).setCode(CODED_EOB_ITEM_TYPE_CLINICAL_SERVICES_AND_PRODUCTS));
                if (sourceLine.getRevenueCenter() != null) {
                    eobDetail.setService(new Coding().setSystem(CODING_SYSTEM_HCPCS).setCode(sourceLine.getRevenueCenter().getCode()));
                }
                DataTransformer.addDiagnosisCodeAndLink(eob, eobDetail, sourceLine.getDiagnosisCode1());
                DataTransformer.addDiagnosisCodeAndLink(eob, eobDetail, sourceLine.getDiagnosisCode2());
                DataTransformer.addDiagnosisCodeAndLink(eob, eobDetail, sourceLine.getDiagnosisCode3());
                DataTransformer.addDiagnosisCodeAndLink(eob, eobDetail, sourceLine.getDiagnosisCode4());
                DataTransformer.addDiagnosisCodeAndLink(eob, eobDetail, sourceLine.getDiagnosisCode5());
                DataTransformer.addDiagnosisCodeAndLink(eob, eobDetail, sourceLine.getDiagnosisCode6());
                DataTransformer.addDiagnosisCodeAndLink(eob, eobDetail, sourceLine.getDiagnosisCode7());
                DataTransformer.addDiagnosisCodeAndLink(eob, eobDetail, sourceLine.getDiagnosisCode8());
                DataTransformer.addDiagnosisCodeAndLink(eob, eobDetail, sourceLine.getDiagnosisCode9());
                DataTransformer.addDiagnosisCodeAndLink(eob, eobDetail, sourceLine.getDiagnosisCode10());
                List procedureCodes = Arrays.stream(new String[]{sourceLine.getProcedureCode1(), sourceLine.getProcedureCode2(), sourceLine.getProcedureCode3(), sourceLine.getProcedureCode4(), sourceLine.getProcedureCode5(), sourceLine.getProcedureCode6()}).filter(c -> c != null && !c.trim().isEmpty()).collect(Collectors.toList());
                for (String procedureCode : procedureCodes) {
                    ExplanationOfBenefit.SubDetailComponent eobSubDetail = new ExplanationOfBenefit.SubDetailComponent();
                    eobDetail.addSubDetail(eobSubDetail);
                    eobSubDetail.setType(new Coding().setSystem(CODING_SYSTEM_FHIR_EOB_ITEM_TYPE).setCode(CODED_EOB_ITEM_TYPE_CLINICAL_SERVICES_AND_PRODUCTS));
                    eobSubDetail.setService(new Coding().setSystem(CODING_SYSTEM_ICD9_PROC).setCode(procedureCode));
                }
            }
        }
        for (PartAClaimFact sourceClaim : sourceBeneficiary.getPartBClaimFacts()) {
            if (sourceClaim.getClaimProfile() == null || sourceClaim.getClaimProfile().getClaimType() != ClaimType.CARRIER_NON_DME_CLAIM) continue;
            eob = new ExplanationOfBenefit();
            resources.add((IBaseResource)eob);
            eob.setId((IIdType)IdType.newRandomUuid());
            eob.getCoverage().setCoverage(new Reference(coverage.getId()));
            eob.addExtension().setUrl(EXTENSION_CMS_CLAIM_TYPE).setValue((Type)new Coding().setSystem(CODING_SYSTEM_CMS_CLAIM_TYPES).setCode(sourceClaim.getClaimProfile().getClaimType().getCode()).setDisplay(sourceClaim.getClaimProfile().getClaimType().getDescription()));
            eob.setPatient(new Reference().setReference(patient.getId()));
            eob.addIdentifier().setSystem("CCW_PTB_FACT.CARR_CLM_CNTL_NUM").setValue("" + sourceClaim.getCarrierControlNumber());
            if (!DataTransformer.isBlank(sourceClaim.getDiagnosisCode1())) {
                eob.addDiagnosis().getDiagnosis().setSystem(CODING_SYSTEM_ICD9_DIAG).setCode(sourceClaim.getDiagnosisCode1());
            }
            if (!DataTransformer.isBlank(sourceClaim.getDiagnosisCode2())) {
                eob.addDiagnosis().getDiagnosis().setSystem(CODING_SYSTEM_ICD9_DIAG).setCode(sourceClaim.getDiagnosisCode2());
            }
            if (!DataTransformer.isBlank(sourceClaim.getDiagnosisCode3())) {
                eob.addDiagnosis().getDiagnosis().setSystem(CODING_SYSTEM_ICD9_DIAG).setCode(sourceClaim.getDiagnosisCode3());
            }
            if (!DataTransformer.isBlank(sourceClaim.getDiagnosisCode4())) {
                eob.addDiagnosis().getDiagnosis().setSystem(CODING_SYSTEM_ICD9_DIAG).setCode(sourceClaim.getDiagnosisCode4());
            }
            if (!DataTransformer.isBlank(sourceClaim.getDiagnosisCode5())) {
                eob.addDiagnosis().getDiagnosis().setSystem(CODING_SYSTEM_ICD9_DIAG).setCode(sourceClaim.getDiagnosisCode5());
            }
            if (!DataTransformer.isBlank(sourceClaim.getDiagnosisCode6())) {
                eob.addDiagnosis().getDiagnosis().setSystem(CODING_SYSTEM_ICD9_DIAG).setCode(sourceClaim.getDiagnosisCode6());
            }
            if (!DataTransformer.isBlank(sourceClaim.getDiagnosisCode7())) {
                eob.addDiagnosis().getDiagnosis().setSystem(CODING_SYSTEM_ICD9_DIAG).setCode(sourceClaim.getDiagnosisCode7());
            }
            if (!DataTransformer.isBlank(sourceClaim.getDiagnosisCode8())) {
                eob.addDiagnosis().getDiagnosis().setSystem(CODING_SYSTEM_ICD9_DIAG).setCode(sourceClaim.getDiagnosisCode8());
            }
            if (sourceClaim.getProviderNpi() != null) {
                Practitioner providingPhysician = new Practitioner();
                resources.add((IBaseResource)providingPhysician);
                providingPhysician.setId((IIdType)IdType.newRandomUuid());
                providingPhysician.addIdentifier().setSystem(CODING_SYSTEM_NPI_US).setValue(sourceClaim.getProviderNpi().toString());
                eob.setProvider(new Reference().setReference(providingPhysician.getId()));
            }
            for (PartBClaimLineFact sourceClaimLine : sourceClaim.getClaimLines()) {
                ExplanationOfBenefit.ItemsComponent item = eob.addItem();
                item.setSequence((int)sourceClaimLine.getLineNumber());
                if (sourceClaimLine.getProcedure() != null) {
                    item.setService(new Coding().setSystem(CODING_SYSTEM_HCPCS).setCode(sourceClaimLine.getProcedure().getCode()));
                }
                if (sourceClaimLine.getDateFrom() != null || sourceClaimLine.getDateThrough() != null) {
                    item.setServiced((Type)new Period().setStart((java.util.Date)Date.valueOf(sourceClaimLine.getDateFrom())).setEnd((java.util.Date)Date.valueOf(sourceClaimLine.getDateThrough())));
                }
                if (sourceClaimLine.getAllowedAmount() != null) {
                    item.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_ALLOWED_CHARGE)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaimLine.getAllowedAmount().doubleValue());
                }
                if (sourceClaimLine.getDeductibleAmount() != null) {
                    item.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_DEDUCTIBLE)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaimLine.getDeductibleAmount().doubleValue());
                }
                if (sourceClaimLine.getBeneficiaryPrimaryPayerPaidAmount() != null) {
                    item.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_BENEFICIARY_PRIMARY_PAYER_PAID)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaimLine.getBeneficiaryPrimaryPayerPaidAmount().doubleValue());
                }
                if (sourceClaimLine.getCoinsuranceAmount() != null) {
                    item.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_LINE_COINSURANCE_AMOUNT)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaimLine.getCoinsuranceAmount().doubleValue());
                }
                if (sourceClaimLine.getNchPaymentAmount() != null) {
                    item.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_PAYMENT)).getAmount().setSystem(CODING_SYSTEM_MONEY).setCode(CODING_SYSTEM_MONEY_US).setValue(sourceClaimLine.getNchPaymentAmount().doubleValue());
                }
                if (DataTransformer.isBlank(sourceClaimLine.getLineDiagnosisCode())) continue;
                DataTransformer.addDiagnosisCode(eob.getDiagnosis(), sourceClaimLine.getLineDiagnosisCode());
                int diagnosisCodeIndex = DataTransformer.getDiagnosisCodeIndex(eob.getDiagnosis(), sourceClaimLine.getLineDiagnosisCode());
                item.addDiagnosisLinkId(diagnosisCodeIndex);
            }
        }
        Coverage partDCoverage = new Coverage();
        resources.add((IBaseResource)partDCoverage);
        partDCoverage.setId((IIdType)IdType.newRandomUuid());
        partDCoverage.setIssuer(new Reference(cms.getId()));
        partDCoverage.setPlan(COVERAGE_PLAN_PART_D);
        for (PartDEventFact sourceEvent : sourceBeneficiary.getPartDEventFacts()) {
            ExplanationOfBenefit eob3 = new ExplanationOfBenefit();
            resources.add((IBaseResource)eob3);
            eob3.setId((IIdType)IdType.newRandomUuid());
            eob3.getCoverage().setCoverage(new Reference(partDCoverage.getId()));
            eob3.addExtension().setUrl(EXTENSION_CMS_CLAIM_TYPE).setValue((Type)new Coding().setSystem(CODING_SYSTEM_CMS_CLAIM_TYPES).setCode(CODED_CMS_CLAIM_TYPE_RX_DRUG).setDisplay(COVERAGE_PLAN_PART_D));
            eob3.setPatient(new Reference().setReference(patient.getId()));
            eob3.addIdentifier().setSystem("CCW_PDE_FACT.PDE_ID").setValue("" + sourceEvent.getId());
            MedicationOrder prescription = new MedicationOrder();
            resources.add((IBaseResource)prescription);
            prescription.setId((IIdType)IdType.newRandomUuid());
            eob3.setPrescription(new Reference().setReference(prescription.getId()));
            if (sourceEvent.getPrescriberNpi() != null) {
                Practitioner prescriber = new Practitioner();
                resources.add((IBaseResource)prescriber);
                prescriber.setId((IIdType)IdType.newRandomUuid());
                prescriber.addIdentifier().setSystem(CODING_SYSTEM_NPI_US).setValue(sourceEvent.getPrescriberNpi().toString());
                prescription.setPrescriber(new Reference().setReference(prescriber.getId()));
            }
            if (sourceEvent.getServiceProviderNpi() != null) {
                Practitioner servicingProvider = new Practitioner();
                resources.add((IBaseResource)servicingProvider);
                servicingProvider.setId((IIdType)IdType.newRandomUuid());
                servicingProvider.addIdentifier().setSystem(CODING_SYSTEM_NPI_US).setValue(sourceEvent.getServiceProviderNpi().toString());
                eob3.setProvider(new Reference().setReference(servicingProvider.getId()));
            }
            if (sourceEvent.getProductNdc() != null) {
                CodeableConcept medicationCoding = new CodeableConcept();
                medicationCoding.addCoding().setSystem("https://www.accessdata.fda.gov/scripts/cder/ndc/").setCode("" + sourceEvent.getProductNdc());
                prescription.setMedication((Type)medicationCoding);
            }
            ExplanationOfBenefit.ItemsComponent eventItem = eob3.addItem();
            eventItem.setSequence(1);
            eventItem.setType(new Coding().setSystem(CODING_SYSTEM_FHIR_ACT).setCode("RXDINV"));
            eventItem.setServiced((Type)new DateType().setValue((java.util.Date)Date.valueOf(sourceEvent.getServiceDate())));
            SimpleQuantity quantity = new SimpleQuantity();
            quantity.setValue(sourceEvent.getQuantityDispensed().longValue());
            Duration numberDaysSupply = new Duration();
            numberDaysSupply.setUnit("days");
            numberDaysSupply.setValue(sourceEvent.getNumberDaysSupply().longValue());
            prescription.setDispenseRequest(new MedicationOrder.MedicationOrderDispenseRequestComponent().setQuantity(quantity).setExpectedSupplyDuration(numberDaysSupply));
            Money patientPayment = (Money)new Money().setSystem(CODING_SYSTEM_MONEY_US).setValue(sourceEvent.getPatientPayAmount().doubleValue());
            eventItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_PATIENT_PAY)).setAmount(patientPayment);
            Money totalPrescriptionCost = (Money)new Money().setSystem(CODING_SYSTEM_MONEY_US).setValue(sourceEvent.getTotalPrescriptionCost().doubleValue());
            eventItem.addAdjudication().setCategory(new Coding().setSystem(CODING_SYSTEM_ADJUDICATION_CMS).setCode(CODED_ADJUDICATION_TOTAL_COST)).setAmount(totalPrescriptionCost);
        }
        return new BeneficiaryBundle(resources);
    }

    private static void addDiagnosisCode(List<ExplanationOfBenefit.DiagnosisComponent> diagnoses, String diagnosisCode) {
        for (ExplanationOfBenefit.DiagnosisComponent diagnosis : diagnoses) {
            if (!diagnosisCode.equals(diagnosis.getDiagnosis().getCode())) continue;
            return;
        }
        ExplanationOfBenefit.DiagnosisComponent diagnosisComponent = new ExplanationOfBenefit.DiagnosisComponent().setSequence(diagnoses.size());
        diagnosisComponent.getDiagnosis().setSystem(CODING_SYSTEM_ICD9_DIAG).setCode(diagnosisCode);
        diagnoses.add(diagnosisComponent);
    }

    private static int getDiagnosisCodeIndex(List<ExplanationOfBenefit.DiagnosisComponent> diagnoses, String diagnosisCode) {
        for (ExplanationOfBenefit.DiagnosisComponent diagnosis : diagnoses) {
            if (!diagnosisCode.equals(diagnosis.getDiagnosis().getCode())) continue;
            return diagnosis.getSequence();
        }
        throw new IllegalArgumentException();
    }

    private static void addDiagnosisCodeAndLink(ExplanationOfBenefit eob, ExplanationOfBenefit.DetailComponent eobDetail, String diagnosisCode) {
        if (!DataTransformer.isBlank(diagnosisCode)) {
            DataTransformer.addDiagnosisCode(eob.getDiagnosis(), diagnosisCode);
            int diagnosisCodeIndex = DataTransformer.getDiagnosisCodeIndex(eob.getDiagnosis(), diagnosisCode);
            eobDetail.addExtension().setUrl(EXTENSION_CMS_DIAGNOSIS_LINK_ID).setValue((Type)new IntegerType(diagnosisCodeIndex));
        }
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    public Stream<TransformedBundle> transform(Stream<RifRecordEvent<?>> rifStream) {
        return rifStream.map(rifRecordEvent -> {
            if (rifRecordEvent.getRecord() instanceof BeneficiaryRow) {
                return this.transformBeneficiary((RifRecordEvent<BeneficiaryRow>)rifRecordEvent);
            }
            if (rifRecordEvent.getRecord() instanceof PartDEventRow) {
                return this.transformPartDEvent((RifRecordEvent<PartDEventRow>)rifRecordEvent);
            }
            throw new BadCodeMonkeyException("Unhandled record type: " + rifRecordEvent.getRecord());
        });
    }

    private TransformedBundle transformBeneficiary(RifRecordEvent<BeneficiaryRow> rifRecordEvent) {
        if (rifRecordEvent == null) {
            throw new IllegalArgumentException();
        }
        BeneficiaryRow record = (BeneficiaryRow)rifRecordEvent.getRecord();
        if (1 != record.version) {
            throw new IllegalArgumentException("Unsupported record version: " + record.version);
        }
        if (record.recordAction != RecordAction.INSERT) {
            throw new BadCodeMonkeyException();
        }
        Bundle bundle = new Bundle();
        Patient beneficiary = new Patient();
        beneficiary.setId("Patient/" + record.beneficiaryId);
        beneficiary.addIdentifier().setSystem(CODING_SYSTEM_CCW_BENE_ID).setValue(record.beneficiaryId);
        beneficiary.addAddress().setState(record.stateCode).setDistrict(record.countyCode).setPostalCode(record.postalCode);
        DataTransformer.insert(bundle, (Resource)beneficiary);
        Organization cms = new Organization();
        cms.setName(COVERAGE_ISSUER);
        DataTransformer.upsert(bundle, (Resource)cms, "Organization/?name=Centers for Medicare and Medicaid Services");
        Coverage partA = new Coverage();
        partA.setPlan(COVERAGE_PLAN);
        partA.setSubPlan(COVERAGE_PLAN_PART_A);
        partA.setIssuer(new Reference(cms.getId()));
        partA.setSubscriber(new Reference(beneficiary.getId()));
        DataTransformer.insert(bundle, (Resource)partA);
        Coverage partB = new Coverage();
        partB.setPlan(COVERAGE_PLAN);
        partB.setSubPlan(COVERAGE_PLAN_PART_B);
        partB.setIssuer(new Reference(cms.getId()));
        partB.setSubscriber(new Reference(beneficiary.getId()));
        DataTransformer.insert(bundle, (Resource)partA);
        Coverage partD = new Coverage();
        partD.setPlan(COVERAGE_PLAN);
        partD.setSubPlan(COVERAGE_PLAN_PART_D);
        partD.setIssuer(new Reference(cms.getId()));
        partD.setSubscriber(new Reference(beneficiary.getId()));
        DataTransformer.insert(bundle, (Resource)partA);
        return new TransformedBundle(rifRecordEvent, bundle);
    }

    private TransformedBundle transformPartDEvent(RifRecordEvent<PartDEventRow> rifRecordEvent) {
        if (rifRecordEvent == null) {
            throw new IllegalArgumentException();
        }
        PartDEventRow record = (PartDEventRow)rifRecordEvent.getRecord();
        if (1 != record.version) {
            throw new IllegalArgumentException("Unsupported record version: " + record.version);
        }
        if (record.recordAction != RecordAction.INSERT) {
            throw new BadCodeMonkeyException();
        }
        Bundle bundle = new Bundle();
        ExplanationOfBenefit eob = new ExplanationOfBenefit();
        eob.setId((IIdType)IdType.newRandomUuid());
        eob.addIdentifier().setSystem(CODING_SYSTEM_CCW_PDE_ID).setValue(record.partDEventId);
        eob.setPatient(new Reference().setReference("Patient/" + record.beneficiaryId));
        ExplanationOfBenefit.ItemsComponent rxItem = eob.addItem();
        rxItem.setSequence(1);
        if (record.compoundCode == PartDEventRow.COMPOUND_CODE_COMPOUNDED) {
            rxItem.setType(new Coding().setSystem(CODING_SYSTEM_FHIR_ACT).setCode("RXCINV"));
        } else {
            rxItem.setType(new Coding().setSystem(CODING_SYSTEM_FHIR_ACT).setCode("RXDINV"));
        }
        rxItem.setServiced((Type)new DateType().setValue((java.util.Date)Date.valueOf(record.prescriptionFillDate)));
        MedicationOrder medicationOrder = new MedicationOrder();
        medicationOrder.setId((IIdType)IdType.newRandomUuid());
        eob.setPrescription(new Reference().setReference(medicationOrder.getId()));
        DataTransformer.insert(bundle, (Resource)eob);
        return new TransformedBundle(rifRecordEvent, bundle);
    }

    private static void insert(Bundle bundle, Resource resource) {
        if (bundle == null) {
            throw new IllegalArgumentException();
        }
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        if (resource.getId() == null) {
            bundle.addEntry().setResource(resource).getRequest().setMethod(Bundle.HTTPVerb.POST);
        } else {
            bundle.addEntry().setFullUrl(resource.getId()).setResource(resource).getRequest().setMethod(Bundle.HTTPVerb.PUT).setUrl(resource.getId());
        }
    }

    private static void upsert(Bundle bundle, Resource resource, String resourceUrl) {
        if (bundle == null) {
            throw new IllegalArgumentException();
        }
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        if (resource.getId() != null) {
            throw new IllegalArgumentException("FHIR conditional updates don't allow IDs to be specified client-side");
        }
        bundle.addEntry().setResource(resource).getRequest().setMethod(Bundle.HTTPVerb.PUT).setUrl(resourceUrl);
    }
}

