/*
 * Decompiled with CFR 0.152.
 */
package gov.hhs.cms.bluebutton.datapipeline.fhir.transform;

import gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.ClaimType;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu21.model.Coding;
import org.hl7.fhir.dstu21.model.Coverage;
import org.hl7.fhir.dstu21.model.ExplanationOfBenefit;
import org.hl7.fhir.dstu21.model.Patient;
import org.hl7.fhir.instance.model.api.IBaseResource;

public final class BeneficiaryBundle {
    private final List<IBaseResource> fhirResources;

    public BeneficiaryBundle(List<IBaseResource> fhirResources) {
        this.fhirResources = fhirResources;
    }

    public List<IBaseResource> getFhirResources() {
        return this.fhirResources;
    }

    public Patient getPatient() {
        List patients = this.fhirResources.stream().filter(r -> r instanceof Patient).collect(Collectors.toList());
        if (patients.size() != 1) {
            throw new IllegalStateException();
        }
        return (Patient)patients.get(0);
    }

    public Coverage getPartBCoverage() {
        List coverages = this.fhirResources.stream().filter(r -> r instanceof Coverage).map(r -> (Coverage)r).filter(c -> c.getPlan().equals("Part B")).collect(Collectors.toList());
        if (coverages.size() != 1) {
            throw new IllegalStateException();
        }
        return (Coverage)coverages.get(0);
    }

    public Coverage getPartDCoverage() {
        List coverages = this.fhirResources.stream().filter(r -> r instanceof Coverage).map(r -> (Coverage)r).filter(c -> c.getPlan().equals("Part D")).collect(Collectors.toList());
        if (coverages.size() != 1) {
            throw new IllegalStateException();
        }
        return (Coverage)coverages.get(0);
    }

    public List<ExplanationOfBenefit> getExplanationOfBenefitsForInpatient() {
        List<ExplanationOfBenefit> eobs = this.fhirResources.stream().filter(r -> r instanceof ExplanationOfBenefit).map(r -> (ExplanationOfBenefit)r).filter(e -> e.getExtension().stream().filter(x -> "http://bluebutton.cms.hhs.gov/extensions#claimType".equals(x.getUrl()) && ClaimType.INPATIENT_CLAIM.getCode().equals(((Coding)x.getValue()).getCode())).findAny().isPresent()).collect(Collectors.toList());
        return eobs;
    }

    public List<ExplanationOfBenefit> getExplanationOfBenefitsForOutpatient() {
        List<ExplanationOfBenefit> eobs = this.fhirResources.stream().filter(r -> r instanceof ExplanationOfBenefit).map(r -> (ExplanationOfBenefit)r).filter(e -> e.getExtension().stream().filter(x -> "http://bluebutton.cms.hhs.gov/extensions#claimType".equals(x.getUrl()) && ClaimType.OUTPATIENT_CLAIM.getCode().equals(((Coding)x.getValue()).getCode())).findAny().isPresent()).collect(Collectors.toList());
        return eobs;
    }

    public List<ExplanationOfBenefit> getExplanationOfBenefitsForCarrier() {
        List<ExplanationOfBenefit> eobs = this.fhirResources.stream().filter(r -> r instanceof ExplanationOfBenefit).map(r -> (ExplanationOfBenefit)r).filter(e -> e.getExtension().stream().filter(x -> "http://bluebutton.cms.hhs.gov/extensions#claimType".equals(x.getUrl()) && ClaimType.CARRIER_NON_DME_CLAIM.getCode().equals(((Coding)x.getValue()).getCode())).findAny().isPresent()).collect(Collectors.toList());
        return eobs;
    }

    public List<ExplanationOfBenefit> getExplanationOfBenefitsForPartD() {
        List<ExplanationOfBenefit> eobs = this.fhirResources.stream().filter(r -> r instanceof ExplanationOfBenefit).map(r -> (ExplanationOfBenefit)r).filter(eob -> eob.getCoverage().getCoverage().getReference().equals(this.getPartDCoverage().getId())).collect(Collectors.toList());
        return eobs;
    }
}

