/*
 * Decompiled with CFR 0.152.
 */
package gov.hhs.cms.bluebutton.datapipeline.fhir.load;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.IClientInterceptor;
import ca.uhn.fhir.rest.client.IGenericClient;
import ca.uhn.fhir.rest.client.interceptor.LoggingInterceptor;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import gov.hhs.cms.bluebutton.datapipeline.fhir.LoadAppOptions;
import gov.hhs.cms.bluebutton.datapipeline.fhir.load.FhirResult;
import gov.hhs.cms.bluebutton.datapipeline.fhir.transform.BeneficiaryBundle;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.hl7.fhir.dstu21.model.Bundle;
import org.hl7.fhir.dstu21.model.Resource;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public final class FhirLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FhirLoader.class);
    private final MetricRegistry metrics;
    private final IGenericClient client;

    @Inject
    public FhirLoader(MetricRegistry metrics, LoadAppOptions options) {
        this.metrics = metrics;
        FhirContext ctx = FhirContext.forDstu2_1();
        ctx.getRestfulClientFactory().setSocketTimeout(300000);
        IGenericClient client = ctx.newRestfulGenericClient(options.getFhirServer().toString());
        LoggingInterceptor fhirClientLogging = new LoggingInterceptor();
        fhirClientLogging.setLogRequestBody(false);
        fhirClientLogging.setLogResponseBody(false);
        client.registerInterceptor((IClientInterceptor)fhirClientLogging);
        this.client = client;
    }

    public List<FhirResult> insertFhirRecords(Stream<BeneficiaryBundle> dataToLoad) {
        Timer.Context timerContextStream = this.metrics.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"stream"})).time();
        List batchResults = (List)Observable.from(dataToLoad::iterator).buffer(10).map(batch -> this.process((List<BeneficiaryBundle>)batch)).toList().toBlocking().single();
        timerContextStream.stop();
        return batchResults;
    }

    private FhirResult process(List<BeneficiaryBundle> batch) {
        Timer.Context timerContextBatch = this.metrics.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"stream", "batch"})).time();
        Bundle bundle = new Bundle();
        for (BeneficiaryBundle beneficiaryBundle : batch) {
            for (IBaseResource resource : beneficiaryBundle.getFhirResources()) {
                Resource typedResource = (Resource)resource;
                bundle.addEntry().setFullUrl(typedResource.getId()).setResource(typedResource).getRequest().setMethod(Bundle.HTTPVerb.POST);
            }
        }
        LOGGER.trace("Loading bundle with {} beneficiaries and {} resources.", (Object)batch.size(), (Object)bundle.getEntry().size());
        Bundle resultBundle = (Bundle)this.client.transaction().withBundle((IBaseBundle)bundle).execute();
        timerContextBatch.stop();
        this.metrics.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"stream", "processed-beneficiaries"})).mark((long)batch.size());
        this.metrics.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"stream", "processed-resources"})).mark((long)resultBundle.getEntry().size());
        return new FhirResult(resultBundle.getEntry().size());
    }
}

