package gov.hhs.cms.bluebutton.datapipeline.ccw.jdo;

import javax.jdo.query.*;
import org.datanucleus.api.jdo.query.*;

public class QProcedure extends PersistableExpressionImpl<Procedure> implements PersistableExpression<Procedure>
{
    public static final QProcedure jdoCandidate = candidate("this");

    public static QProcedure candidate(String name)
    {
        return new QProcedure(null, name, 5);
    }

    public static QProcedure candidate()
    {
        return jdoCandidate;
    }

    public static QProcedure parameter(String name)
    {
        return new QProcedure(Procedure.class, name, ExpressionType.PARAMETER);
    }

    public static QProcedure variable(String name)
    {
        return new QProcedure(Procedure.class, name, ExpressionType.VARIABLE);
    }

    public final ObjectExpression<java.lang.Long> id;
    public final StringExpression code;

    public QProcedure(PersistableExpression parent, String name, int depth)
    {
        super(parent, name);
        this.id = new ObjectExpressionImpl<java.lang.Long>(this, "id");
        this.code = new StringExpressionImpl(this, "code");
    }

    public QProcedure(Class type, String name, ExpressionType exprType)
    {
        super(type, name, exprType);
        this.id = new ObjectExpressionImpl<java.lang.Long>(this, "id");
        this.code = new StringExpressionImpl(this, "code");
    }
}
