package gov.hhs.cms.bluebutton.datapipeline.ccw.jdo;

import javax.jdo.query.*;
import org.datanucleus.api.jdo.query.*;

public class QPartDEventFact extends PersistableExpressionImpl<PartDEventFact> implements PersistableExpression<PartDEventFact>
{
    public static final QPartDEventFact jdoCandidate = candidate("this");

    public static QPartDEventFact candidate(String name)
    {
        return new QPartDEventFact(null, name, 5);
    }

    public static QPartDEventFact candidate()
    {
        return jdoCandidate;
    }

    public static QPartDEventFact parameter(String name)
    {
        return new QPartDEventFact(PartDEventFact.class, name, ExpressionType.PARAMETER);
    }

    public static QPartDEventFact variable(String name)
    {
        return new QPartDEventFact(PartDEventFact.class, name, ExpressionType.VARIABLE);
    }

    public final ObjectExpression<java.lang.Long> id;
    public final ObjectExpression<java.lang.Long> prescriberNpi;
    public final ObjectExpression<java.lang.Long> serviceProviderNpi;
    public final ObjectExpression<java.lang.Long> productNdc;
    public final gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.QCurrentBeneficiary beneficiary;
    public final LocalDateExpression serviceDate;
    public final ObjectExpression<java.lang.Long> quantityDispensed;
    public final ObjectExpression<java.lang.Long> numberDaysSupply;
    public final ObjectExpression<java.lang.Double> patientPayAmount;
    public final ObjectExpression<java.lang.Double> totalPrescriptionCost;

    public QPartDEventFact(PersistableExpression parent, String name, int depth)
    {
        super(parent, name);
        this.id = new ObjectExpressionImpl<java.lang.Long>(this, "id");
        this.prescriberNpi = new ObjectExpressionImpl<java.lang.Long>(this, "prescriberNpi");
        this.serviceProviderNpi = new ObjectExpressionImpl<java.lang.Long>(this, "serviceProviderNpi");
        this.productNdc = new ObjectExpressionImpl<java.lang.Long>(this, "productNdc");
        if (depth > 0)
        {
            this.beneficiary = new gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.QCurrentBeneficiary(this, "beneficiary", depth-1);
        }
        else
        {
            this.beneficiary = null;
        }
        this.serviceDate = new LocalDateExpressionImpl(this, "serviceDate");
        this.quantityDispensed = new ObjectExpressionImpl<java.lang.Long>(this, "quantityDispensed");
        this.numberDaysSupply = new ObjectExpressionImpl<java.lang.Long>(this, "numberDaysSupply");
        this.patientPayAmount = new ObjectExpressionImpl<java.lang.Double>(this, "patientPayAmount");
        this.totalPrescriptionCost = new ObjectExpressionImpl<java.lang.Double>(this, "totalPrescriptionCost");
    }

    public QPartDEventFact(Class type, String name, ExpressionType exprType)
    {
        super(type, name, exprType);
        this.id = new ObjectExpressionImpl<java.lang.Long>(this, "id");
        this.prescriberNpi = new ObjectExpressionImpl<java.lang.Long>(this, "prescriberNpi");
        this.serviceProviderNpi = new ObjectExpressionImpl<java.lang.Long>(this, "serviceProviderNpi");
        this.productNdc = new ObjectExpressionImpl<java.lang.Long>(this, "productNdc");
        this.beneficiary = new gov.hhs.cms.bluebutton.datapipeline.ccw.jdo.QCurrentBeneficiary(this, "beneficiary", 5);
        this.serviceDate = new LocalDateExpressionImpl(this, "serviceDate");
        this.quantityDispensed = new ObjectExpressionImpl<java.lang.Long>(this, "quantityDispensed");
        this.numberDaysSupply = new ObjectExpressionImpl<java.lang.Long>(this, "numberDaysSupply");
        this.patientPayAmount = new ObjectExpressionImpl<java.lang.Double>(this, "patientPayAmount");
        this.totalPrescriptionCost = new ObjectExpressionImpl<java.lang.Double>(this, "totalPrescriptionCost");
    }
}
